/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.web.context.HttpContext;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.DiscoverIdpHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.RedirectUtils;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;

public class SSOLoginHookContextProvider
implements ContextProvider {
    private final HostApp hostApp;
    private final IdpConfManager idpConfigManager;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;
    private final HttpContext httpContext;

    @Inject
    public SSOLoginHookContextProvider(@ComponentImport HttpContext httpContext, HostAppFactory hostAppFactory, IdpConfManager idpConfigManager, KerbConfManager kerbConfManager, RequireAdminServletDependencyBucket bucket) {
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfigManager = idpConfigManager;
        this.kerbConfManager = kerbConfManager;
        this.userLookupService = bucket.getUserLookupService();
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public static Map<String, Object> getContextMap(HttpServletRequestFacade request, HttpServletResponseFacade response, KerbConfManager kerbConfManager, IdpConfManager idpConfigManager, HostApp hostApp, UserLookupService userLookupService, DiscoverIdpHelper discoverIdpHelper) {
        Map<String, Object> model = new HashMap<String, Object>();
        model.put("shouldLoginManually", hostApp.shouldLoginManually(request, response));
        model.put("shouldDisableRedirect", hostApp.shouldDisableRedirect(request));
        model.put("samlLoginUsernamePlaceholder", kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("nextButtonText", kerbConfManager.getNextButtonText());
        model.put("usernameFieldText", kerbConfManager.getUsernameFieldText());
        model.put("idpListTitleText", kerbConfManager.getIdpListTitleText());
        model.put("forgotPasswordUrl", hostApp.getForgotPasswordUrl());
        model.put("shouldDoSsoAfterLogout", idpConfigManager.isAnyProviderForcingReLoginAfterLogout());
        model.put("loginPageUrl", hostApp.getLoginPage());
        model.put("shouldUseLegacyLoginExperience", hostApp.shouldUseLegacyLoginExperience());
        model.put("redirectProgressDelay", TimeUnit.SECONDS.toMillis(idpConfigManager.getRedirectProgressDelay()));
        model.put("showCustomTextBoxOnLoginPage", kerbConfManager.isCustomTextBoxOnLoginPageEnabled());
        model.put("customTextOnLoginPageWithHtml", kerbConfManager.getCustomTextBoxOnLoginPageContent());
        boolean isAllTraditionalLoginPrevented = TraditionalLoginUtils.shouldTraditionalLoginBePreventedForThisPage(kerbConfManager, userLookupService, hostApp, request);
        boolean isAtLeastOneManualRedirect = idpConfigManager.isAtLeastOneManualRedirect();
        boolean shouldShowLoginWithUsernamePassword = !isAllTraditionalLoginPrevented && idpConfigManager.isUsernamePasswordLinkEnabled();
        model.put("visibleIdentityProviders", idpConfigManager.getIdentityProvidersSortedByLoginDisplayPosition().stream().filter(IdpConfiguration::isEnabled).filter(idp -> idp.getRedirectProperties().isVisible()).collect(Collectors.toList()));
        model.put("isUseIcon", idpConfigManager.isUseIcon());
        boolean isTraditionalLoginPreventedForSomeUsers = kerbConfManager.isTraditionalLoginPrevented() || kerbConfManager.isTraditionalLoginJsmPrevented();
        model.put("isTraditionalLoginPrevented", isTraditionalLoginPreventedForSomeUsers);
        if (isTraditionalLoginPreventedForSomeUsers) {
            model.put("isAllTraditionalLoginPrevented", isAllTraditionalLoginPrevented);
            model.put("traditionalLoginPreventedMessageWithHtml", kerbConfManager.getTraditionalLoginDisabledMessage());
            model.put("allTraditionalLoginPreventedMessageWithHtml", kerbConfManager.getAllTraditionalLoginDisabledMessage());
        }
        if (!hostApp.shouldUseLegacyLoginExperience()) {
            model.put("pluginAdminPath", "/plugins/servlet/" + PluginKey.getPluginKeyBasepart());
            model.put("pluginKey", PluginKey.getPluginKeyBasepart());
            model.put("isAtLeastOneManualRedirect", isAtLeastOneManualRedirect);
            model.put("idpIdHostedDomainMap", RedirectUtils.getIdpIdHostedDomainMap(idpConfigManager));
            model.put("shouldShowLoginWithUsernamePassword", shouldShowLoginWithUsernamePassword);
            model.put("loginHintMap", RedirectUtils.getLoginHintMapForIdentityProviders(idpConfigManager));
            model = kerbConfManager.populateModelWithCustomLoginTexts(model);
            model.put("isAuthenticated", hostApp.isLoggedIn(request));
            boolean kssoAuthAnonymousBrowsingUser = request.getSessionKsso() != null && request.getSessionKsso().getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER") != null;
            model.put("kssoAuthAnonymousBrowsingUser", kssoAuthAnonymousBrowsingUser);
            boolean isIdpDisabledUserAgent = kerbConfManager.isIdpDisabledUserAgent(request.getHeader("User-Agent"));
            model.put("isIdpDisabledUserAgent", isIdpDisabledUserAgent);
            model.putAll(RedirectUtils.getProviderMapForIdentityProviders(request, discoverIdpHelper, idpConfigManager, kerbConfManager));
            int automaticRedirectLength = model.get("autoWithHtml") != null ? ((List)model.get("autoWithHtml")).size() : 0;
            model.put("shouldHideUsernameField", RedirectUtils.shouldHideUsernameField(request, discoverIdpHelper, kerbConfManager, idpConfigManager));
            model.put("isAutomaticRedirectAllowed", RedirectUtils.isAutomaticRedirectAllowed(automaticRedirectLength, hostApp.shouldDisableRedirect(request), hostApp.isLoggedIn(request), hostApp.shouldLoginManually(request, response), idpConfigManager.isAnyProviderForcingReLoginAfterLogout(), kssoAuthAnonymousBrowsingUser, isIdpDisabledUserAgent));
        }
        String destinationAfterRedirect = hostApp.getTargetAfterRedirect(request);
        model.put("destinationAfterRedirect", destinationAfterRedirect);
        return model;
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        HttpServletRequestFacade req = HttpServletRequestFacade.of((HttpServletRequest)this.httpContext.getRequest());
        HttpServletResponseFacade resp = HttpServletResponseFacade.of((HttpServletResponse)this.httpContext.getResponse());
        boolean isJsm = this.hostApp.isJsmLoginPage(req);
        DiscoverIdpHelper discoverIdpHelper = new DiscoverIdpHelper(this.hostApp, this.userLookupService, this.idpConfigManager, isJsm);
        return SSOLoginHookContextProvider.getContextMap(req, resp, this.kerbConfManager, this.idpConfigManager, this.hostApp, this.userLookupService, discoverIdpHelper);
    }
}

