/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.saml.util.ScriptInjector;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;
import org.kantega.atlaskerb.wrapper.webresource.WebResourceManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class BambooLoginFilter
extends FilterFacade {
    private final HttpContext httpContext;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    private final SsoScriptLoginHookUrlReadingCondition SsoScriptLoginHookCondition;
    private final UserLookupService userLookupService;
    private final ScriptInjector scriptInjector;

    @Inject
    public BambooLoginFilter(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport HttpContext httpContext, WebResourceManagerWrapper webResourceManager, HostAppFactory hostAppFactory, RequireAdminServletDependencyBucket bucket, IdpConfManager idpConfManager, SsoScriptLoginHookUrlReadingCondition ssoScriptLoginHookUrlReadingCondition) {
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.httpContext = httpContext;
        this.idpConfManager = idpConfManager;
        this.SsoScriptLoginHookCondition = ssoScriptLoginHookUrlReadingCondition;
        this.userLookupService = bucket.getUserLookupService();
        this.scriptInjector = new ScriptInjector(webResourceManager, templateRenderer, this.kerbConfManager, idpConfManager, hostAppFactory, bucket);
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
    }

    public void doFilterKsso(final HttpServletRequestFacade req, final HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        if (this.hostApp.shouldUseLegacyLoginExperience()) {
            chain.doFilterKsso(req, resp);
            return;
        }
        final boolean enableFederatedSSO = this.SsoScriptLoginHookCondition.shouldDoFederatedSSO(req) && this.idpConfManager.isFederatedSsoEnabled();
        chain.doFilterKsso(req, new HttpServletResponseFacade((HttpServletResponse)resp){
            PrintWriter pw;

            public PrintWriter getWriter() throws IOException {
                if (this.pw == null) {
                    BambooLoginFilter.this.log.debug("Setting up BambooLoginFilter. ServletOutputStream out == null");
                    this.pw = new InjectingWriter(req, resp, BambooLoginFilter.this.hostApp.shouldLoginManually(req, resp), BambooLoginFilter.this.hostApp.shouldDisableRedirect(req), enableFederatedSSO, TraditionalLoginUtils.shouldTraditionalLoginBePreventedForThisPage(BambooLoginFilter.this.kerbConfManager, BambooLoginFilter.this.userLookupService, BambooLoginFilter.this.hostApp, req), super.getWriter(), BambooLoginFilter.this.idpConfManager.getRedirectProgressDelay(), BambooLoginFilter.this.scriptInjector);
                }
                return this.pw;
            }
        });
    }

    public void destroy() {
    }

    private class InjectingWriter
    extends PrintWriter {
        final HttpServletRequestFacade req;
        final HttpServletResponseFacade resp;
        private final int samlRedirectDelay;
        private final boolean manualLogin;
        private final boolean shouldDisableRedirect;
        private final boolean enableSaml;
        private final boolean isTraditionalLoginDisabled;
        private final PrintWriter out;
        private final byte[] headStart;
        private final ScriptInjector scriptInjector;

        public InjectingWriter(HttpServletRequestFacade req, HttpServletResponseFacade resp, boolean manualLogin, boolean shouldDisableRedirect, boolean enableSaml, boolean isTraditionalLoginDisabled, PrintWriter writer, int samlRedirectDelay, ScriptInjector scriptInjector) {
            super(writer);
            this.req = req;
            this.resp = resp;
            this.manualLogin = manualLogin;
            this.shouldDisableRedirect = shouldDisableRedirect;
            this.enableSaml = enableSaml;
            this.isTraditionalLoginDisabled = isTraditionalLoginDisabled;
            this.out = writer;
            this.samlRedirectDelay = samlRedirectDelay;
            this.scriptInjector = scriptInjector;
            this.headStart = "<head>".getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public void write(@NotNull String s, int off, int len) {
            char[] buf = s.toCharArray();
            this.write(buf, off, len);
        }

        @Override
        public void write(@NotNull String s) {
            this.write(s, 0, s.length());
        }

        @Override
        public void write(char[] buf, int off, int len) {
            int head = this.findHeadStart(new String(buf).getBytes(StandardCharsets.UTF_8), off, len);
            if (head != -1) {
                this.out.write(buf, off, head - off + this.headStart.length);
                StringWriter inject = null;
                try {
                    inject = this.scriptInjector.prepareInjectScript(this.req, this.resp, this.isTraditionalLoginDisabled, this.enableSaml, this.manualLogin, this.shouldDisableRedirect, this.samlRedirectDelay, null, null, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.out.write(inject.toString().toCharArray());
                this.out.write(buf, head + this.headStart.length, len - head - this.headStart.length);
            } else {
                this.out.write(buf, off, len);
            }
        }

        private int findHeadStart(byte[] b, int off, int len) {
            for (int i = off; i < off + len - this.headStart.length; ++i) {
                if (!this.findHeadStart(b, i)) continue;
                return i;
            }
            return -1;
        }

        private boolean findHeadStart(byte[] b, int i) {
            for (int h = 0; h < this.headStart.length; ++h) {
                if (b[i + h] == this.headStart[h]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
            this.out.close();
        }
    }
}

