/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.userlookup;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserResolutionException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ksso.scim.spi.ScimServerSpi;
import io.prometheus.client.Summary;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.cache.KerberosUserLookupFromFileCache;
import org.kantega.atlaskerb.diagnostics.metrics.KSSOPluginMetrics;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.kerberos.AtlDirectoryManager;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.userlookup.CheckTransformationHelper;
import org.kantega.atlaskerb.userlookup.UserNameLookup;
import org.kantega.atlaskerb.userlookup.UsernameTransformAction;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.wrapper.crowd.CrowdDirectoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserLookupService
implements DebugInfo {
    public static final String KSSO_TRADITIONAL_LOGIN_ALLOWED = "ksso.traditional.login.allowed";
    public static final String KSSO_BASIC_AUTH_ALLOWED = "ksso.basic.auth.allowed";
    public static final String KSSO_KERBEROS_LOGIN_ALLOWED = "ksso.kerberos.login.allowed";
    private static final Logger log = LoggerFactory.getLogger(UserLookupService.class);
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final AtlDirectoryManager directoryManager;
    private final Map<UsernameTransformAction, Integer> utaWeights = new ConcurrentHashMap<UsernameTransformAction, Integer>();
    private final Queue<UsernameTransformAction> utaIndexLog = new ConcurrentLinkedDeque<UsernameTransformAction>();
    private final KerberosUserLookupFromFileCache kerberosUserLookupFromFileCache;
    private final HostApp hostApp;
    private final Map<String, Boolean> activeDirectoryCache = new ConcurrentHashMap<String, Boolean>();
    private final Cache<String, Object> oneMinuteCache;
    private final ScimConfManager scimConfManager;

    @Inject
    public UserLookupService(@ComponentImport UserManager userManager, KerbConfManager kerbConfManager, HostAppFactory hostAppFactory, AtlDirectoryManager directoryManager, IdpConfManager idpConfManager, KerberosUserLookupFromFileCache kerberosUserLookupFromFileCache, ScimConfManager scimConfManager) {
        this.userManager = userManager;
        this.kerbConfManager = kerbConfManager;
        this.directoryManager = directoryManager;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.kerberosUserLookupFromFileCache = kerberosUserLookupFromFileCache;
        this.scimConfManager = scimConfManager;
    }

    private void registerUta(UsernameTransformAction action) {
        int MAX_LOG_SIZE = 100;
        Integer count = this.getUtaWeights().get((Object)action);
        if (count == null) {
            this.getUtaWeights().put(action, 1);
        } else {
            this.getUtaWeights().put(action, count + 1);
        }
        if (this.utaIndexLog.size() <= 100) {
            return;
        }
        UsernameTransformAction removedAction = this.utaIndexLog.remove();
        this.getUtaWeights().put(removedAction, this.getUtaWeights().get((Object)removedAction) - 1);
    }

    private Collection<UsernameTransformAction> sortAndFilterUTAs(Collection<UsernameTransformAction> unsortedUTAs, boolean onlyRegexTransformationLookup) {
        if (onlyRegexTransformationLookup && this.kerbConfManager.isRegexLookupEnabled() && !StringUtils.isBlank((CharSequence)this.kerbConfManager.getKerberosMultiRegex())) {
            if (unsortedUTAs.contains((Object)UsernameTransformAction.REGEX)) {
                return Collections.singletonList(UsernameTransformAction.REGEX);
            }
            return Collections.emptyList();
        }
        if (this.kerbConfManager.isLookupUsernameFromMappingFile()) {
            return unsortedUTAs;
        }
        if (this.getUtaWeights().isEmpty()) {
            return unsortedUTAs;
        }
        ArrayList<UsernameTransformAction> utaList = new ArrayList<UsernameTransformAction>(unsortedUTAs);
        utaList.forEach(transformAction -> {
            if (!this.getUtaWeights().containsKey(transformAction)) {
                this.getUtaWeights().put((UsernameTransformAction)((Object)transformAction), 0);
            }
        });
        utaList.sort((uta1, uta2) -> this.getUtaWeights().get(uta2).compareTo(this.getUtaWeights().get(uta1)));
        if (utaList.remove((Object)UsernameTransformAction.REGEX)) {
            utaList.add(0, UsernameTransformAction.REGEX);
        }
        return utaList;
    }

    Map<UsernameTransformAction, Integer> getUtaWeights() {
        return this.utaWeights;
    }

    public Collection<UsernameTransformAction> sortAndFilterUTAs(Map<UsernameTransformAction, String> lookupNames, boolean onlyRegexTransformationLookup) {
        return new ArrayList<UsernameTransformAction>(this.sortAndFilterUTAs(lookupNames.keySet(), onlyRegexTransformationLookup));
    }

    public PrincipalEntry lookupUserForKerberos(String userPrincipalName, boolean addDefaultGroups) {
        for (Directory directory : this.getActiveUserDirectories()) {
            Map<UsernameTransformAction, String> lookupNames = this.findLookupNamesInDir(userPrincipalName, directory);
            java.util.List sortedUTAs = (java.util.List)this.sortAndFilterUTAs(lookupNames, this.kerbConfManager.isOnlyRegexTransformationLookup());
            if (lookupNames.isEmpty()) continue;
            for (UsernameTransformAction action : sortedUTAs) {
                PrincipalEntry principalEntry = this.resolveUserInDirectory(directory, lookupNames.get((Object)action), addDefaultGroups);
                this.addToGroupIfHasRequiredGroup(principalEntry);
                if (principalEntry.getUserState() == PrincipalEntry.UserState.NOT_FOUND || principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) continue;
                this.registerUta(action);
                return principalEntry;
            }
        }
        Map<UsernameTransformAction, String> fallbackNames = this.getAccountNamesForLookup(userPrincipalName);
        return this.resolveUser(fallbackNames);
    }

    private void addToGroupIfHasRequiredGroup(PrincipalEntry principalEntry) {
        if (principalEntry.getPrincipal().isPresent() && this.kerbConfManager.getGroupAddMapping() != null && !this.kerbConfManager.getGroupAddMapping().isEmpty()) {
            this.kerbConfManager.getGroupAddMapping().forEach(item -> {
                JSONObject groupMapping = (JSONObject)item;
                if (StringUtils.isBlank((CharSequence)groupMapping.getString("requiredGroup")) || this.hostApp.getCrowdService().isUserMemberOfGroup(principalEntry.getPrincipal().get().getName(), groupMapping.getString("requiredGroup"))) {
                    log.debug("Adding user to group {} because they are a member of group {}", groupMapping.get("addedGroup"), groupMapping.get("requiredGroup"));
                    this.hostApp.addUserToGroup(principalEntry.getPrincipal().get(), (String)groupMapping.get("addedGroup"));
                }
            });
        }
    }

    @NotNull
    public PrincipalEntry resolveUser(String username) {
        return (PrincipalEntry)Option.of((Object)username).map(arg_0 -> ((CrowdService)this.hostApp.getCrowdService()).getUser(arg_0)).toTry().mapTry((CheckedFunction1 & Serializable)user -> new PrincipalEntry(this.userManager.resolve(username), user.isActive() ? PrincipalEntry.UserState.FOUND : PrincipalEntry.UserState.INACTIVE)).onFailure(UserResolutionException.class, e -> log.debug("User not found: {}", (Object)username)).toOption().onEmpty(() -> log.debug("No users resolved for username " + username)).getOrElse((Object)new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND));
    }

    @NotNull
    private PrincipalEntry resolveUser(Map<UsernameTransformAction, String> lookupNames) {
        CrowdService crowdService = this.hostApp.getCrowdService();
        ArrayList<UsernameTransformAction> sortedUTAs = new ArrayList<UsernameTransformAction>(this.sortAndFilterUTAs(lookupNames.keySet(), this.kerbConfManager.isOnlyRegexTransformationLookup()));
        for (UsernameTransformAction action : sortedUTAs) {
            String username = lookupNames.get((Object)action);
            User user = null;
            if (username != null) {
                user = crowdService.getUser(username);
            }
            if (user == null) continue;
            log.debug("Resolved user {}", (Object)username);
            this.registerUta(action);
            PrincipalEntry.UserState state = user.isActive() ? PrincipalEntry.UserState.FOUND : PrincipalEntry.UserState.INACTIVE;
            return new PrincipalEntry(this.userManager.resolve(username), state);
        }
        log.debug("No users resolved");
        return new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
    }

    public PrincipalEntry resolveUserInDirectory(Directory directory, String username, boolean addDefaultGroups) {
        return this.resolveUserInDirectory(directory, username, addDefaultGroups, IdpConfiguration.UserLookupAttribute.USERNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalEntry resolveUserInDirectory(Directory directory, String incomingUsername, boolean addDefaultGroups, IdpConfiguration.UserLookupAttribute userLookupAttribute) {
        try (Summary.Timer timer = KSSOPluginMetrics.resolveUserInDirectoryLatency.startTimer();){
            com.atlassian.crowd.model.user.User user = null;
            if (userLookupAttribute == IdpConfiguration.UserLookupAttribute.USERNAME || directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.DELEGATING) {
                user = this.hostApp.getDirectoryManager().findUserByName(directory.getId().longValue(), incomingUsername);
            } else if (userLookupAttribute == IdpConfiguration.UserLookupAttribute.MAIL) {
                user = this.getFromMail(directory, incomingUsername, user);
            } else if (userLookupAttribute == IdpConfiguration.UserLookupAttribute.SCIM_IdP_externalId) {
                user = this.getUserFromScimExternalId(directory, incomingUsername, user);
            }
            if (user == null) {
                log.debug("User not found in directory {} looking up using {}", (Object)directory.getName(), (Object)userLookupAttribute);
                PrincipalEntry principalEntry = new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
                return principalEntry;
            }
            log.debug(String.format("Found user.name '%s', user.firstname: '%s', user.lastname: '%s' in directory '%s' from username searched '%s'", user.getName(), user.getFirstName(), user.getLastName(), directory.getName(), incomingUsername));
            this.doUserRelatedChanges(directory, user);
            if (user.isActive()) {
                log.debug("Calling userManager.resolve for user {}", (Object)user.getName());
                PrincipalEntry principalEntry = new PrincipalEntry(this.userManager.resolve(user.getName()), PrincipalEntry.UserState.FOUND);
                this.setDefaultGroups(directory, addDefaultGroups, principalEntry, user);
                PrincipalEntry principalEntry2 = principalEntry;
                return principalEntry2;
            }
            log.debug("Creating PrincipalEntry using userManager.resolve for user {}", (Object)user.getName());
            PrincipalEntry principalEntry = new PrincipalEntry(this.userManager.resolve(user.getName()), PrincipalEntry.UserState.INACTIVE);
            return principalEntry;
        }
        return new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
    }

    @Nullable
    private PrincipalEntry handleUserNotFound(Directory directory, String incomingUsername, UserNotFoundException unf) {
        log.debug("User not found in this directory: {}", (Object)unf.getMessage());
        if (directory.getType() == DirectoryType.DELEGATING && !this.isJITDirectory(directory.getId())) {
            boolean createUser = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.auto.create.user"));
            if (createUser && this.hostApp.createDelegatedUser(directory, incomingUsername)) {
                try {
                    return new PrincipalEntry(this.userManager.resolve(incomingUsername), PrincipalEntry.UserState.FOUND);
                }
                catch (IllegalStateException e) {
                    log.debug("Could not find user: {} in delegated directory: {}.", (Object)incomingUsername, (Object)directory.getName());
                }
            } else {
                log.debug("Could not find user: {} in directory: {}.", (Object)incomingUsername, (Object)directory.getName());
            }
        } else {
            log.debug("Could not find user: {} in user directory: {}.", (Object)incomingUsername, (Object)directory.getName());
        }
        return null;
    }

    private void setDefaultGroups(Directory directory, boolean addDefaultGroups, PrincipalEntry principalEntry, com.atlassian.crowd.model.user.User user) {
        if (addDefaultGroups && principalEntry.getPrincipal().isPresent() && "true".equals(directory.getAttributes().get("ksso.default.groups.enabled"))) {
            log.debug("Calling setDefaultGroups for user {}", (Object)user.getName());
            this.hostApp.setDefaultGroups(principalEntry.getPrincipal().get(), directory);
        }
    }

    private void doUserRelatedChanges(Directory directory, com.atlassian.crowd.model.user.User user) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        if (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR) {
            log.debug("Calling optionallyUpdateUserFromRemoteDirectory for user {}", (Object)user.getName());
            this.hostApp.optionallyUpdateUserFromRemoteDirectory(user.getName(), directory, this.isNewlyCreatedUser(user));
            if (directory.getType() == DirectoryType.CROWD) {
                log.debug("Calling optionallyAddCrowdGroups for user {}", (Object)user.getName());
                this.hostApp.optionallyAddCrowdGroups(user);
            }
        } else if (directory.getType() == DirectoryType.DELEGATING && !this.isJITDirectory(directory.getId())) {
            log.debug("Calling optionallyUpdateDelegatedUser for user {}", (Object)user.getName());
            this.hostApp.optionallyUpdateDelegatedUser(directory, user);
        }
    }

    private com.atlassian.crowd.model.user.User getFromMail(Directory directory, String incomingUsername, com.atlassian.crowd.model.user.User user) throws DirectoryNotFoundException, OperationFailedException {
        java.util.List<com.atlassian.crowd.model.user.User> usersSearched = this.findActiveUsersByEmailInDirectory(directory, incomingUsername);
        if (usersSearched.size() == 1) {
            user = usersSearched.get(0);
        } else if (usersSearched.isEmpty()) {
            log.debug("User lookup using email {} not found in directory {}", (Object)incomingUsername, (Object)directory.getName());
        } else {
            log.error("User lookup using email {} found {} users in directory {}. Will not log in the user since this email is not unique.", new Object[]{incomingUsername, usersSearched.size(), directory.getName()});
        }
        return user;
    }

    private com.atlassian.crowd.model.user.User getUserFromScimExternalId(Directory directory, String username, com.atlassian.crowd.model.user.User user) {
        io.vavr.collection.Map<String, Directory> directories = this.scimConfManager.findScimDirectories();
        for (String tenantId : directories.keySet()) {
            if (!directory.getId().equals(((Directory)directories.get((Object)tenantId).get()).getId())) continue;
            try {
                User foundUser = ((ScimServerSpi)this.scimConfManager.getScimServerSpi(tenantId).get()).lookupExistingUserFromIdpExternalId(username, directory.getId().longValue());
                if (foundUser == null) continue;
                user = (com.atlassian.crowd.model.user.User)foundUser;
                log.debug("Found user {} in directory tenantId {} directoryId {} using SCIM IdP externalId {}", new Object[]{user.getName(), tenantId, directory.getId(), username});
            }
            catch (Exception e) {
                log.error("Error looking up user by SCIM IdP externalId {} in directory {}", new Object[]{username, tenantId, e});
            }
        }
        return user;
    }

    private java.util.List<com.atlassian.crowd.model.user.User> findActiveUsersByEmailInDirectory(Directory directory, String username) throws DirectoryNotFoundException, OperationFailedException {
        BooleanRestrictionImpl restriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)username), new TermRestriction(UserTermKeys.ACTIVE, MatchMode.EXACTLY_MATCHES, (Object)true)});
        java.util.List usersWithEmail = this.hostApp.getDirectoryManager().searchUsers(directory.getId().longValue(), (EntityQuery)new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)restriction, 0, 2));
        return usersWithEmail;
    }

    public PrincipalEntry resolveUserInDirectories(String username, boolean addDefaultGroups) {
        for (Directory directory : this.getActiveUserDirectories()) {
            PrincipalEntry principalEntry = this.resolveUserInDirectory(directory, username, addDefaultGroups);
            if (principalEntry.getUserState() == PrincipalEntry.UserState.NOT_FOUND) continue;
            return principalEntry;
        }
        Map<UsernameTransformAction, String> fallbackNames = this.getAccountNamesForLookup(username);
        log.debug("Looking up fallback users: {}", fallbackNames);
        return this.resolveUser(fallbackNames);
    }

    private boolean isNewlyCreatedUser(com.atlassian.crowd.model.user.User user) {
        boolean newlyCreatedUser = true;
        if (user instanceof TimestampedUser) {
            TimestampedUser tUser = (TimestampedUser)user;
            Instant creationInstant = tUser.getCreatedDate().toInstant();
            if (creationInstant.isBefore(Instant.now().minusSeconds(60L))) {
                newlyCreatedUser = false;
            }
        } else {
            log.debug("User {} not instance of TimestampedUser ({}); cannot determine if newly created", (Object)user.getName(), (Object)user.getClass());
        }
        return newlyCreatedUser;
    }

    public Map<UsernameTransformAction, String> findLookupNamesInDir(String userPrincipalName, Directory directory) {
        return this.findLookupNamesInDir(userPrincipalName, directory, this.kerbConfManager.getKerberosMultiRegex(), this.kerbConfManager.getAdditionalUserSuffix());
    }

    public Map<UsernameTransformAction, String> findLookupNamesInDir(String userPrincipalName, Directory directory, String kerberosMultiRegex, String additionalUserSuffix) {
        String usernameFromFile;
        LinkedHashMap<UsernameTransformAction, String> lookupNames = new LinkedHashMap<UsernameTransformAction, String>();
        String transformedPrincipalName = null;
        if (this.kerbConfManager.isRegexLookupEnabled() && StringUtils.isNotBlank((CharSequence)kerberosMultiRegex)) {
            transformedPrincipalName = UserMappingUtils.transformUsername(userPrincipalName, CheckTransformationHelper.getRegexTuplesFromJsonArray(new JSONArray(kerberosMultiRegex))).orElse(userPrincipalName);
        }
        if (StringUtils.isNotBlank((CharSequence)(usernameFromFile = this.lookupUsernameFromFile(userPrincipalName)))) {
            lookupNames.put(UsernameTransformAction.USERNAME_FROM_MAPPING_FILE, usernameFromFile);
        } else {
            lookupNames.put(UsernameTransformAction.USERNAME_FROM_MAPPING_FILE, userPrincipalName);
        }
        if (StringUtils.isNotBlank((CharSequence)transformedPrincipalName)) {
            lookupNames.put(UsernameTransformAction.REGEX, transformedPrincipalName);
        }
        if (this.isMicrosoftActiveDirectory(directory)) {
            if (UserLookupService.isUpnRealmMatchesDirectory(userPrincipalName, directory)) {
                Map<UsernameTransformAction, String> msUsernames = this.getActiveDirectoryAccountNamesForLookup(userPrincipalName, directory);
                lookupNames.putAll(msUsernames);
                log.debug("Adding search accounts names for microsoft active directory {}", (Object)directory.getName());
            }
            return lookupNames;
        }
        return this.fallBackAccountNamesForLookup(userPrincipalName, directory, additionalUserSuffix, lookupNames);
    }

    private String lookupUsernameFromFile(String userPrincipalName) {
        if (this.kerbConfManager.isLookupUsernameFromMappingFile()) {
            return this.kerberosUserLookupFromFileCache.lookupUsername(userPrincipalName);
        }
        return null;
    }

    @NotNull
    private Map<UsernameTransformAction, String> fallBackAccountNamesForLookup(String userPrincipalName, Directory directory, String additionalUserSuffix, Map<UsernameTransformAction, String> lookupNames) {
        Map<UsernameTransformAction, String> usernames = this.getAccountNamesForLookup(userPrincipalName, additionalUserSuffix);
        lookupNames.putAll(usernames);
        log.debug("getAccountNamesForLookup was called for directory {}", (Object)directory.getName());
        return lookupNames;
    }

    private Map<UsernameTransformAction, String> getActiveDirectoryAccountNamesForLookup(String userPrincipalName, Directory directory) {
        LinkedHashMap<UsernameTransformAction, String> msLookupNames = new LinkedHashMap<UsernameTransformAction, String>();
        if (StringUtils.isNotBlank((CharSequence)userPrincipalName)) {
            String userPart = userPrincipalName.substring(0, userPrincipalName.lastIndexOf("@"));
            if (userPart.contains("@")) {
                String username = new UserNameLookup(directory.getAttributes(), this.hostApp, this.kerbConfManager).lookupUserNameFromUserPrincipalName(userPart);
                if (StringUtils.isNotBlank((CharSequence)username)) {
                    msLookupNames.put(UsernameTransformAction.USER_PRINCIPAL_NAME, username);
                }
            } else if (this.isNonStandardUsernameDirectory(directory)) {
                String nonSamAccountName = new UserNameLookup(directory.getAttributes(), this.hostApp, this.kerbConfManager).lookupUserNameFromSamAccountNameAtRealm(userPrincipalName);
                log.debug(String.format("Looked up username '%s' from AD user directory '%s' using sAMAccountName '%s'", nonSamAccountName, directory.getName(), userPart));
                if (StringUtils.isNotBlank((CharSequence)nonSamAccountName)) {
                    msLookupNames.put(UsernameTransformAction.NON_STANDARD_NAME_ATTRIBUTE, nonSamAccountName);
                }
            } else {
                msLookupNames.put(UsernameTransformAction.SAM_ACCOUNT_NAME, userPrincipalName.substring(0, userPrincipalName.indexOf("@")));
            }
        }
        return msLookupNames;
    }

    static boolean isUpnRealmMatchesDirectory(String userPrincipalName, Directory directory) {
        Map attributes = directory.getAttributes();
        String baseDn = (String)attributes.get("ldap.basedn");
        String userDn = (String)attributes.get("ldap.user.dn");
        if (StringUtils.isBlank((CharSequence)baseDn)) {
            return false;
        }
        String searchBase = StringUtils.isNotBlank((CharSequence)userDn) ? userDn + "," + baseDn : baseDn;
        String logDetails = String.format("Performing isUpnRealmMatchesDirectory basedn: '%s', userDn '%s', searchBase: '%s' and userPrincipalName: '%s'", baseDn, userDn, searchBase, userPrincipalName);
        SanitizedLogStatement.of(logDetails).andThenLog(arg_0 -> ((Logger)log).debug(arg_0));
        String realm = userPrincipalName.substring(userPrincipalName.lastIndexOf("@") + 1);
        return UserLookupService.isRealmMatchesLdapName(realm, baseDn, searchBase);
    }

    static boolean isRealmMatchesLdapName(String realm, String baseDn, String searchBase) {
        try {
            String normalizedBaseDn = UserLookupService.toNormalizedDomainName(new LdapName(baseDn));
            String normalizedSearchBase = UserLookupService.toNormalizedDomainName(new LdapName(searchBase));
            return StringUtils.endsWithIgnoreCase((CharSequence)normalizedSearchBase, (CharSequence)realm) || StringUtils.endsWithIgnoreCase((CharSequence)realm, (CharSequence)normalizedBaseDn);
        }
        catch (InvalidNameException e) {
            log.debug("Invalid searchBase {} and baseDn {}. Will be unable to determine match for realm {}", new Object[]{searchBase, baseDn, realm});
            return false;
        }
    }

    private static String toNormalizedDomainName(LdapName ldapName) {
        return ldapName.getRdns().stream().filter(rdn -> StringUtils.equalsIgnoreCase((CharSequence)"dc", (CharSequence)rdn.getType())).map(rdn -> (String)rdn.getValue()).map(StringUtils::upperCase).reduce("", (a, b) -> StringUtils.isBlank((CharSequence)a) ? b : b + "." + a);
    }

    Map<UsernameTransformAction, String> getAccountNamesForLookup(String maybeUserPrincipalName, String additionalUserSuffix) {
        HashMap<UsernameTransformAction, String> usernames = new HashMap<UsernameTransformAction, String>();
        Option.of((Object)maybeUserPrincipalName).filter(StringUtils::isNotBlank).peek(userPrincipalName -> {
            String username = StringUtils.substringBefore((String)userPrincipalName, (String)"@");
            usernames.put(UsernameTransformAction.USERNAME, username);
            String usernameFromFile = this.lookupUsernameFromFile((String)userPrincipalName);
            usernames.put(UsernameTransformAction.USERNAME_FROM_MAPPING_FILE, usernameFromFile != null ? usernameFromFile : username);
            usernames.put(UsernameTransformAction.USERNAME_LOWERCASE, username.toLowerCase());
            usernames.put(UsernameTransformAction.USERNAME_UPPERCASE, username.toUpperCase());
            usernames.put(UsernameTransformAction.USER_PRINCIPAL_NAME, (String)userPrincipalName);
            usernames.put(UsernameTransformAction.USER_PRINCIPAL_NAME_LOWERCASE, userPrincipalName.toLowerCase());
            usernames.put(UsernameTransformAction.USER_PRINCIPAL_NAME_UPPERCASE, userPrincipalName.toUpperCase());
            if (additionalUserSuffix != null) {
                String additional = username + "@" + additionalUserSuffix;
                usernames.put(UsernameTransformAction.ADDITIONAL_SUFFIX, additional);
                usernames.put(UsernameTransformAction.ADDITIONAL_SUFFIX_LOWERCASE, additional.toLowerCase());
                usernames.put(UsernameTransformAction.ADDITIONAL_SUFFIX_UPPERCASE, additional.toUpperCase());
            }
        });
        return usernames;
    }

    public Map<UsernameTransformAction, String> getAccountNamesForLookup(String userPrincipalName) {
        return this.getAccountNamesForLookup(userPrincipalName, this.kerbConfManager.getAdditionalUserSuffix());
    }

    public java.util.List<Directory> getActiveUserDirectories() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (!directory.isActive()) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public java.util.List<Directory> getDirectoriesAllowingKerberosLogin() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_KERBEROS_LOGIN_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    private java.util.List<Directory> getDirectoriesAllowingTraditionalLogin() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_TRADITIONAL_LOGIN_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    private java.util.List<Directory> getDirectoriesAllowingBasicAuth() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_BASIC_AUTH_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public java.util.List<Directory> getCachedDirectoriesAllowingBasicAuth() {
        try {
            java.util.List dirs = (java.util.List)this.oneMinuteCache.get((Object)"getDirectoriesAllowingBasicAuth", this::getDirectoriesAllowingBasicAuth);
            return dirs;
        }
        catch (ExecutionException e) {
            return new ArrayList<Directory>();
        }
        catch (Exception e) {
            log.debug("getCachedDirectoriesAllowingBasicAuth - failed to extract cache.");
            return null;
        }
    }

    public java.util.List<Directory> getCachedDirectoriesAllowingTraditionalLogin() {
        try {
            java.util.List dirs = (java.util.List)this.oneMinuteCache.get((Object)"getDirectoriesAllowingTraditionalLogin", this::getDirectoriesAllowingTraditionalLogin);
            return dirs;
        }
        catch (ExecutionException e) {
            return new ArrayList<Directory>();
        }
        catch (Exception e) {
            log.debug("getCachedDirectoriesAllowingTraditionalLogin - failed to extract cache.");
            return null;
        }
    }

    public void invalidateDirectoriesCache() {
        this.oneMinuteCache.invalidateAll();
    }

    private boolean isNonStandardUsernameDirectory(Directory directory) {
        String usernameAttribute = (String)directory.getAttributes().get("ldap.user.username");
        return this.isMicrosoftActiveDirectory(directory) && usernameAttribute != null && !"sAMAccountName".equalsIgnoreCase(usernameAttribute);
    }

    private boolean isMicrosoftActiveDirectory(Directory directory) {
        if (directory.getType() != DirectoryType.DELEGATING && directory.getType() != DirectoryType.CONNECTOR) {
            return false;
        }
        if (this.isDirectoryType(directory, "com.atlassian.crowd.directory.MicrosoftActiveDirectory")) {
            return true;
        }
        if (!this.isDirectoryType(directory, "com.atlassian.crowd.directory.GenericLDAP")) {
            return false;
        }
        String key = UserLookupService.getAdCacheKey(directory);
        Boolean cached = this.activeDirectoryCache.get(key);
        if (Boolean.TRUE.equals(cached)) {
            return true;
        }
        if (Boolean.FALSE.equals(cached)) {
            return false;
        }
        try {
            boolean isAD = this.directoryManager.getDomainDirectory(directory).isActiveDirectory();
            this.activeDirectoryCache.put(key, isAD);
            return isAD;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public java.util.List<CrowdDirectoryWrapper> getVelocityCompatibleActiveUserDirectories() {
        return this.getActiveUserDirectories().stream().map(CrowdDirectoryWrapper::new).collect(Collectors.toList());
    }

    private boolean isDirectoryType(Directory directory, String type) {
        return directory.getImplementationClass() != null && (type.equals(directory.getImplementationClass()) || directory.getAttributes() != null && "com.atlassian.crowd.directory.MicrosoftActiveDirectory".equals(directory.getAttributes().get("crowd.delegated.directory.type")));
    }

    private static String getAdCacheKey(Directory directory) {
        return directory.getId().toString() + "-" + directory.getUpdatedDate().getTime();
    }

    public boolean isLdapDirectory(Directory directory) {
        return directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.DELEGATING;
    }

    public boolean hasWritableCrowdDirectory() {
        for (Directory directory : this.getActiveUserDirectories()) {
            if (directory.getType() != DirectoryType.CROWD || !directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveLDAPDirectories() {
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!this.isLdapDirectory(directory)) continue;
            return true;
        }
        return false;
    }

    private boolean isJITDirectory(Long directoryId) {
        Iterator<IdpConfiguration> iterator = this.idpConfManager.getIdentityProviders().iterator();
        if (iterator.hasNext()) {
            IdpConfiguration idpConfig = iterator.next();
            boolean isJITActive = idpConfig.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idpConfig.getUserUpdateNamePolicy() == IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME || idpConfig.getUserUpdateEmailPolicy() == IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL || idpConfig.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE;
            return idpConfig.getJitDirectory().isPresent() && idpConfig.getJitDirectory().get().equals(directoryId) && isJITActive;
        }
        return false;
    }

    public boolean hasUserAccess(String username) {
        if (!this.hostApp.shouldCheckUserAccess()) {
            return true;
        }
        if (username != null) {
            JiraHostApp.CanUseStatus canUseStatus = new JiraHostApp.CanUseStatus(username).invoke();
            return canUseStatus.hasAnyRole() || canUseStatus.hasGlobalAdminPermission();
        }
        return false;
    }

    public java.util.List<UsernameSearchResult> searchUserAccount(String searchUsername, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, boolean addDefaultGroups) {
        ArrayList<UsernameSearchResult> results = new ArrayList<UsernameSearchResult>();
        for (Directory directory : this.getActiveUserDirectories()) {
            PrincipalEntry pe;
            String userLookupName = searchUsername;
            if (this.isLdapDirectory(directory) && userNotFoundPolicy == IdpConfiguration.UserNotFoundPolicy.REJECT && userLookupAttribute != IdpConfiguration.UserLookupAttribute.USERNAME) {
                String ldapUsername = new UserNameLookup(directory.getAttributes(), this.hostApp, this.kerbConfManager).lookupUserNameFromAttribute(userLookupAttribute.getAttributeName(), userLookupName);
                if (ldapUsername != null) {
                    userLookupName = ldapUsername;
                } else {
                    results.add(UsernameSearchResult.notFound(directory));
                    continue;
                }
            }
            if ((pe = this.resolveUserInDirectory(directory, userLookupName, addDefaultGroups, userLookupAttribute)).getUserState() != PrincipalEntry.UserState.NOT_FOUND) {
                if (pe.getUserState() == PrincipalEntry.UserState.FOUND && pe.getPrincipal().isPresent()) {
                    String userAccountName = pe.getPrincipal().get().getName();
                    UserProfile userProfile = this.userManager.getUserProfile(userAccountName);
                    results.add(UsernameSearchResult.resolved(directory, pe, userProfile));
                    return results;
                }
                results.add(UsernameSearchResult.inactive(directory, pe));
                continue;
            }
            results.add(UsernameSearchResult.notFound(directory));
        }
        return results;
    }

    public boolean isUserInAllowedDirectoryOrGroup(java.util.List<Directory> dirsAllowing, HostApp hostApp, Set<String> allowingLoginGroups, Set<String> disallowingLoginGroups, String username, AuthMethod authMethod) {
        try {
            java.util.List<UsernameSearchResult> usernameSearchResult = null;
            if (username != null) {
                usernameSearchResult = this.searchUserAccount(username, IdpConfiguration.UserNotFoundPolicy.REJECT, IdpConfiguration.UserLookupAttribute.USERNAME, false);
            }
            if (usernameSearchResult != null) {
                UsernameSearchResult userFound = null;
                for (UsernameSearchResult userResult : usernameSearchResult) {
                    if (userResult == null || userResult.getUserProfile() == null) continue;
                    userFound = userResult;
                }
                if (userFound != null) {
                    switch (authMethod) {
                        case KERBEROS: {
                            return this.isUserAllowedToLoginWithKerberos(dirsAllowing, hostApp, allowingLoginGroups, disallowingLoginGroups, username, userFound);
                        }
                        case LOCAL_LOGIN: {
                            return this.isUserAllowedToLoginWithTraditionalLogin(dirsAllowing, hostApp, allowingLoginGroups, disallowingLoginGroups, username, userFound);
                        }
                        case BASIC_AUTH: {
                            return this.isUserAllowedToLoginWithBasicAuth(dirsAllowing, hostApp, allowingLoginGroups, disallowingLoginGroups, username, userFound);
                        }
                    }
                }
            }
        }
        catch (RuntimeException r) {
            log.error(ErrorUtils.createErrorMessage((String)"KSSO-KILKDR1VEI", (String)("Problem when searching for user in directory: " + String.valueOf(r))));
        }
        return false;
    }

    private boolean isUserAllowedToLoginWithTraditionalLogin(java.util.List<Directory> dirsAllowing, HostApp hostApp, Set<String> allowingLoginGroups, Set<String> disallowingLoginGroups, String username, UsernameSearchResult userFound) {
        Directory usernameDirectory = userFound.getDirectory();
        for (Directory dir : dirsAllowing) {
            if (!dir.getId().equals(usernameDirectory.getId())) continue;
            log.debug("[ALLOW DIR] User {} allowed exception to blocked traditional login since they are in the configured user directory {}({})", new Object[]{username, dir.getName(), dir.getId()});
            return true;
        }
        for (String group : allowingLoginGroups) {
            if (!hostApp.isUserInGroup(username, group)) continue;
            log.debug("[ALLOW GROUP] User {} allowed exception to blocked traditional login since they are member of the configured group {}", (Object)username, (Object)group);
            return true;
        }
        if (!disallowingLoginGroups.isEmpty()) {
            boolean allowUsernamePassword = true;
            for (String group : disallowingLoginGroups) {
                if (!hostApp.isUserInGroup(username, group)) continue;
                allowUsernamePassword = false;
                log.debug("[DENY GROUP] User {} denied access to traditional login since they are member of the configured group {}", (Object)username, (Object)group);
                break;
            }
            return allowUsernamePassword;
        }
        return false;
    }

    private boolean isUserAllowedToLoginWithBasicAuth(java.util.List<Directory> dirsAllowing, HostApp hostApp, Set<String> allowingLoginGroups, Set<String> disallowingLoginGroups, String username, UsernameSearchResult userFound) {
        boolean userAllowedToLogin = false;
        switch (this.kerbConfManager.getBasicAuthPermissionSomeUsersConfig()) {
            case DIRECTORY: {
                userAllowedToLogin = UserLookupService.isUserInAllowedDirectory(dirsAllowing, username, userFound);
                log.debug("User {} allowed exception to blocked Basic Auth login since they are in the configured user directory.", (Object)username);
                break;
            }
            case GROUP: {
                userAllowedToLogin = UserLookupService.isUserInAllowedGroup(hostApp, allowingLoginGroups, disallowingLoginGroups, username, this.kerbConfManager.getBasicAuthPermissionGroup());
                log.debug("User {} allowed exception to blocked Basic Auth login login since they are in the configured user group.", (Object)username);
                break;
            }
            case DIRECTORY_OR_GROUP: {
                userAllowedToLogin = UserLookupService.isUserInAllowedGroup(hostApp, allowingLoginGroups, disallowingLoginGroups, username, this.kerbConfManager.getBasicAuthPermissionGroup()) || UserLookupService.isUserInAllowedDirectory(dirsAllowing, username, userFound);
                log.debug("User {} allowed exception to blocked Basic Auth login login since they are in the configured user directory or group.", (Object)username);
                break;
            }
            case DIRECTORY_AND_GROUP: {
                userAllowedToLogin = UserLookupService.isUserInAllowedGroup(hostApp, allowingLoginGroups, disallowingLoginGroups, username, this.kerbConfManager.getBasicAuthPermissionGroup()) && UserLookupService.isUserInAllowedDirectory(dirsAllowing, username, userFound);
                log.debug("User {} allowed exception to blocked Basic Auth login login since they are in the configured user directory and group.", (Object)username);
            }
        }
        return userAllowedToLogin;
    }

    private boolean isUserAllowedToLoginWithKerberos(java.util.List<Directory> dirsAllowing, HostApp hostApp, Set<String> allowingLoginGroups, Set<String> disallowingLoginGroups, String username, UsernameSearchResult userFound) {
        boolean userAllowedToLogin = false;
        switch (this.kerbConfManager.getKerberosUserPermissionSome()) {
            case DIRECTORY: {
                userAllowedToLogin = UserLookupService.isUserInAllowedDirectory(dirsAllowing, username, userFound);
                log.debug("User {} allowed exception to blocked Kerberos login since they are in the configured user directory.", (Object)username);
                break;
            }
            case GROUP: {
                userAllowedToLogin = UserLookupService.isUserInAllowedGroup(hostApp, allowingLoginGroups, disallowingLoginGroups, username, this.kerbConfManager.getKerberosUserPermissionGroup());
                log.debug("User {} allowed exception to blocked Kerberos login since they are in the configured user group.", (Object)username);
                break;
            }
            case DIRECTORY_OR_GROUP: {
                userAllowedToLogin = UserLookupService.isUserInAllowedGroup(hostApp, allowingLoginGroups, disallowingLoginGroups, username, this.kerbConfManager.getKerberosUserPermissionGroup()) || UserLookupService.isUserInAllowedDirectory(dirsAllowing, username, userFound);
                log.debug("User {} allowed exception to blocked Kerberos login since they are in the configured user directory or group.", (Object)username);
                break;
            }
            case DIRECTORY_AND_GROUP: {
                userAllowedToLogin = UserLookupService.isUserInAllowedGroup(hostApp, allowingLoginGroups, disallowingLoginGroups, username, this.kerbConfManager.getKerberosUserPermissionGroup()) && UserLookupService.isUserInAllowedDirectory(dirsAllowing, username, userFound);
                log.debug("User {} allowed exception to blocked Kerberos login since they are in the configured user directory and group.", (Object)username);
            }
        }
        return userAllowedToLogin;
    }

    private static boolean isUserInAllowedGroup(HostApp hostApp, Set<String> dirsAllowing, Set<String> dirsDissallowing, String username, KerbConfManager.UserPermissionGroupType userPermissionGroupType) {
        boolean userShouldBeInGroup;
        boolean bl = userShouldBeInGroup = userPermissionGroupType == KerbConfManager.UserPermissionGroupType.ENABLE_USERS_IN_GROUP;
        if (userShouldBeInGroup) {
            for (String group : dirsAllowing) {
                if (!hostApp.isUserInGroup(username, group)) continue;
                log.debug("User {} allowed exception to blocked Kerberos since they are member of the configured group {}", (Object)username, (Object)group);
                return true;
            }
            return false;
        }
        for (String group : dirsDissallowing) {
            if (!hostApp.isUserInGroup(username, group)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUserInAllowedDirectory(java.util.List<Directory> dirsAllowing, String username, UsernameSearchResult userFound) {
        Directory usernameDirectory = userFound.getDirectory();
        for (Directory dir : dirsAllowing) {
            if (!dir.getId().equals(usernameDirectory.getId())) continue;
            log.debug("[ALLOW DIR] User {} allowed exception to blocked Kerberos login since they are in the configured user directory {}({})", new Object[]{username, dir.getName(), dir.getId()});
            return true;
        }
        return false;
    }

    @Override
    public JSONObject asJson() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        java.util.List directories = List.ofAll(this.getActiveUserDirectories()).map(directory -> {
            JSONObject directoryJson = new JSONObject();
            directoryJson.put("isActive", directory.isActive());
            directoryJson.put("isEmpty", directory.isEmpty());
            directoryJson.put("name", (Object)directory.getName());
            directoryJson.put("attributes", (Object)new JSONObject(directory.getAttributes()));
            directoryJson.put("directoryType", (Object)directory.getType().name());
            directoryJson.put("description", (Object)directory.getDescription());
            directoryJson.put("encryptionType", (Object)directory.getEncryptionType());
            directoryJson.put("id", (Object)directory.getId());
            directoryJson.put("updatedDate", (Object)dateFormat.format(directory.getUpdatedDate().getTime()));
            directoryJson.put("createdDate", (Object)dateFormat.format(directory.getCreatedDate().getTime()));
            directoryJson.put("isAlwaysSyncGroups", this.hostApp.isAlwaysSyncGroups((Directory)directory));
            directoryJson.put("isSyncGroupsOnFirstCreated", this.hostApp.isSyncGroupsOnFirstCreated((Directory)directory));
            return directoryJson;
        }).toJavaList();
        JSONObject json = new JSONObject();
        json.put("directories", (Collection)directories);
        String databaseUrl = this.hostApp.getDatabaseUrl();
        if (databaseUrl != null) {
            json.put("databaseUrl", (Object)databaseUrl);
        }
        return json;
    }
}

