/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.crowdserver;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.entity.ErrorEntity;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.Sets;
import com.kantegasso.jetty.JettyServletHandler;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Callback;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.azure.AzureAdConnectorType;
import org.kantega.atlaskerb.connector.azure.AzureConnectorPropUtil;
import org.kantega.atlaskerb.connector.crowdserver.CrowdResponseDocumentHandler;
import org.kantega.atlaskerb.connector.crowdserver.DefaultCrowdResponseDocumentHandler;
import org.kantega.atlaskerb.connector.crowdserver.FilterUtils;
import org.kantega.atlaskerb.connector.crowdserver.SyncState;
import org.kantega.atlaskerb.connector.crowdserver.SyncStateRegistry;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserCollection;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.userlookup.UserLookupTransform;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdApiHandler
extends JettyServletHandler {
    private static final String CROWD_VERSION_PLUGIN_INFO_KEY = "crowd-version";
    private final ConnectorConfManager connectorConfManager;
    private final HostApp hostApp;
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginAccessor pluginAccessor;
    private static final Logger log = LoggerFactory.getLogger(CrowdApiHandler.class);
    private final CrowdDirectoryFinder crowdDirectoryFinder;
    private final SyncStateRegistry syncStateRegistry;
    private AzureConnectorPropUtil azureConnectorPropUtil;

    public CrowdApiHandler(ConnectorConfManager connectorConfManager, HostApp hostApp, PluginLicenseManager pluginLicenseManager, PluginAccessor pluginAccessor) {
        this.connectorConfManager = connectorConfManager;
        this.hostApp = hostApp;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginAccessor = pluginAccessor;
        this.crowdDirectoryFinder = new CrowdDirectoryFinder(hostApp);
        this.syncStateRegistry = new SyncStateRegistry(hostApp);
    }

    public void setAzureConnectorPropUtil(AzureConnectorPropUtil azureConnectorPropUtil) {
        this.azureConnectorPropUtil = azureConnectorPropUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleKsso(String s, Request request, HttpServletRequestFacade req, HttpServletResponseFacade resp, Callback callback) throws IOException {
        long start = System.nanoTime();
        try {
            List<String> activeConnectors = this.connectorConfManager.getDirectories().stream().map(conn -> conn.getId()).collect(Collectors.toList());
            this.syncStateRegistry.pruneStates(activeConnectors);
            this.handleRequest(req, resp, callback);
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                String entityType = req.getParameter("entity-type");
                log.debug("Request for '{}' with entity-type={} processed in {} ms", new Object[]{req.getRequestURI(), entityType, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            String entityType = req.getParameter("entity-type");
            log.debug("Request for '{}' with entity-type={} processed in {} ms", new Object[]{req.getRequestURI(), entityType, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        }
    }

    protected void handleRequest(HttpServletRequestFacade req, HttpServletResponseFacade resp, Callback callback) throws IOException {
        String crowdVersion = this.fetchBundledCrowdVersion();
        log.debug("handleRequest '{}' with parameters: {} ", (Object)req.getRequestURI(), (Object)req.getParameterMap());
        resp.setHeader("X-Embedded-Crowd-Version", String.format("Crowd/%s)", crowdVersion));
        UsernamePassword usernamePassword = this.parseUsernamePassword(req.getHeader("Authorization"));
        if (req.getRequestURI().endsWith("/authentication")) {
            resp.setStatus(400);
            String username = req.getParameter("username");
            if (usernamePassword == null) {
                callback.failed((Throwable)new RuntimeException("User not found"));
                this.sendUserNotFound(resp, username);
                return;
            }
            String id = usernamePassword.getUsername();
            Directory directory = this.connectorConfManager.getDirectory(id);
            try {
                com.atlassian.crowd.embedded.api.Directory cd = this.crowdDirectoryFinder.findDirectory(directory.getId());
                DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
                if (StringUtils.isNotBlank((CharSequence)username)) {
                    directoryManager.findUserByName(cd.getId().longValue(), username);
                    this.sendIncorrectPassword(resp);
                    callback.failed((Throwable)new RuntimeException("Incorrect password"));
                }
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                callback.failed(e);
                log.warn("Could not verify user password in synchronized cloud directory");
            }
            catch (UserNotFoundException e) {
                this.sendUserNotFound(resp, username);
                callback.failed((Throwable)e);
            }
            return;
        }
        if (!this.isLicenseValid(resp)) {
            callback.failed((Throwable)new RuntimeException("Invalid license"));
            return;
        }
        if (usernamePassword == null) {
            this.unauthorized(resp);
            callback.failed((Throwable)new RuntimeException("Unauthorized"));
            return;
        }
        String connectorId = usernamePassword.getUsername();
        String password = usernamePassword.getPassword();
        Directory directory = this.connectorConfManager.getDirectory(connectorId);
        if (directory == null) {
            this.unauthorized(resp);
            callback.failed((Throwable)new RuntimeException("Unauthorized, no valid directory"));
            log.warn("No connector directory with id '{}'", (Object)connectorId);
            return;
        }
        String remoteAddress = req.getRemoteAddr();
        if (!directory.getRemoteAddresses().contains(remoteAddress)) {
            resp.setStatus(403);
            String msg = String.format("Client with address '%s' is forbidden to make requests to the connector '%s'", remoteAddress, directory.getId());
            resp.getWriter().write(msg);
            callback.failed((Throwable)new RuntimeException("Unauthorized, IP address not allowed"));
            log.warn(msg);
            return;
        }
        String decryptedPassword = this.hostApp.optionallyDecryptLdapPassword(password);
        if (password == null || !decryptedPassword.equals(directory.getPassword())) {
            log.warn("Connector request with invalid password. Check that Crowd directory configuration matches Connector.");
            this.unauthorized(resp);
            callback.failed((Throwable)new RuntimeException("Unauthorized, no valid directory password"));
            return;
        }
        try {
            ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(directory.getKind());
            com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(connectorId);
            long correlationId = this.syncStateRegistry.getCorrelationId(crowdDirectory);
            log.debug("handleRequest() connectorId: {} correlationId: {}", (Object)connectorId, (Object)correlationId);
            if (connectorType instanceof AzureAdConnectorType) {
                ((AzureAdConnectorType)connectorType).setAzureConnectorPropUtil(this.azureConnectorPropUtil);
            }
            ConnectorAPI api = connectorType.getConnectorApi(directory);
            DefaultCrowdResponseDocumentHandler responseDocumentHandler = this.startDocument(resp);
            this.handleApiCall(req, resp, directory, responseDocumentHandler, api);
            responseDocumentHandler.endDocument();
            callback.succeeded();
        }
        catch (Exception e) {
            log.error("Exception occurred handling API call " + req.getMethod() + " " + req.getRequestURI() + " for connector '" + directory.getDisplayName() + "'", (Throwable)e);
            callback.failed((Throwable)e);
            resp.setStatus(500);
        }
    }

    private String fetchBundledCrowdVersion() {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> this.pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey())).mapTry(Plugin::getPluginInformation).toOption().flatMap(io.vavr.control.Option::of).map(pluginInformation -> (String)pluginInformation.getParameters().get(CROWD_VERSION_PLUGIN_INFO_KEY)).filter(StringUtils::isNotBlank).map(Version::of).map(Version::stringValue).getOrElse((Object)"3.0.0");
    }

    private DefaultCrowdResponseDocumentHandler startDocument(HttpServletResponseFacade resp) {
        return DefaultCrowdResponseDocumentHandler.startDocument(resp);
    }

    private void sendIncorrectPassword(HttpServletResponseFacade resp) {
        DefaultCrowdResponseDocumentHandler handler = this.startDocument(resp);
        handler.outputError("Failed to authenticate principal, password was invalid", "INVALID_USER_AUTHENTICATION");
        handler.endDocument();
    }

    private void sendUserNotFound(HttpServletResponseFacade resp, String username) {
        DefaultCrowdResponseDocumentHandler handler = this.startDocument(resp);
        handler.outputError("User &lt;" + username + "&gt; does not exist", "USER_NOT_FOUND");
        handler.endDocument();
    }

    private boolean isLicenseValid(HttpServletResponseFacade resp) throws IOException {
        Option license = this.pluginLicenseManager.getLicense();
        if (!license.isDefined()) {
            resp.setStatus(500);
            String msg = "License error: Kantega SSO does not have a license.";
            resp.getWriter().print(msg);
            log.warn(msg);
            return false;
        }
        if (!((PluginLicense)license.get()).isValid()) {
            resp.setStatus(500);
            String msg = "License error: App license for Kantega SSO is not valid. Consult UPM for details.";
            resp.getWriter().print(msg);
            log.warn(msg);
            return false;
        }
        return true;
    }

    private void handleApiCall(HttpServletRequestFacade req, HttpServletResponseFacade resp, Directory directory, CrowdResponseDocumentHandler responseHandler, ConnectorAPI connectorAPI) throws InterruptedException, DirectoryNotFoundException, OperationFailedException {
        if ("user".equals(req.getParameter("entity-type"))) {
            this.handleUsersRequest(directory, responseHandler, connectorAPI, CrowdApiHandler.getMaxResults(req));
        } else if ("group".equals(req.getParameter("entity-type"))) {
            this.handleGroupsRequest(directory, responseHandler);
        } else if (req.getRequestURI().endsWith("/1/group")) {
            this.handleSingleGroupRequest(req, resp, directory, responseHandler);
        } else if (req.getRequestURI().endsWith("/1/user")) {
            this.handleSingleUserRequest(req, resp, directory, responseHandler);
        } else if (req.getRequestURI().endsWith("/membership")) {
            this.handleMembershipsRequest(directory, responseHandler);
        } else {
            resp.setStatus(400);
        }
    }

    private static int getMaxResults(HttpServletRequestFacade req) {
        int maxResults = -1;
        try {
            maxResults = Integer.parseInt(req.getParameter("max-results"));
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing max-results from connector sync call: {}", (Object)e.getMessage());
        }
        return maxResults;
    }

    private void handleMembershipsRequest(Directory directory, CrowdResponseDocumentHandler handler) {
        handler.startMemberships();
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            SyncState syncState = this.syncStateRegistry.getSyncState(directory);
            syncState.getMemberships().forEach(handler::outputMembership);
        }
        handler.endMemberships();
    }

    private void handleSingleUserRequest(HttpServletRequestFacade req, HttpServletResponseFacade resp, Directory directory, CrowdResponseDocumentHandler responseHandler) throws DirectoryNotFoundException, OperationFailedException {
        if ("GET".equals(req.getMethod())) {
            String username = req.getParameter("username");
            com.atlassian.crowd.embedded.api.Directory cd = this.crowdDirectoryFinder.findDirectory(directory.getId());
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            try {
                User crowdUser = directoryManager.findUserByName(cd.getId().longValue(), username);
                UserItem user = UserItem.cloneFromCrowdUser(crowdUser);
                responseHandler.outputUser(user);
            }
            catch (UserNotFoundException e) {
                resp.setStatus(404);
                responseHandler.outputError(username + " does not exist", ErrorEntity.ErrorReason.USER_NOT_FOUND.name());
            }
        }
    }

    private void handleSingleGroupRequest(HttpServletRequestFacade req, HttpServletResponseFacade resp, Directory directory, CrowdResponseDocumentHandler handler) {
        if ("GET".equals(req.getMethod())) {
            String groupName = req.getParameter("groupname");
            InternalDirectoryGroup group = null;
            if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
                try {
                    com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(directory.getId());
                    group = this.findGroupByName(groupName, crowdDirectory).orElse(null);
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    throw new RuntimeException("Failed to retrieve '" + groupName + "'", e);
                }
            }
            if (group != null && !group.isLocal()) {
                GroupItem gi = new GroupItem();
                gi.setName(groupName);
                gi.setActive(group.isActive());
                gi.setDescription(group.getDescription());
                handler.outputGroup(gi);
            } else {
                resp.setStatus(404);
                handler.outputError("Group not found: " + groupName, ErrorEntity.ErrorReason.GROUP_NOT_FOUND.name());
            }
        }
    }

    private Optional<InternalDirectoryGroup> findGroupByName(String groupName, com.atlassian.crowd.embedded.api.Directory directory) throws DirectoryNotFoundException, OperationFailedException {
        DirectoryManager dm = this.hostApp.getDirectoryManager();
        EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)new TermRestriction(GroupTermKeys.NAME, MatchMode.EXACTLY_MATCHES, (Object)groupName)).returningAtMost(1);
        List results = dm.searchGroups(directory.getId().longValue(), groupQuery);
        return results.isEmpty() ? Optional.empty() : Optional.of((InternalDirectoryGroup)results.get(0));
    }

    private void handleGroupsRequest(Directory directory, CrowdResponseDocumentHandler handler) {
        handler.startGroups();
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            SyncState syncState = this.syncStateRegistry.getSyncState(directory);
            syncState.getGroups().forEach(handler::outputGroup);
        }
        handler.endGroups();
    }

    private void handleUsersRequest(Directory directory, CrowdResponseDocumentHandler handler, ConnectorAPI api, int maxResults) throws InterruptedException {
        if (this.returnCachedUsersIfRequested(directory, handler, maxResults)) {
            return;
        }
        handler.startUsers();
        UserLookupTransform usernameTransformation = directory.getUsernameTransformation();
        List<Pair<String, String>> userTransformationRegexes = directory.getUserTransformationRegexes();
        UserTypeSelectionFilter userTypeSelectionFilter = directory.getUserTypeSelectionFilter();
        log.debug("Starting user fetch from API: {}, selectionMode: {}, transformation: {}, userTransformationRegexes {}", new Object[]{api.getClass().getName(), userTypeSelectionFilter.getMode(), usernameTransformation, userTransformationRegexes});
        HashMap usersOfType = new HashMap();
        HashSet usernameDuplicates = new HashSet();
        api.findAllUsers(userItem -> {
            if (FilterUtils.isUserTypeAccepted(userItem, userTypeSelectionFilter)) {
                String username = userItem.getName();
                if (usersOfType.containsKey(username)) {
                    usernameDuplicates.add(username);
                    UserItem previousUser = (UserItem)usersOfType.get(username);
                    String usernamePreviousUser = previousUser.getFallbackName();
                    previousUser.setName(usernamePreviousUser);
                    usersOfType.remove(username);
                    UserItem formattedPreviousUser = this.transformUser(previousUser, usernameTransformation, userTransformationRegexes);
                    usersOfType.put(usernamePreviousUser, formattedPreviousUser);
                    username = userItem.getFallbackName();
                    userItem.setName(username);
                } else if (usernameDuplicates.contains(username)) {
                    username = userItem.getFallbackName();
                    userItem.setName(username);
                }
                UserItem formattedUser = this.transformUser(userItem, usernameTransformation, userTransformationRegexes);
                usersOfType.put(username, formattedUser);
            }
            handler.keepalive();
        });
        GroupFilter groupFilter = directory.getGroupFilter();
        UserMembershipFilter userMembershipFilter = directory.getUserMembershipFilter();
        HashSet<GroupItem> groups = new HashSet<GroupItem>();
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            log.debug("Starting group fetch from API: {}", (Object)api.getClass().getName());
            api.findAllGroups(groupItem -> {
                if (FilterUtils.isMembershipRetrievalRequired(groupItem, groupFilter, userMembershipFilter)) {
                    groups.add(groupItem);
                }
                handler.keepalive();
            });
        }
        HashSet memberships = Sets.newHashSetWithExpectedSize((int)groups.size());
        com.atlassian.crowd.embedded.api.Directory crowdDirectory = this.crowdDirectoryFinder.findDirectory(directory.getId());
        boolean useNestedGroups = StringUtils.equals((CharSequence)"true", (CharSequence)((CharSequence)crowdDirectory.getAttributes().get("useNestedGroups")));
        if (directory.getObjectTypeFilter() == ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS) {
            log.debug("Starting membership fetch from API: {}. useNestedGroups: {}", (Object)api.getClass().getName(), (Object)useNestedGroups);
            api.findAllMemberships(new HashSet<UserItem>(usersOfType.values()), groups, membershipItem -> {
                memberships.add(this.transformMembershipItem(membershipItem, usernameTransformation, userTransformationRegexes));
                handler.keepalive();
            }, useNestedGroups);
        }
        Set<GroupItem> filteredGroups = FilterUtils.filterGroupsByGroup(groups, groupFilter);
        Tuple2<Set<UserItem>, Set<MembershipItem>> filteredUsers = FilterUtils.filterUsersByMemberships(new HashSet<UserItem>(usersOfType.values()), memberships, groupFilter, userMembershipFilter);
        handler.keepalive();
        this.syncStateRegistry.createSyncState(directory, (Set)filteredUsers._1, filteredGroups, (Set)filteredUsers._2);
        ((Set)filteredUsers._1).forEach(handler::outputUser);
        handler.endUsers();
    }

    private boolean returnCachedUsersIfRequested(Directory directory, CrowdResponseDocumentHandler handler, int maxResults) {
        if (maxResults > 0 && this.syncStateRegistry.peekSyncState(directory).isPresent()) {
            handler.startUsers();
            this.syncStateRegistry.getSyncState(directory).getUsers().stream().limit(maxResults).forEach(handler::outputUser);
            handler.endUsers();
            log.debug("Returning {} cached users for directory {}", (Object)maxResults, (Object)directory.getId());
            return true;
        }
        if (maxResults > 0) {
            log.debug("Cache for {} users was requested. No cached users found for directory {}", (Object)maxResults, (Object)directory.getId());
        }
        return false;
    }

    private String transformUsername(String username, UserLookupTransform userLookupTransform, List<Pair<String, String>> userTransformationRegexes) {
        if (UserLookupTransform.NAME_PART == userLookupTransform) {
            return StringUtils.substringBefore((String)username, (String)"@");
        }
        if (UserLookupTransform.REGEX == userLookupTransform) {
            return UserMappingUtils.transformUsername(username, userTransformationRegexes).orElse(username);
        }
        return username;
    }

    private UserItem transformUser(UserItem user, UserLookupTransform userLookupTransform, List<Pair<String, String>> userTransformationRegexes) {
        UserItem out = UserItem.clone(user);
        out.setName(this.transformUsername(user.getName(), userLookupTransform, userTransformationRegexes));
        return out;
    }

    private MembershipItem transformMembershipItem(MembershipItem membershipItem, UserLookupTransform usernameTransformation, List<Pair<String, String>> userTransformationRegexes) {
        if (usernameTransformation == UserLookupTransform.NONE) {
            return membershipItem;
        }
        List<UserMember> userMembers = membershipItem.getUserCollection().getUsers().stream().map(u -> new UserMember(this.transformUsername(u.getName(), usernameTransformation, userTransformationRegexes))).collect(Collectors.toList());
        return new MembershipItem(membershipItem.getName(), new UserCollection(userMembers));
    }

    private void unauthorized(HttpServletResponseFacade resp) {
        resp.addHeader("WWW-Authenticate", "Basic realm=\"Kantega SSO Connector API\"");
        resp.setStatus(401);
    }

    private UsernamePassword parseUsernamePassword(String authorization) {
        return (UsernamePassword)io.vavr.control.Option.of((Object)authorization).filter(auth -> auth.startsWith("Basic ")).map(auth -> auth.substring("Basic ".length())).map(Base64::decodeBase64).map(String::new).map(up -> up.split(":")).filter(up -> ((String[])up).length == 2).map(up -> new UsernamePassword(up[0], up[1])).getOrNull();
    }

    private static class UsernamePassword {
        final String username;
        final String password;

        public UsernamePassword(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

