/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;

public class ShowScimEventsAction
extends RequireAdminServlet {
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ShowScimEventsAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.scimConfManager = scimConfManager;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String tenantId = this.getId(req);
        ScimDirectory directory = (ScimDirectory)this.scimConfManager.getScimDirectory(tenantId).getOrElseThrow(() -> new RuntimeException("SCIM tenant not found: " + tenantId));
        Map<String, Object> model = this.newModel(req);
        this.renderPage(resp, model, directory);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String tenantId = this.getId(req);
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        if (req.getParameter("clear") != null) {
            this.scimConfManager.clearProvisioningEvents(tenantId);
        }
        resp.sendRedirect("events/" + tenantId);
    }

    private void renderPage(HttpServletResponseFacade res, Map<String, Object> model, ScimDirectory directory) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "provEvents");
        model.put("currentScimDirectory", directory);
        model.put("dateTool", new DateTool());
        model.put("events", this.scimConfManager.getProvisioningEvents(directory.getTenantId()).reverse());
        res.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/scim/scim-events.vm", model, (Writer)res.getWriter());
    }

    private String getId(HttpServletRequestFacade req) {
        String p = req.getPathInfo();
        return p.substring(p.lastIndexOf("/") + 1);
    }
}

