/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.logout;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.kantegasso.servlet.http.CookieFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.springframework.stereotype.Component;

@Component
public class SingleLogoutAppHelperFactory {
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final SingleLogoutAppHelper instance;
    private final ApplicationProperties applicationProperties;

    @Inject
    public SingleLogoutAppHelperFactory(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport XsrfTokenAccessor xsrfTokenAccessor, @ComponentImport XsrfTokenValidator xsrfTokenValidator) {
        this.applicationProperties = applicationProperties;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
        String dn = applicationProperties.getDisplayName().toLowerCase();
        if (dn.contains("jira")) {
            this.instance = new JiraLogoutHelper();
        } else if (dn.contains("confluence")) {
            this.instance = new ConfluenceLogoutHelper();
        } else if (dn.contains("bitbucket")) {
            this.instance = new BitbucketLogoutHelper();
        } else if (dn.contains("bamboo")) {
            this.instance = new BambooLogoutHelper();
        } else {
            throw new IllegalStateException("This plugin does not work on " + applicationProperties.getDisplayName());
        }
    }

    public SingleLogoutAppHelper getInstance() {
        return this.instance;
    }

    protected void removeCookie(HttpServletRequestFacade req, HttpServletResponseFacade res, String cookieName) {
        CookieFacade[] cookies = req.getCookiesKsso();
        if (cookies != null) {
            for (CookieFacade cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                CookieFacade delCookie = CookieSecurity.cookieWithDynamicSecurity(this.applicationProperties, cookieName, "");
                delCookie.setMaxAge(0);
                delCookie.setPath(req.getContextPath() + "/");
                res.addCookie((Cookie)delCookie);
                return;
            }
        }
    }

    class JiraLogoutHelper
    extends DefaultLogoutHelper {
        JiraLogoutHelper() {
            super(true);
        }

        @Override
        public boolean optionallyValidateXsrfToken(HttpServletRequestFacade req, HttpServletResponseFacade res) {
            if (StringUtils.isBlank((CharSequence)this.getCookieValue(req, "ksso.single.logout.jsm.url"))) {
                return SingleLogoutAppHelperFactory.this.xsrfTokenValidator.validateFormEncodedToken((HttpServletRequest)req);
            }
            return true;
        }

        @Override
        public String getDefaultLogoutReturnUrl(HttpServletRequestFacade req, HttpServletResponseFacade res, SingleLogoutAppHelper.Protocol protocol) {
            String jsmLogoutUrl = this.getCookieValue(req, "ksso.single.logout.jsm.url");
            SingleLogoutAppHelperFactory.this.removeCookie(req, res, "ksso.single.logout.jsm.url");
            if (jsmLogoutUrl != null) {
                String dest = StringUtils.substringBefore((String)jsmLogoutUrl, (String)"/user/login");
                return jsmLogoutUrl + String.format("?nokerberos&destination=%s&slo=finished&logout=true&noredirect", HttpUrlUtils.softUrlEncode((String)dest));
            }
            if (protocol == SingleLogoutAppHelper.Protocol.SAML) {
                Pair<String, String> token = this.getStoredXsrfToken(req, res, true).orElseThrow(() -> new RuntimeException("Couldn't get required stored XSRF token"));
                return String.format("/Logout!default.jspa?slo=finished&%s=%s", token.getKey(), HttpUrlUtils.softUrlEncode((String)((String)token.getValue())));
            }
            return "/login.jsp?noredirect";
        }
    }

    class ConfluenceLogoutHelper
    extends DefaultLogoutHelper {
        ConfluenceLogoutHelper() {
            super(false);
        }

        @Override
        public String getDefaultLogoutReturnUrl(HttpServletRequestFacade req, HttpServletResponseFacade res, SingleLogoutAppHelper.Protocol protocol) {
            return "/login.action?slo=finished&logout=true&noredirect";
        }
    }

    class BitbucketLogoutHelper
    extends DefaultLogoutHelper {
        BitbucketLogoutHelper() {
            super(false);
        }

        @Override
        public String getDefaultLogoutReturnUrl(HttpServletRequestFacade req, HttpServletResponseFacade res, SingleLogoutAppHelper.Protocol protocol) {
            return "/j_atl_security_logout?slo=finished&noredirect";
        }
    }

    class BambooLogoutHelper
    extends DefaultLogoutHelper {
        BambooLogoutHelper() {
            super(false);
        }

        @Override
        public String getDefaultLogoutReturnUrl(HttpServletRequestFacade req, HttpServletResponseFacade res, SingleLogoutAppHelper.Protocol protocol) {
            return "/start.action?slo=finished&noredirect";
        }
    }

    abstract class DefaultLogoutHelper
    implements SingleLogoutAppHelper {
        private final boolean useXsrf;

        DefaultLogoutHelper(boolean useXsrf) {
            this.useXsrf = useXsrf;
        }

        @Override
        public void dispatchToLogoutConfirmed(HttpServletRequestFacade req, HttpServletResponseFacade res, String idpId) throws IOException {
            res.sendRedirect(req.getContextPath() + this.getDefaultLogoutReturnUrl(req, res, SingleLogoutAppHelper.Protocol.SAML));
        }

        @Override
        public boolean optionallyValidateXsrfToken(HttpServletRequestFacade req, HttpServletResponseFacade res) {
            return true;
        }

        @Override
        public Optional<Pair<String, String>> getStoredXsrfToken(HttpServletRequestFacade req, HttpServletResponseFacade res, boolean create) {
            String param = SingleLogoutAppHelperFactory.this.xsrfTokenValidator.getXsrfParameterName();
            String value = SingleLogoutAppHelperFactory.this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)req, (HttpServletResponse)res, false);
            if (param == null || value == null) {
                return Optional.empty();
            }
            return Optional.of(Pair.of((Object)param, (Object)value));
        }

        @Override
        public void initiateLogout(HttpServletRequestFacade req, HttpServletResponseFacade res, String idpId) throws IOException {
            Object url = String.format("%s/plugins/servlet/no.kantega.saml/sp/%s/logout?action=init", req.getContextPath(), idpId);
            if (this.useXsrf) {
                Pair<String, String> xrf = this.getStoredXsrfToken(req, res, false).orElseThrow(() -> new RuntimeException("Could not find required XSRF token"));
                url = (String)url + String.format("&%s=%s", xrf.getKey(), HttpUrlUtils.urlEncode((String)((String)xrf.getValue())));
            }
            res.sendRedirect((String)url);
        }

        @Override
        public String getIdpSessionIdFromCookieAndSetInSession(HttpServletRequestFacade req, HttpServletResponseFacade res) {
            String idpConfigId = null;
            String cookieValue = this.getCookieValue(req, "ksso_idp_session_data");
            if (cookieValue != null) {
                String value = new String(Base64.getDecoder().decode(cookieValue.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                idpConfigId = StringUtils.substringBefore((String)value, (String)"#");
                String sessId = StringUtils.substringAfter((String)value, (String)"#");
                if (sessId.contains("#")) {
                    String thirdPart = StringUtils.substringAfter((String)sessId, (String)"#");
                    try {
                        SessionIdentificationHelper.fromJson(thirdPart);
                        req.getSession().setAttribute("ksso.saml.session.identification", (Object)thirdPart);
                    }
                    catch (Exception e) {
                        req.getSession(true).setAttribute("ksso.oidc.idtoken", (Object)thirdPart);
                    }
                    sessId = StringUtils.substringBefore((String)sessId, (String)"#");
                }
                req.getSession(true).setAttribute("ksso.idp.id.session.key", (Object)sessId);
            }
            return idpConfigId;
        }

        protected String getCookieValue(HttpServletRequestFacade req, String cookieName) {
            CookieFacade[] cookies = req.getCookiesKsso();
            if (cookies != null) {
                for (CookieFacade cookie : cookies) {
                    if (!cookie.getName().equals(cookieName)) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }

        @Override
        public abstract String getDefaultLogoutReturnUrl(HttpServletRequestFacade var1, HttpServletResponseFacade var2, SingleLogoutAppHelper.Protocol var3);
    }
}

