/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.util;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.DiscoverIdpHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SSOLoginHookContextProvider;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;
import org.kantega.atlaskerb.wrapper.model.webresource.UrlModeWrapper;
import org.kantega.atlaskerb.wrapper.webresource.WebResourceManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptInjector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final WebResourceManagerWrapper webResourceManager;
    private final IdpConfManager idpConfManager;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private String disableJsPath = null;
    private String disableCssPath = null;
    private String samlJsPath = null;
    private String runtime = null;
    private String contextPath = null;

    public ScriptInjector(WebResourceManagerWrapper webResourceManager, TemplateRenderer templateRenderer, KerbConfManager kerbConfManager, IdpConfManager idpConfManager, HostAppFactory hostAppFactory, RequireAdminServletDependencyBucket bucket) {
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = kerbConfManager;
        this.webResourceManager = webResourceManager;
        this.idpConfManager = idpConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.userLookupService = bucket.getUserLookupService();
    }

    public StringWriter prepareInjectScript(HttpServletRequestFacade req, HttpServletResponseFacade resp, boolean isTraditionalLoginDisabled, boolean enableFederatedSSO, boolean manualLogin, boolean shouldDisableRedirect, int samlRedirectDelay, String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts) throws IOException {
        StringWriter inject = new StringWriter();
        this.log.debug("Writing js and css enhancment. isTraditionalLoginDisabled: " + isTraditionalLoginDisabled + " enableFederatedSSO: " + enableFederatedSSO + " manualLogin: " + manualLogin + " samlRedirectDelay: " + samlRedirectDelay);
        if (this.hostApp.shouldUseLegacyLoginExperience()) {
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-legacy-login");
        } else {
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
        }
        if (isTraditionalLoginDisabled) {
            if (this.hostApp.shouldUseLegacyLoginExperience()) {
                this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-legacy-login");
                this.disableCssPath = this.appendResource(inject, this.disableCssPath, "href=\"(.*disable-legacy-login.*\\.css).*");
                this.disableJsPath = this.appendResource(inject, this.disableJsPath, "src=\"(.*disable-legacy-login.*\\.js).*");
            } else {
                this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-login");
            }
        }
        this.runtime = this.appendResource(inject, this.runtime, "src=\"(.*" + PluginKey.getPluginKeyBasepart() + ":runtime.*\\.js).*");
        if (this.hostApp.shouldIncludeContextPathInWebResource()) {
            this.contextPath = this.appendResource(inject, this.contextPath, "src=\"(.*com.atlassian.plugins.atlassian-plugins-webresource-plugin:context-path.*\\.js).*");
        }
        if (enableFederatedSSO) {
            String jsScriptFilePattern = this.hostApp.shouldUseLegacyLoginExperience() ? "src=\"(.*saml-legacy-login.*\\.js).*" : "src=\"(.*saml-login.*\\.js).*";
            this.samlJsPath = this.appendResource(inject, this.samlJsPath, jsScriptFilePattern);
            boolean isJsm = this.hostApp.isJsmLoginPage(req);
            DiscoverIdpHelper discoverIdpHelper = new DiscoverIdpHelper(this.hostApp, this.userLookupService, this.idpConfManager, isJsm);
            Map<String, Object> model = SSOLoginHookContextProvider.getContextMap(req, resp, this.kerbConfManager, this.idpConfManager, this.hostApp, this.userLookupService, discoverIdpHelper);
            model.put("shouldLoginManually", manualLogin);
            model.put("shouldDisableRedirect", shouldDisableRedirect);
            model.put("shouldUseLegacyLoginExperience", this.hostApp.shouldUseLegacyLoginExperience());
            model.put("useIdpPriority", this.idpConfManager.isUseIdpPriority());
            model.put("identityProviders", this.idpConfManager.getIdentityProvidersSortedByLoginDisplayPosition());
            model.put("customTextOnLoginPageWithHtml", this.kerbConfManager.getCustomTextBoxOnLoginPageContent());
            model.put("showCustomTextBoxOnLoginPage", this.kerbConfManager.isCustomTextBoxOnLoginPageEnabled());
            if (this.hostApp.isJsmLoginPage(req)) {
                model.put("isJsm", true);
                model.put("showInfoBoxOnJsmLogin", this.kerbConfManager.isShowInfoBoxOnJsmLogin());
                model.put("isTraditionalLoginJsmPrevented", this.kerbConfManager.isTraditionalLoginJsmPrevented());
                model.put("jsmCustomInfoBoxContentWithHtml", this.kerbConfManager.getJsmCustomInfoBoxContent());
                model.put("isAllTraditionalLoginPrevented", TraditionalLoginUtils.isTraditionalLoginPreventedForAllUsers(this.kerbConfManager, this.userLookupService));
            }
            if (StringUtils.isNotBlank((CharSequence)emailFromHeader) || StringUtils.isNotBlank((CharSequence)jsmSignupEmailUnblockedList)) {
                model.put("emailFromHeader", emailFromHeader);
                model.put("jsmSignupEmailUnblockedList", jsmSignupEmailUnblockedList);
                model.put("jsmUrlFormUrlparts", jsmUrlFormUrlparts);
                try {
                    this.templateRenderer.render("templates/atlaskerb/jsm-signup-email.vm", model, (Writer)inject);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.templateRenderer.render("templates/atlaskerb/login-page/saml-login-condition.vm", model, (Writer)inject);
        }
        return inject;
    }

    private String appendResource(StringWriter inject, String presetValue, String searchGroup) {
        String resources = this.webResourceManager.getRequiredResources(UrlModeWrapper.RELATIVE);
        String src = presetValue != null ? presetValue : ScriptInjector.interpretRegexAndReturnGroup(resources, searchGroup);
        if (src != null) {
            if (src.endsWith(".js")) {
                inject.append("<script src=\"").append(src).append("\"></script>");
            } else {
                inject.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(src).append("\">");
            }
        }
        return src;
    }

    private static String interpretRegexAndReturnGroup(String text, String regexPattern) {
        Matcher m = Pattern.compile(regexPattern).matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

