/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.wrapper.webresource.WebResourceManagerWrapper;

@UnrestrictedAccess
public class JiraMobileFilter
extends FilterFacade {
    private final boolean isJira;
    private final IdpConfManager idpConfManager;
    private final WebResourceManagerWrapper webResourceManager;
    private final TemplateRenderer templateRenderer;
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;

    @Inject
    public JiraMobileFilter(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport TemplateRenderer templateRenderer, WebResourceManagerWrapper webResourceManager, IdpConfManager idpConfManager, HostAppFactory hostAppFactory, KerbConfManager kerbConfManager) {
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.isJira = applicationProperties.getDisplayName().equalsIgnoreCase("jira");
        this.kerbConfManager = kerbConfManager;
    }

    public void doFilterKsso(final HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        if (!this.isJira) {
            chain.doFilterKsso(req, resp);
            return;
        }
        if (this.hostApp.shouldUseLegacyLoginExperience()) {
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-legacy-login");
        } else {
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
        }
        final boolean manualLogin = this.hostApp.shouldLoginManually(req, resp) && !this.idpConfManager.isAnyProviderForcingReLoginAfterLogout();
        chain.doFilterKsso(req, new HttpServletResponseFacade((HttpServletResponse)resp){

            public PrintWriter getWriter() throws IOException {
                return new InjectingPrintWriter(super.getWriter(), req.getContextPath(), manualLogin, JiraMobileFilter.this.idpConfManager.getRedirectProgressDelay());
            }
        });
    }

    public void destroy() {
    }

    private class InjectingPrintWriter
    extends PrintWriter {
        private final String contextPath;
        private final boolean manualLogin;
        private final int redirectDelay;

        public InjectingPrintWriter(PrintWriter writer, String contextPath, boolean manualLogin, int redirectDelay) {
            super(writer);
            this.contextPath = contextPath;
            this.manualLogin = manualLogin;
            this.redirectDelay = redirectDelay;
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            StringWriter writer = new StringWriter();
            if (JiraMobileFilter.this.hostApp.shouldUseLegacyLoginExperience()) {
                this.appendScript(writer, PluginKey.getPluginKeyBasepart() + ":entrypoint-saml-legacy-login/saml-legacy-login.js");
            } else {
                this.appendScript(writer, PluginKey.getPluginKeyBasepart() + ":entrypoint-saml-login/saml-login.js");
            }
            try {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("shouldUseLegacyLoginExperience", JiraMobileFilter.this.hostApp.shouldUseLegacyLoginExperience());
                model.put("shouldLoginManually", this.manualLogin);
                model.put("redirectProgressDelay", this.redirectDelay + "s");
                model.put("useIdpPriority", JiraMobileFilter.this.idpConfManager.isUseIdpPriority());
                JiraMobileFilter.this.templateRenderer.render("templates/atlaskerb/login-page/saml-login-condition.vm", model, (Writer)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String out = csq.toString();
            return super.append(out.replace("</body>", writer + "</body>"));
        }

        private void appendScript(StringWriter inject, String file) {
            String src = this.contextPath + "/download/resources/" + file;
            inject.append("<script src=\"").append(src).append("\"></script>");
        }
    }
}

