/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.kantegasso.servlet.http.HttpServletRequestFacade;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.DiscoverIdpHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.atlaskerb.utils.CookieUtil;

public class RedirectUtils {
    public static Map<String, String> getIdpIdHostedDomainMap(IdpConfManager idpConfigManager) {
        HashMap<String, String> idpIdHostedDomainMap = new HashMap<String, String>();
        for (IdpConfiguration idp : idpConfigManager.getIdentityProviders()) {
            if (idp.getRedirectProperties().getRedirectPolicy().equals((Object)IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN) && !idp.getKnownDomains().isEmpty()) {
                idpIdHostedDomainMap.put(idp.getId(), idp.getKnownDomains().stream().findFirst().orElse(""));
                continue;
            }
            idpIdHostedDomainMap.put(idp.getId(), "");
        }
        return idpIdHostedDomainMap;
    }

    public static Map<String, String> getLoginHintMapForIdentityProviders(IdpConfManager idpConfigManager) {
        HashMap<String, String> loginHintMap = new HashMap<String, String>();
        for (IdpConfiguration idp : idpConfigManager.getIdentityProviders()) {
            if (idp.getRedirectProperties().isSendLoginHint()) {
                loginHintMap.put(idp.getId(), "true");
                continue;
            }
            loginHintMap.put(idp.getId(), "false");
        }
        return loginHintMap;
    }

    public static boolean hasPreviouslyKnownLogin(HttpServletRequestFacade req, IdpConfManager idpConfigManager, DiscoverIdpHelper discoverIdpHelper) {
        return (Boolean)CookieUtil.getPreviouslyKnownLoginId(req).map(idpConfigManager::getEnabledIdentityProviderById).filter(Objects::nonNull).filter(idpConfiguration -> discoverIdpHelper.getRedirectProperties((IdpConfiguration)idpConfiguration).isKnownAutoRedirect()).filter(idp -> discoverIdpHelper.getRedirectPolicy((IdpConfiguration)idp) != IdpConfiguration.RedirectPolicy.NONE).map(_idp -> true).getOrElse((Object)false);
    }

    public static Map<String, String> getPreviousIdentityProvider(HttpServletRequestFacade req, IdpConfManager idpConfigManager, DiscoverIdpHelper discoverIdpHelper, KerbConfManager kerbConfManager) {
        String loginId = (String)CookieUtil.getPreviouslyKnownLoginId(req).getOrElse((Object)"");
        if (StringUtils.isBlank((CharSequence)loginId)) {
            return new HashMap<String, String>();
        }
        return RedirectUtils.createProviderMap(idpConfigManager.getEnabledIdentityProviderById(loginId), req, discoverIdpHelper, idpConfigManager, kerbConfManager);
    }

    public static Map<String, String> createProviderMap(IdpConfiguration idp, HttpServletRequestFacade req, DiscoverIdpHelper discoverIdpHelper, IdpConfManager idpConfigManager, KerbConfManager kerbConfManager) {
        RedirectProperties redirectProperties = discoverIdpHelper.getRedirectProperties(idp);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", idp.getId());
        map.put("name", idp.getName());
        map.put("useHostedDomain", Boolean.valueOf(idp.isHostedDomain()).toString());
        map.put("sendLoginHint", Boolean.valueOf(redirectProperties.isSendLoginHint()).toString());
        map.put("useIcon", Boolean.valueOf(idpConfigManager.isUseIcon()).toString());
        map.put("pluginAdminPath", "/plugins/servlet/" + PluginKey.getPluginKeyBasepart());
        map.put("kssoPluginKey", kerbConfManager.getLicenseManager().getPluginKey());
        map.put("loginUrl", idpConfigManager.getServiceProviderLoginUrl(req, idp.getId()));
        map.put("kind", idp.getKind().toString());
        if (!idp.getKnownDomains().isEmpty()) {
            map.put("hostedDomain", idp.getKnownDomains().stream().findFirst().orElse(""));
        }
        return map;
    }

    public static boolean shouldHideUsernameField(HttpServletRequestFacade req, DiscoverIdpHelper discoverIdpHelper, KerbConfManager kerbConfManager, IdpConfManager idpConfigManager) {
        List<IdpConfiguration> activeIdps = discoverIdpHelper.getVisibleProviders();
        for (IdpConfiguration idp : activeIdps) {
            IdpConfiguration.RedirectPolicy redirectPolicy = idp.getRedirectProperties().getRedirectPolicy();
            if (redirectPolicy != IdpConfiguration.RedirectPolicy.USER_DIRECTORY && redirectPolicy != IdpConfiguration.RedirectPolicy.USER_GROUP && redirectPolicy != IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN || RedirectUtils.hasPreviouslyKnownLogin(req, idpConfigManager, discoverIdpHelper)) continue;
            return false;
        }
        return kerbConfManager.shouldHideUsernameField();
    }

    public static Map<String, Object> getProviderMapForIdentityProviders(HttpServletRequestFacade request, DiscoverIdpHelper discoverIdpHelper, IdpConfManager idpConfigManager, KerbConfManager kerbConfManager) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoWithHtml", RedirectUtils.turnListOfIdpMapsIntoJson(RedirectUtils.getProviderMapForIdentityProviders(RedirectUtils.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.ALL, idpConfigManager, discoverIdpHelper), request, discoverIdpHelper, idpConfigManager, kerbConfManager)));
        map.put("manualWithHtml", RedirectUtils.turnListOfIdpMapsIntoJson(RedirectUtils.getProviderMapForIdentityProviders(RedirectUtils.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP), idpConfigManager, discoverIdpHelper), request, discoverIdpHelper, idpConfigManager, kerbConfManager)));
        map.put("visibleWithHtml", RedirectUtils.turnListOfIdpMapsIntoJson(RedirectUtils.getProviderMapForIdentityProviders(discoverIdpHelper.getVisibleProviders(), request, discoverIdpHelper, idpConfigManager, kerbConfManager)));
        if (RedirectUtils.hasPreviouslyKnownLogin(request, idpConfigManager, discoverIdpHelper)) {
            map.put("lastWithHtml", RedirectUtils.turnIdpMapIntoJson(RedirectUtils.getPreviousIdentityProvider(request, idpConfigManager, discoverIdpHelper, kerbConfManager)));
        }
        return map;
    }

    public static List<Map<String, String>> getProviderMapForIdentityProviders(List<IdpConfiguration> idpConfigurations, HttpServletRequestFacade req, DiscoverIdpHelper discoverIdpHelper, IdpConfManager idpConfigManager, KerbConfManager kerbConfManager) {
        return idpConfigurations.stream().map(idp -> RedirectUtils.createProviderMap(idp, req, discoverIdpHelper, idpConfigManager, kerbConfManager)).collect(Collectors.toList());
    }

    public static List<IdpConfiguration> getProvidersByRedirectPolicy(EnumSet<IdpConfiguration.RedirectPolicy> redirectPolicies, IdpConfManager idpConfigManager, DiscoverIdpHelper discoverIdpHelper) {
        return idpConfigManager.getSortedIdentityProviders().stream().filter(idp -> redirectPolicies.contains((Object)discoverIdpHelper.getRedirectProperties((IdpConfiguration)idp).getRedirectPolicy())).filter(IdpConfiguration::isEnabled).collect(Collectors.toList());
    }

    public static List<IdpConfiguration> getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy, IdpConfManager idpConfigManager, DiscoverIdpHelper discoverIdpHelper) {
        return RedirectUtils.getProvidersByRedirectPolicy(EnumSet.of(redirectPolicy), idpConfigManager, discoverIdpHelper);
    }

    public static boolean isAutomaticRedirectAllowed(int automaticRedirectLength, boolean shouldDisableRedirect, boolean isAuthenticated, boolean shouldLoginManually, boolean isAnyProviderForcingReLoginAfterLogout, boolean kssoAuthAnonymousBrowsingUser, boolean isIdpDisabledUserAgent) {
        return automaticRedirectLength > 0 && !shouldDisableRedirect && !isAuthenticated && (!shouldLoginManually || isAnyProviderForcingReLoginAfterLogout) && !kssoAuthAnonymousBrowsingUser && !isIdpDisabledUserAgent;
    }

    public static JSONObject turnIdpMapIntoJson(Map<String, String> idpMap) {
        return new JSONObject(idpMap);
    }

    public static List<JSONObject> turnListOfIdpMapsIntoJson(List<Map<String, String>> idpMaps) {
        return idpMaps.stream().map(JSONObject::new).collect(Collectors.toList());
    }
}

