/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.kantegasso.servlet.http.CookieFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.kantega.samllib.spi.ServiceProviderSpi;

public class CookieUtil {
    private static final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
    public static final String LAST_ACCOUNT_COOKIE = "idp_last_account";
    public static final String IDP_SESSION_DATA = "ksso_idp_session_data";

    public static String getCookieString(String cookieName, Object cookieValue, String discoverPath) {
        long maxAge = TimeUnit.DAYS.toMillis(365L);
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date expiresDate = new Date(System.currentTimeMillis() + maxAge);
        return cookieName + "=\"" + cookieValue.toString() + "\"; Version: 1; Comment=HttpOnly; Max-Age=" + maxAge + "; Expires=" + df.format(expiresDate) + "; Path=" + discoverPath + ";";
    }

    public static void setLastIdpAccountCookie(String idpId, HttpServletRequestFacade request, HttpServletResponseFacade response) {
        HttpSessionFacade session = request.getSessionKsso(true);
        String username = (String)session.getAttribute(USERNAME_ATTR);
        session.removeAttribute(USERNAME_ATTR);
        String cookieVal = username == null ? idpId : idpId + ":" + username;
        String discoverPath = request.getContextPath();
        response.addHeader("Set-Cookie", CookieUtil.getCookieString(LAST_ACCOUNT_COOKIE, cookieVal, discoverPath));
    }

    public static void setTraditionalLoginCookie(HttpServletRequestFacade req, HttpServletResponseFacade response) {
        response.addHeader("Set-Cookie", CookieUtil.getCookieString("hasUsedTraditionalLogin", true, "/"));
    }

    public static CookieFacade getCookie(HttpServletRequestFacade req, String cookieName) {
        try {
            return (CookieFacade)((Stream)Option.of((Object)req.getCookiesKsso()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> cookie.getName().equals(cookieName)).head();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static void removeCookie(HttpServletRequestFacade req, HttpServletResponseFacade response, String cookieName) {
        CookieFacade[] cookies = req.getCookiesKsso();
        if (cookies == null) {
            return;
        }
        for (CookieFacade cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            cookie.setMaxAge(0);
            response.addCookie((Cookie)cookie);
            return;
        }
    }

    public static Option<String> getPreviouslyKnownLoginUsername(HttpServletRequestFacade req) {
        return ((Stream)Option.of((Object)req.getCookiesKsso()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> LAST_ACCOUNT_COOKIE.equals(cookie.getName())).map(CookieFacade::getValue).map(value -> value.contains(":") ? value.substring(value.indexOf(":") + 1) : "").headOption();
    }

    public static Option<String> getPreviouslyKnownLoginId(HttpServletRequestFacade req) {
        return ((Stream)Option.of((Object)req.getCookiesKsso()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> LAST_ACCOUNT_COOKIE.equals(cookie.getName())).map(CookieFacade::getValue).map(value -> value.contains(":") ? value.substring(0, value.indexOf(":")) : value).headOption();
    }

    public static void keepUsernameInSession(HttpServletRequestFacade req, String username) {
        if (username != null) {
            req.getSessionKsso().setAttribute(USERNAME_ATTR, (Object)username);
        } else {
            req.getSessionKsso().removeAttribute(USERNAME_ATTR);
        }
    }
}

