/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.keytab;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.kantega.atlaskerb.kerberos.keytab.KeytabEntry;
import org.kantega.atlaskerb.kerberos.keytab.PrincipalName;

public class KeytabReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeytabEntry> read(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            List<KeytabEntry> list = this.parse(is);
            return list;
        }
    }

    public List<KeytabEntry> read(InputStream inputStream) throws IOException {
        return this.parse(inputStream);
    }

    private List<KeytabEntry> parse(InputStream is) throws IOException {
        int size;
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.toByteArray(is)));
        byte[] version = new byte[2];
        in.read(version, 0, version.length);
        while (in.available() > 0 && (size = in.readInt()) != 0) {
            if (size > 0) {
                byte[] record = new byte[size];
                in.read(record);
                entries.add(this.parseRecord(record));
                continue;
            }
            in.read(new byte[Math.abs(size)]);
        }
        return entries;
    }

    private KeytabEntry parseRecord(byte[] record) throws IOException {
        int newVersion;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(record));
        PrincipalName principalName = this.readPrincipalName(input);
        int timestamp = input.readInt();
        int keyVersion = input.readUnsignedByte();
        short encType = input.readShort();
        short keyLength = input.readShort();
        byte[] keyContents = new byte[keyLength];
        input.read(keyContents);
        if (input.available() >= 4 && (newVersion = input.readInt()) > 0) {
            keyVersion = newVersion;
        }
        return new KeytabEntry(principalName, timestamp, keyVersion, encType, keyContents);
    }

    private PrincipalName readPrincipalName(DataInputStream input) throws IOException {
        int numComponents = input.readShort();
        String realm = this.readData(input);
        ArrayList<String> components = new ArrayList<String>();
        for (int i = 0; i < numComponents; ++i) {
            components.add(this.readData(input));
        }
        int nameType = input.readInt();
        return new PrincipalName(realm, components, nameType);
    }

    private String readData(DataInputStream input) throws IOException {
        short size = input.readShort();
        byte[] bytes = new byte[size];
        input.read(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.copy(is, output);
        return output.toByteArray();
    }

    private long copy(InputStream is, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = is.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public void write(List<KeytabEntry> entries, OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bout);
        this.writeVersion(output);
        for (KeytabEntry entry : entries) {
            byte[] record = this.toBytes(entry);
            output.writeInt(record.length);
            output.write(record);
        }
        out.write(bout.toByteArray());
    }

    private byte[] toBytes(KeytabEntry entry) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bout);
        this.writePrincipalName(entry.getPrincipalName(), output);
        output.writeInt(entry.getTimestamp());
        output.write(entry.getKeyVersion() < 128 ? entry.getKeyVersion() : 0);
        output.writeShort(entry.getEncType());
        output.writeShort(entry.getKeyContents().length);
        output.write(entry.getKeyContents());
        if (entry.getKeyVersion() >= 128) {
            output.writeInt(entry.getKeyVersion());
        }
        return bout.toByteArray();
    }

    private void writePrincipalName(PrincipalName principalName, DataOutputStream output) throws IOException {
        output.writeShort(principalName.getComponents().size());
        this.writeData(principalName.getRealm(), output);
        for (String component : principalName.getComponents()) {
            this.writeData(component, output);
        }
        output.writeInt(principalName.getNameType());
    }

    private void writeData(String data, DataOutputStream output) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        output.writeShort(bytes.length);
        output.write(bytes);
    }

    private void writeVersion(DataOutputStream output) throws IOException {
        output.write(new byte[]{5, 2});
    }
}

