/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Function2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.setup.IdpActionResult;
import org.kantega.atlaskerb.identityproviders.setup.IdpActions;

public class SetupServlet
extends RequireAdminServlet {
    private final IdpActions idpActions;

    @Inject
    public SetupServlet(IdpActions idpActions, RequireAdminServletDependencyBucket requireAdminServletDependencyBucket) {
        super(requireAdminServletDependencyBucket);
        this.idpActions = idpActions;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        resp.setContentType("text/html");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.getTemplateRenderer().render("templates/setup/idp-setup-wizard.vm", this.newModel(req), (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        super.doPostKsso(request, response);
        JSONObject actionObject = (JSONObject)Try.of((CheckedFunction0 & Serializable)() -> new JSONObject(request.getParameter("data"))).getOrElse(JSONObject::new);
        API.Match.Case[] caseArray = new API.Match.Case[12];
        caseArray[0] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.GET_STATIC_DATA.name()), (Object)API.Function(this.idpActions::getStaticData));
        caseArray[1] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.OIDC_CREATE.name()), (Object)API.Function(this.idpActions::oidcCreate));
        caseArray[2] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.OIDC_SCOPES_SUPPORTED.name()), (Object)API.Function(this.idpActions::oidcScopesSupported));
        caseArray[3] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.SAML_CREATE.name()), (Object)API.Function(this.idpActions::samlCreate));
        caseArray[4] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.SAML_IMPORT_METADATA_FROM_PASTE.name()), (Object)API.Function(this.idpActions::samlImportMetadataFromPaste));
        caseArray[5] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.SAML_IMPORT_METADATA_FROM_URL.name()), (Object)API.Function(this.idpActions::samlImportMetadataFromUrl));
        caseArray[6] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.SAML_IMPORT_METADATA_FROM_SELF_SIGNED_URL.name()), (Object)API.Function(this.idpActions::samlImportMetadataFromSelfSignedUrl));
        caseArray[7] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.IDP_ID.name()), (Object)API.Function(this.idpActions::idpId));
        caseArray[8] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.STORE_DRAFT.name()), (Object)API.Function(this.idpActions::storeDraft));
        caseArray[9] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.LOAD_DRAFT.name()), (Object)API.Function(this.idpActions::loadDraft));
        caseArray[10] = API.Case((API.Match.Pattern0)API.$((Object)IdpActions.LegalActions.DELETE_DRAFT.name()), (Object)API.Function(this.idpActions::deleteDraft));
        caseArray[11] = API.Case((API.Match.Pattern0)API.$(), () -> API.Function(this.idpActions::_undefined));
        IdpActionResult actionResult = (IdpActionResult)((Function2)API.Match((Object)actionObject.getString("action")).of(caseArray)).apply((Object)request, (Object)actionObject);
        response.setStatus(actionResult.getHttpCode());
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getWriter().print(actionResult.toJsonObjectString());
        response.getWriter().flush();
    }

    @Override
    protected void serviceKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        String data = request.getParameter("data");
        if (data != null) {
            try {
                this.webSudoManager.willExecuteWebSudoRequest((HttpServletRequest)request);
            }
            catch (WebSudoSessionException wes) {
                IdpActionResult actionResult = new IdpActionResult(false, "WebSudo has timed out", (Map<String, ?>)HashMap.of((Object)"Error", (Object)"Websudo timed out"), 401);
                response.setStatus(401);
                response.setContentType("application/json");
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                response.getOutputStream().print(actionResult.toJsonObjectString());
                response.getOutputStream().flush();
                return;
            }
        }
        super.serviceKsso(request, response);
    }
}

