/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.enums.GroupComparisonType;
import org.kantega.atlaskerb.identityproviders.enums.GroupRuleEvalutationResult;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.saml.util.JitGroupRule;
import org.kantega.atlaskerb.security.XmlSecurity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SamlXmlParser {
    public static Element listOfTuplesToXml(Document document, String elementName, List<Pair<String, String>> tuples) {
        Element parentTupleElement = document.createElement(elementName);
        if (tuples != null) {
            for (int i = 0; i < tuples.size(); ++i) {
                Pair<String, String> tuple = tuples.get(i);
                Element tupleElement = document.createElement("tuple");
                tupleElement.setAttribute("key", Integer.toString(i));
                Element left = document.createElement("left");
                Element right = document.createElement("right");
                left.appendChild(document.createTextNode((String)tuple.getLeft()));
                right.appendChild(document.createTextNode((String)tuple.getRight()));
                tupleElement.appendChild(left);
                tupleElement.appendChild(right);
                parentTupleElement.appendChild(tupleElement);
            }
        }
        return parentTupleElement;
    }

    public static String getStringFromXMLTag(Element xmlElement, String tagname) {
        if (xmlElement == null) {
            return null;
        }
        Node childNode = xmlElement.getElementsByTagName(tagname).item(0);
        if (childNode == null || !childNode.hasChildNodes()) {
            return null;
        }
        return childNode.getTextContent();
    }

    public static List<Pair<String, String>> parseRegexTuples(NodeList tupleElements) {
        ArrayList<Pair<String, String>> regexTuples = new ArrayList<Pair<String, String>>();
        if (tupleElements != null) {
            for (int i = 0; i < tupleElements.getLength(); ++i) {
                Node item = tupleElements.item(i);
                if (item.getNodeType() != 1) continue;
                Element tupleElement = (Element)item;
                String left = SamlXmlParser.getStringFromXMLTag(tupleElement, "left");
                String right = SamlXmlParser.getStringFromXMLTag(tupleElement, "right");
                regexTuples.add((Pair<String, String>)Pair.of((Object)left, (Object)right));
            }
        }
        return regexTuples;
    }

    public static List<Pair<UsernameAttribute, String>> parseUsernameAttributePriority(NodeList elements) {
        ArrayList<Pair<UsernameAttribute, String>> tuples = new ArrayList<Pair<UsernameAttribute, String>>();
        if (elements != null) {
            for (int i = 0; i < elements.getLength(); ++i) {
                Node item = elements.item(i);
                if (item.getNodeType() != 1) continue;
                Element tupleElement = (Element)item;
                String left = SamlXmlParser.getStringFromXMLTag(tupleElement, "left");
                String right = SamlXmlParser.getStringFromXMLTag(tupleElement, "right");
                tuples.add((Pair<UsernameAttribute, String>)Pair.of((Object)((Object)UsernameAttribute.valueOf(left)), (Object)right));
            }
        }
        return tuples;
    }

    public static Map<String, ManagedGroup> parseGroups(NodeList elements) {
        TreeMap<String, ManagedGroup> groups = new TreeMap<String, ManagedGroup>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node item = elements.item(i);
            if (!(item instanceof Element)) continue;
            String name = ((Element)item).getAttribute("name");
            groups.put(name, new ManagedGroup(name));
        }
        return groups;
    }

    public static List<JitGroupRule> parseAdvancedGroupRules(NodeList elements) {
        ArrayList<JitGroupRule> advancedGroupRules = new ArrayList<JitGroupRule>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node item = elements.item(i);
            if (!(item instanceof Element)) continue;
            advancedGroupRules.add(SamlXmlParser.parseAdvancedGroupRule(item));
        }
        return advancedGroupRules;
    }

    private static JitGroupRule parseAdvancedGroupRule(Node item) {
        int id = Integer.parseInt(((Element)item).getAttribute("id"));
        JitGroupRule rule = new JitGroupRule(id);
        try {
            Set<String> groups = SamlXmlParser.getGroupNames(((Element)item).getElementsByTagName("group"));
            rule.setGroups(groups);
        }
        catch (Exception groups) {
            // empty catch block
        }
        try {
            int priority = Integer.parseInt(((Element)item).getAttribute("priority"));
            rule.setPriority(priority);
        }
        catch (Exception priority) {
            // empty catch block
        }
        try {
            boolean isEnabled = Boolean.parseBoolean(((Element)item).getAttribute("isEnabled"));
            rule.setEnabled(isEnabled);
        }
        catch (Exception isEnabled) {
            // empty catch block
        }
        try {
            GroupComparisonType comparisonType = GroupComparisonType.valueOf(((Element)item).getAttribute("comparisonType"));
            rule.setComparisonType(comparisonType);
        }
        catch (Exception comparisonType) {
            // empty catch block
        }
        try {
            GroupRuleEvalutationResult result = GroupRuleEvalutationResult.valueOf(((Element)item).getAttribute("result"));
            rule.setResult(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule;
    }

    private static Set<String> getGroupNames(NodeList elements) {
        HashSet<String> groupNames = new HashSet<String>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node item = elements.item(i);
            groupNames.add(((Element)item).getAttribute("name"));
        }
        return groupNames;
    }

    public static Document parseProviderDocument(File providerFile) {
        try {
            return XmlSecurity.secureDocumentBuilder().parse(providerFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static LinkedHashSet<String> parseSet(String attribute) {
        if (attribute == null) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (String g : attribute.split(",")) {
            if ((g = g.trim()).isEmpty()) continue;
            groups.add(g);
        }
        return groups;
    }

    public static Set<Long> parseLongSet(String attribute) {
        if (attribute == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Long> longs = new LinkedHashSet<Long>();
        for (String g : attribute.split(",")) {
            if ((g = g.trim()).isEmpty()) continue;
            longs.add(Long.parseLong(g));
        }
        return longs;
    }
}

