/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.jobs.JobManager;
import org.kantega.atlaskerb.jobs.UserCleanupJobRunner;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupRule;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="set-cleanup-rule")
@PublicApi
public class SetCleanupRule {
    private static final Logger log = LoggerFactory.getLogger(SetCleanupRule.class);
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final JobManager jobManager;
    private final JsonWrapper jsonWrapper;

    @Inject
    public SetCleanupRule(@ComponentImport UserManager userManager, KerbConfManager kerbConfManager, JobManager jobManager, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.kerbConfManager = kerbConfManager;
        this.jobManager = jobManager;
        this.jsonWrapper = jsonWrapper;
    }

    private void scheduleJob(String cron) {
        this.jobManager.destroyJobsWithRunnerKey(UserCleanupJobRunner.JOB_RUNNER_KEY);
        this.jobManager.scheduleUserCleanupJob(cron, UserCleanupJobRunner.JOB_RUNNER_KEY);
    }

    private void destroyJob() {
        this.jobManager.destroyJobsWithRunnerKey(UserCleanupJobRunner.JOB_RUNNER_KEY);
    }

    private Response run(UserProfile userProfile, UserManager userManager, CleanupRule cleanupRule) {
        if (cleanupRule != null) {
            boolean shouldScheduleJob;
            String json;
            cleanupRule.setChangedByUsername(userProfile.getUsername());
            CleanupMode cleanupMode = cleanupRule.getCleanupMode();
            try {
                json = this.jsonWrapper.objectWriter().writeValueAsString((Object)cleanupRule);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to map CleanupRule object to JSON", (Throwable)e);
                return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Failed to map CleanupRule object to JSON.");
            }
            if (json == null) {
                this.kerbConfManager.setCleanupRuleJSONString("", cleanupMode);
            } else {
                this.kerbConfManager.setCleanupRuleJSONString(json, cleanupMode);
            }
            String cronSchedule = cleanupRule.getCronAttributes() != null ? cleanupRule.getCronAttributes().getCronSpringSchedule() : null;
            boolean scheduleEnabled = cleanupRule.getCronAttributes() != null && cleanupRule.getCronAttributes().getScheduleEnabled();
            boolean bl = shouldScheduleJob = cronSchedule != null && cronSchedule.length() > 0 && scheduleEnabled;
            if (shouldScheduleJob) {
                this.scheduleJob(cronSchedule);
            } else {
                this.destroyJob();
            }
            return ResponseUtils.ok();
        }
        return ResponseUtils.errorWithMessageInJson(Response.Status.BAD_REQUEST, "Cleanup rule data missing in request");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@Context HttpServletRequest request, CleanupRule cleanupRule) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, cleanupRule)).onFailure(e -> log.error("Encountered an exception while attempting to set new cleanup rule. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

