/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class UserSyncServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;

    @Inject
    public UserSyncServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "userGroupSync");
        model.put("idp", configuration);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(configuration.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(configuration.getKind()));
        this.getTemplateRenderer().render("templates/saml/user-group-sync.vm", model, (Writer)resp.getWriter());
    }
}

