/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.internal.config;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/status")
public class ConfigStatus {
    private final UserManager userManager;
    private final KssoUpgradeManager kssoUpgradeManager;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final Logger log = LoggerFactory.getLogger(ConfigStatus.class);

    @Inject
    public ConfigStatus(UserManager userManager, KssoUpgradeManager kssoUpgradeManager, IdpConfManager idpConfManager, HostAppFactory hostAppFactory, KerbConfManager kerbConfManager) {
        this.userManager = userManager;
        this.kssoUpgradeManager = kssoUpgradeManager;
        this.idpConfManager = idpConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = kerbConfManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response fetchConfigStatus(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            boolean isSamlEnabled;
            JSONObject statusData = new JSONObject();
            statusData.put("isKssoConfigUpdateNeeded", this.kssoUpgradeManager.isKssoConfigUpgradeNeeded());
            statusData.put("hasUpgradeFailures", this.kssoUpgradeManager.hasUpgradeFailures());
            statusData.put("hasBadVersionUpgrade", this.kssoUpgradeManager.hasBadVersionUpgrade());
            statusData.put("isBreakingVersionDowngrade", this.kssoUpgradeManager.isBreakingVersionDowngrade());
            boolean bl = isSamlEnabled = this.idpConfManager.hasEnabledSamlProviders() && this.idpConfManager.isFederatedSsoEnabled();
            if (isSamlEnabled && this.idpConfManager.isWarnSamlKeyExpires()) {
                X509Certificate activeCert = this.idpConfManager.parseCert(this.idpConfManager.getSigningCert());
                boolean isValidCert = CertTool.isValidCertificate(activeCert, 0);
                boolean isExpiringSoon = CertTool.isExpiringSoon(activeCert);
                statusData.put("isSamlCertificateExpiring", isValidCert && isExpiringSoon);
                statusData.put("isSamlCertificateExpired", !isValidCert);
            }
            statusData.put("requestBaseUrl", (Object)HttpUrlUtils.extractRequestBaseUrl((HttpServletRequestFacade)HttpServletRequestFacade.of((HttpServletRequest)request)));
            statusData.put("pluginRootUri", (Object)this.kerbConfManager.getPluginRootUri());
            return Response.ok((Object)statusData.toString()).build();
        });
    }
}

