/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.postprocessing;

import io.vavr.control.Option;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;

public class SsoPostProcessingResult {
    private final FederatedIdentityResponseEvaluationResult evaluationResult;
    private final IdpConfiguration idpConfiguration;
    private final ExitCondition exitCondition;
    private final String message;
    private final AuthMethod authMethod;
    private final SsoJitSideEffect jitSideEffect;
    private final String targetUrl;

    SsoPostProcessingResult continueProcessing(SsoPostProcessingResult processingResult) {
        return processingResult;
    }

    public static Builder of(@NonNull FederatedIdentityResponseEvaluationResult evaluationResult, @NonNull IdpConfiguration idpConfiguration) {
        Builder builder = new Builder(evaluationResult, idpConfiguration);
        if (evaluationResult instanceof SAMLResponseEvaluationResult) {
            return builder.setAuthMethod(AuthMethod.SAML);
        }
        if (evaluationResult instanceof OidcResponseEvaluationResult) {
            return builder.setAuthMethod(AuthMethod.OIDC);
        }
        return builder;
    }

    public static Builder of(@NonNull SsoPostProcessingResult postProcessingResult) {
        return new Builder(postProcessingResult.getMessage(), postProcessingResult.getAuthMethod(), postProcessingResult.getExitCondition(), postProcessingResult.getEvaluationResult(), postProcessingResult.getIdpConfiguration(), postProcessingResult.getJitSideEffect(), postProcessingResult.getTargetUrl());
    }

    public SsoPostProcessingResult sideEffect(Consumer<SsoPostProcessingResult> consumer) {
        if (this.getExitCondition() == ExitCondition.CONTINUE_PROCESSING) {
            consumer.accept(this);
        }
        return this;
    }

    public SsoPostProcessingResult onLoginFailure(Consumer<SsoPostProcessingResult> consumer) {
        if (this.getExitCondition() == ExitCondition.LOGIN_FAILED) {
            consumer.accept(this);
        }
        return this;
    }

    public SsoPostProcessingResult onLoginSuccess(Consumer<SsoPostProcessingResult> consumer) {
        if (this.getExitCondition() == ExitCondition.SSO_LOGIN || this.getExitCondition() == ExitCondition.ANONYMOUS_BROWSING) {
            consumer.accept(this);
        }
        return this;
    }

    public SsoPostProcessingResult require(Predicate<SsoPostProcessingResult> predicate) {
        if (predicate.test(this)) {
            return this;
        }
        return SsoPostProcessingResult.of(this).setExitCondition(ExitCondition.LOGIN_FAILED).build();
    }

    public SsoPostProcessingResult then(Function<SsoPostProcessingResult, SsoPostProcessingResult> mapper) {
        if (this.getExitCondition() == ExitCondition.CONTINUE_PROCESSING) {
            return SsoPostProcessingResult.of(mapper.apply(this)).build();
        }
        return this;
    }

    private SsoPostProcessingResult(String message, AuthMethod authMethod, ExitCondition exitCondition, FederatedIdentityResponseEvaluationResult evaluationResult, IdpConfiguration idpConfiguration, SsoJitSideEffect jitSideEffects, String targetUrl) {
        this.message = message;
        this.authMethod = authMethod;
        this.exitCondition = exitCondition;
        this.evaluationResult = evaluationResult;
        this.idpConfiguration = idpConfiguration;
        this.jitSideEffect = jitSideEffects;
        this.targetUrl = targetUrl;
    }

    public FederatedIdentityResponseEvaluationResult getEvaluationResult() {
        return this.evaluationResult;
    }

    public IdpConfiguration getIdpConfiguration() {
        return this.idpConfiguration;
    }

    public Option<String> getMaybeUsername() {
        return Option.of((Object)this.evaluationResult).map(FederatedIdentityResponseEvaluationResult::getFoundUsername).flatMap(nullableUsername -> Option.of((Object)nullableUsername));
    }

    public Option<PrincipalEntry> getMaybePrincipalEntry() {
        return Option.of((Object)this.evaluationResult).flatMap(res -> Option.of((Object)res.getResolvedPrincipalEntry()));
    }

    public ExitCondition getExitCondition() {
        return this.exitCondition;
    }

    public String getMessage() {
        return this.message;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public SsoJitSideEffect getJitSideEffect() {
        return this.jitSideEffect;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public static class Builder {
        private String message;
        private AuthMethod authMethod;
        private ExitCondition exitCondition;
        private Option<String> maybeUsername;
        private FederatedIdentityResponseEvaluationResult evaluationResult;
        private IdpConfiguration idpConfiguration;
        private SsoJitSideEffect jitSideEffect;
        private String targetUrl;

        public Builder(@NonNull FederatedIdentityResponseEvaluationResult evaluationResult, @NonNull IdpConfiguration idpConfiguration) {
            this.message = null;
            this.authMethod = AuthMethod.UNKNOWN;
            this.exitCondition = ExitCondition.CONTINUE_PROCESSING;
            this.maybeUsername = Option.none();
            this.evaluationResult = evaluationResult;
            this.idpConfiguration = idpConfiguration;
            this.jitSideEffect = SsoJitSideEffect.NONE;
            this.targetUrl = null;
        }

        public Builder(String message, AuthMethod authMethod, ExitCondition exitCondition, FederatedIdentityResponseEvaluationResult evaluationResult, IdpConfiguration idpConfiguration, SsoJitSideEffect jitSideEffect, String targetUrl) {
            this.message = message;
            this.authMethod = authMethod;
            this.exitCondition = exitCondition;
            this.evaluationResult = evaluationResult;
            this.idpConfiguration = idpConfiguration;
            this.jitSideEffect = jitSideEffect;
            this.targetUrl = targetUrl;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setAuthMethod(AuthMethod authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        public Builder setExitCondition(ExitCondition exitCondition) {
            this.exitCondition = exitCondition;
            return this;
        }

        public Builder setPrincipalEntry(PrincipalEntry maybePrincipalEntry) {
            this.evaluationResult.setResolvedPrincipalEntry(maybePrincipalEntry);
            return this;
        }

        public Builder setUsername(String maybeUsername) {
            this.maybeUsername = Option.of((Object)maybeUsername);
            return this;
        }

        public Builder setEvaluationResult(FederatedIdentityResponseEvaluationResult evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public Builder setIdpConfiguration(IdpConfiguration idpConfiguration) {
            this.idpConfiguration = idpConfiguration;
            return this;
        }

        public Builder setJitSideEffect(SsoJitSideEffect jitSideEffect) {
            this.jitSideEffect = jitSideEffect;
            return this;
        }

        public Builder setTargetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
            return this;
        }

        public SsoPostProcessingResult build() {
            return new SsoPostProcessingResult(this.message, this.authMethod, this.exitCondition, this.evaluationResult, this.idpConfiguration, this.jitSideEffect, this.targetUrl);
        }
    }

    public static enum ExitCondition {
        SSO_LOGIN,
        ANONYMOUS_BROWSING,
        LOGIN_FAILED,
        CONTINUE_PROCESSING;

    }

    public static enum SsoJitSideEffect {
        CREATE_USER,
        UPDATE_USER,
        NONE;

    }
}

