/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc.evaluation;

import io.vavr.CheckedFunction0;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.saml.TestRecord;

public class OidcTestRecord
extends TestRecord {
    public OidcTestRecord(String id, Date lastModified, Properties props) {
        super(id, lastModified, props);
    }

    public static OidcTestRecord ofTestRecord(TestRecord testRecord) {
        return new OidcTestRecord(testRecord.getId(), testRecord.getLastModified(), testRecord.getProps());
    }

    public String getTargetUrl() {
        return this.props.getProperty("targetUrl");
    }

    @Override
    public String getResponseAddress() {
        return this.props.getProperty("responseAddress");
    }

    public String getErrorCode() {
        return this.props.getProperty("errorCode");
    }

    public String getErrorMessage() {
        return this.props.getProperty("errorMessage");
    }

    public String getError() {
        return this.props.getProperty("error");
    }

    @Override
    public Date getRequestTime() {
        return (Date)Option.of((Object)this.props.getProperty("requestTime")).map(time -> ISODateTimeFormat.dateTimeParser().parseDateTime(time).toDate()).getOrNull();
    }

    @Override
    public Date getResponseTime() {
        String responseTime = this.props.getProperty("responseTime");
        return responseTime == null ? null : ISODateTimeFormat.dateTimeParser().parseDateTime(responseTime).toDate();
    }

    @Override
    public ResponseEvaluationCode getCode() {
        String code = this.props.getProperty("code");
        if (code == null) {
            return ResponseEvaluationCode.WAITING_FOR_RESPONSE;
        }
        return (ResponseEvaluationCode)((Object)Try.of((CheckedFunction0 & Serializable)() -> ResponseEvaluationCode.valueOf(code)).getOrElse((Object)ResponseEvaluationCode.UNKNOWN));
    }

    @Override
    public IdpConfiguration.SSOProtocol getSsoProtocol() {
        return IdpConfiguration.SSOProtocol.OIDC;
    }

    @Override
    public String getUsername() {
        return this.props.getProperty("username");
    }

    @Override
    public String getFullname() {
        return this.props.getProperty("fullname");
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        HashMap errorData = Option.of((Object)this.props.getProperty("error")).isDefined() ? HashMap.of((Object)"isErrorTestResult", (Object)true, (Object)"errorCode", (Object)this.getErrorCode(), (Object)"errorMessage", (Object)this.getErrorMessage(), (Object)"oidcTestError", (Object)this.getError()) : HashMap.empty();
        HashMap record = HashMap.of((Object)"id", (Object)this.id, (Object)"ssoProtocol", (Object)((Object)this.getSsoProtocol()), (Object)"lastModified", (Object)this.lastModified, (Object)"username", (Object)this.getUsername(), (Object)"fullName", (Object)this.getFullname(), (Object)"code", (Object)(this.getCode().toString() + "(" + this.getCode().getDisplayName() + ")"), (Object)"requestTime", (Object)this.getRequestTime(), (Object)"responseTime", (Object)this.getResponseTime(), (Object)"requestAddress", (Object)this.getRequestAddress(), (Object)"responseAddress", (Object)this.getResponseAddress());
        json.put("oidcTestRecord[" + this.id + "]", record.merge((Map)errorData).toJavaMap());
        return json;
    }
}

