/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.dircopy;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.MultipartHttpRequest;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.dircopy.ManageUsersInGroupsServlet;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.kantega.atlaskerb.velocity.model.DirectoryDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateUsersServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ManageUsersInGroupsServlet.class);
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final DirectoryManager directoryManager;

    @Inject
    public CreateUsersServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.directoryManager = this.hostApp.getDirectoryManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.modelAndRender(req, resp, 0, 0);
    }

    private void modelAndRender(HttpServletRequestFacade req, HttpServletResponseFacade resp, int usersForCreation, int usersCreated) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dark-features");
        model.put("menuItem", "createUsers");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("usersCreated", usersCreated);
        model.put("usersForCreation", usersForCreation);
        List<Map<String, String>> groups = GroupSearchUtil.getGroupsAsListMap("", this.userManager);
        model.put("groups", groups);
        List directories = this.hostApp.getCrowdDirectoryService().findAllDirectories();
        List writableDirectories = directories.stream().filter(this.hostApp::isWritableDirectory).collect(Collectors.toList());
        List writableDirectoryLocal = writableDirectories.stream().map(DirectoryDto::from).sorted(Comparator.comparingLong(DirectoryDto::getId)).collect(Collectors.toList());
        model.put("writableDirectories", writableDirectoryLocal);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/createUsers.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        MultipartHttpRequest multipartRequest = this.getMultipartRequest(req, 100000L);
        ArrayList<Object> usersForCreation = new ArrayList();
        byte[] file = multipartRequest.getFile("usersFile");
        if (file != null) {
            String usersFile = new String(file, StandardCharsets.UTF_8);
            usersForCreation = this.getUsersFromFile(usersFile);
        }
        long directoryId = Long.parseLong(multipartRequest.getParameter("directoryId"));
        String addToGroup = multipartRequest.getParameter("addToGroup");
        HashSet<String> groupSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)addToGroup)) {
            groupSet.add(addToGroup);
        }
        int numberOfRandomUsers = Integer.parseInt(multipartRequest.getParameter("numberOfRandomUsers"));
        if (usersForCreation.isEmpty() && numberOfRandomUsers > 0) {
            usersForCreation = this.createRandomUsers(numberOfRandomUsers);
        }
        int usersCreated = this.createUsersInDirectory(usersForCreation, directoryId, groupSet);
        this.modelAndRender(req, resp, usersForCreation.size(), usersCreated);
    }

    private int createUsersInDirectory(ArrayList<UserForCreation> usersForCreation, long directoryId, Set<String> groupSet) {
        Directory createInDirectory = null;
        int usersCreated = 0;
        try {
            createInDirectory = this.directoryManager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with id " + directoryId, (Throwable)e);
            return usersCreated;
        }
        for (UserForCreation userForCreation : usersForCreation) {
            try {
                this.hostApp.addUser(createInDirectory, userForCreation.name, userForCreation.displayName, userForCreation.email, groupSet, true);
            }
            catch (UserAlreadyExistsException e) {
                log.error("User already existed " + userForCreation.name, (Throwable)e);
                continue;
            }
            catch (Exception e) {
                log.error("Unable to create user  " + userForCreation.name, (Throwable)e);
                continue;
            }
            ++usersCreated;
            log.info("Created user " + userForCreation.name);
        }
        return usersCreated;
    }

    private ArrayList<UserForCreation> createRandomUsers(int numberOfRandomUsers) {
        ArrayList<UserForCreation> usersForCreation = new ArrayList<UserForCreation>();
        for (int i = 0; i < numberOfRandomUsers; ++i) {
            String username = "generated_user_" + UUID.randomUUID().toString().substring(0, 8);
            String displayName = StringUtils.replaceChars((String)StringUtils.capitalize((String)username), (String)"_", (String)" ");
            String email = username + "@example.com";
            usersForCreation.add(new UserForCreation(username, displayName, email));
        }
        return usersForCreation;
    }

    private ArrayList<UserForCreation> getUsersFromFile(String usersFile) {
        String[] lines = usersFile.split("\n");
        ArrayList<UserForCreation> usersForCreation = new ArrayList<UserForCreation>();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split(",");
            String username = parts[0].trim();
            String displayName = parts[1].trim();
            String email = parts[2].trim();
            usersForCreation.add(new UserForCreation(username, displayName, email));
        }
        return usersForCreation;
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    private static class UserForCreation {
        private final String name;
        private final String displayName;
        private final String email;

        public UserForCreation(String name, String displayName, String email) {
            this.name = name;
            this.displayName = displayName;
            this.email = email;
        }
    }
}

