/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;

public class CrowdUtil {
    public static CrowdType crowdTypeAnalysis(Directory directory) {
        String crowdType = (String)directory.getAttributes().get("crowdType");
        if (crowdType != null) {
            return crowdType.equals(CrowdType.JIRA_CROWD.toString()) ? CrowdType.JIRA_CROWD : CrowdType.ATLASSIAN_CROWD;
        }
        return StringUtils.containsIgnoreCase((CharSequence)directory.getName(), (CharSequence)"jira") || StringUtils.containsIgnoreCase((CharSequence)((CharSequence)directory.getAttributes().get("crowd.server.url")), (CharSequence)"jira") ? CrowdType.JIRA_CROWD : CrowdType.ATLASSIAN_CROWD;
    }

    public static void addCrowdDirectoriesToModel(Map<String, Object> model, HostApp hostApp) {
        List crowdDirectories = hostApp.getCrowdDirectoryService().findAllDirectories().stream().filter(directory -> directory.getType() == DirectoryType.CROWD).collect(Collectors.toList());
        ArrayList<CrowdDir> crowdDirs = new ArrayList<CrowdDir>();
        for (Directory directory2 : crowdDirectories) {
            crowdDirs.add(new CrowdDir(directory2));
        }
        model.put("crowdDirs", crowdDirs);
        model.put("crowdDirectories", crowdDirectories);
    }

    public static enum CrowdType {
        ATLASSIAN_CROWD("ATLASSIAN_CROWD"),
        JIRA_CROWD("JIRA_CROWD");

        private final String value;

        private CrowdType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class CrowdDir {
        private final String name;
        private final Long id;
        private final boolean isActive;
        private final CrowdType crowdType;

        public CrowdDir(Directory directory) {
            this.name = directory.getName();
            this.id = directory.getId();
            this.isActive = directory.isActive();
            this.crowdType = CrowdUtil.crowdTypeAnalysis(directory);
        }

        public String getName() {
            return this.name;
        }

        public Long getId() {
            return this.id;
        }

        public boolean getActive() {
            return this.isActive;
        }

        public CrowdType crowdType() {
            return this.crowdType;
        }
    }
}

