/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kantega.shaded.org.opensaml.storage.StorageRecord;
import org.jetbrains.annotations.NotNull;
import org.kantega.samllib.cache.CacheStorageService;

public class AtlassianCacheStorageService
extends CacheStorageService {
    private final Cache<String, Long> cache;

    public AtlassianCacheStorageService(CacheManager cacheManager) {
        this.setContextSize(Integer.MAX_VALUE);
        this.setKeySize(Integer.MAX_VALUE);
        this.setValueSize(Integer.MAX_VALUE);
        String name = AtlassianCacheStorageService.class.getName() + ".samlReplayCache";
        this.cache = cacheManager.getCache(name, null, new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterWrite(1L, TimeUnit.HOURS).maxEntries(Integer.parseInt(System.getProperty(name, "25000"))).build());
    }

    public boolean create(@Nonnull String context, @Nonnull String key, @NotNull String value, @Nullable Long expiration) {
        String k = this.getKey(context, key);
        Long stored = (Long)this.cache.get((Object)k);
        if (stored != null) {
            if (System.currentTimeMillis() < stored) {
                return false;
            }
            this.cache.remove((Object)k);
        }
        this.cache.put((Object)k, (Object)expiration);
        return true;
    }

    protected String getKey(String context, String key) {
        return context + ":" + key;
    }

    @Nullable
    public StorageRecord read(@Nonnull String context, @Nonnull String key) {
        Long expiration = (Long)this.cache.get((Object)this.getKey(context, key));
        if (expiration == null) {
            return null;
        }
        return new StorageRecord("x", expiration);
    }
}

