/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import kantega.shaded.org.opensaml.saml.saml2.core.AuthnRequest;
import kantega.shaded.org.opensaml.saml.saml2.core.Response;
import kantega.shaded.org.opensaml.xmlsec.signature.impl.X509CertificateImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogin;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataCache;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.ServiceProviderFactory;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.atlaskerb.wrapper.upm.PluginLicenseWrapper;
import org.kantega.samllib.spi.AuthnState;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.SamlResponseValidator;
import org.kantega.samllib.validation.ValidationResult;
import org.kantega.samllib.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EvaluateTestServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final SAMLResponseEvaluator samlResponseEvaluator;
    private final OidcResponseEvaluator oidcResponseEvaluator;
    private final PluginLicenseManager licenseManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final OidcDataCache oidcDataCache;
    private final ServiceProviderFactory serviceProviderFactory;
    private final ConnectorConfManager connectorConfManager;
    private final OidcLibWrapper oidcLibWrapper;
    private final InitiateOidcLogin initiateOidcLogin;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public EvaluateTestServlet(RequireAdminServletDependencyBucket bucket, SAMLResponseEvaluator samlResponseEvaluator, OidcResponseEvaluator oidcResponseEvaluator, OidcDataCache oidcDataCache, ServiceProviderFactory serviceProviderFactory, InitiateOidcLogin initiateOidcLogin) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.licenseManager = bucket.getPluginLicenseManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostApp();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.samlResponseEvaluator = samlResponseEvaluator;
        this.oidcResponseEvaluator = oidcResponseEvaluator;
        this.oidcDataCache = oidcDataCache;
        this.serviceProviderFactory = serviceProviderFactory;
        this.oidcLibWrapper = bucket.getOidcFactory().createOidcLibWrapper(bucket.getJsonWrapper());
        this.initiateOidcLogin = initiateOidcLogin;
    }

    protected void doGetKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        IdpConfiguration idp = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(request));
        if (idp == null) {
            response.sendError(404);
            return;
        }
        this.runTest(idp, request, response, idp.getUsernameAttributePriority(), this.getUserLookupAttributeFromConfig(idp), idp.getUserLookupTransform(), idp.getCustomNameAttribute(), idp.getCustomGivenNameAttribute(), idp.getCustomSurnameAttribute(), idp.getNameAttributeMapping(), idp.getCustomEmailAttribute());
    }

    private IdpConfiguration.UserLookupAttribute getUserLookupAttributeFromConfig(IdpConfiguration idp) {
        IdpConfiguration.UserLookupAttribute userLookupAttribute = idp.getUserLookupAttribute();
        if (idp.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
            userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
        }
        return userLookupAttribute;
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping;
        IdpConfiguration current = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(request));
        if (current == null) {
            response.sendError(404);
            return;
        }
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(current);
        if ((current = this.setStoredUserAttributes(request, builder, current)) == null) {
            return;
        }
        if ("true".equals(request.getParameter("saveIsIdpEnabled")) && "on".equals(request.getParameter("isIdpEnabled"))) {
            builder.setEnabled(true);
            current = builder.build();
            this.idpConfManager.updateIdpConfiguration(current);
            response.sendRedirect(request.getRequestURI());
            return;
        }
        if (request.getParameter("addKnownDomain") != null) {
            String domain = StringUtils.trim((String)request.getParameter("domain"));
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                builder.getKnownDomains().add(domain);
            }
        } else if (request.getParameter("allowAllDomains") != null) {
            builder.setUsernamePolicy(IdpConfiguration.UsernamePolicy.ANY);
        }
        if (request.getParameter("manageGroups") != null) {
            TreeSet<ManagedGroup> managed = new TreeSet<ManagedGroup>(current.getManagedGroups());
            this.getGroupUpdates(request).stream().map(ManagedGroup::new).forEach(managed::add);
            builder.setManagedGroups(new ArrayList<ManagedGroup>(managed));
        }
        current = builder.build();
        this.idpConfManager.updateIdpConfiguration(current);
        UsernameAttribute usernameAttribute = this.getUsernameAttribute(request);
        String customUsernameAttributeName = StringUtils.trim((String)request.getParameter("customUsernameAttributeName"));
        ArrayList<Pair<UsernameAttribute, String>> newUsernameAttributePriority = new ArrayList<Pair<UsernameAttribute, String>>();
        newUsernameAttributePriority.add(Pair.of((Object)((Object)usernameAttribute), (Object)customUsernameAttributeName));
        EvaluateTestServlet.copyFallbackAttributesFromCurrent(current, newUsernameAttributePriority);
        IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.valueOf(request.getParameter("userLookupAttribute"));
        String customNameAttribute = StringUtils.trimToNull((String)request.getParameter("customNameAttributeSelector"));
        String customGivenNameAttribute = StringUtils.trimToNull((String)request.getParameter("customGivenNameAttributeSelector"));
        String customSurnameAttribute = StringUtils.trimToNull((String)request.getParameter("customSurnameAttributeSelector"));
        String customEmailAttribute = StringUtils.trimToNull((String)request.getParameter("customEmailAttributeSelector"));
        IdpConfManager.NAME_ATTRIBUTE_MAPPING nAME_ATTRIBUTE_MAPPING = nameAttributeMapping = StringUtils.trimToNull((String)request.getParameter("nameAttributeMapping")) != null && "firstAndLastName".equals(StringUtils.trimToNull((String)request.getParameter("nameAttributeMapping"))) ? IdpConfManager.NAME_ATTRIBUTE_MAPPING.FIRST_AND_LAST_NAME : IdpConfManager.NAME_ATTRIBUTE_MAPPING.FULL_NAME;
        if (request.getParameter("saveSettings") != null) {
            IdpConfigurationBuilder<?, ?> b = IdpConfigurationBuilder.ofGeneric(current);
            b.setUsernameAttributePriority(newUsernameAttributePriority);
            b.setUserLookupAttribute(userLookupAttribute);
            b.setCustomNameAttribute(customNameAttribute);
            b.setCustomGivenNameAttribute(customGivenNameAttribute);
            b.setCustomSurnameAttribute(customSurnameAttribute);
            b.setNameAttributeMapping(nameAttributeMapping);
            b.setCustomEmailAttribute(customEmailAttribute);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)b.build());
            response.sendRedirect("evaluate-test/" + EvaluateTestServlet.getTestIdFromRequest(request) + "/result");
        } else {
            this.runTest(current, request, response, newUsernameAttributePriority, userLookupAttribute, current.getUserLookupTransform(), customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute);
        }
    }

    @Nullable
    private IdpConfiguration setStoredUserAttributes(HttpServletRequestFacade request, IdpConfigurationBuilder<?, ?> builder, IdpConfiguration current) {
        String storedUserAttribute = request.getParameter("storedUserAttribute");
        if (storedUserAttribute != null) {
            JSONArray storedUserAttributes = current.getStoredUserAttributes();
            if ("on".equals(request.getParameter("setStoredUserAttribute"))) {
                String storedUserAttributeNameAlias = request.getParameter("storedUserAttributeNameAlias");
                EvaluateTestServlet.removeKeyFromJsonArray(storedUserAttributes, storedUserAttribute);
                storedUserAttributes.put((Object)new JSONObject().put(storedUserAttribute, (Object)storedUserAttributeNameAlias));
            } else if (current.containsStoredUserAttribute(storedUserAttribute)) {
                EvaluateTestServlet.removeKeyFromJsonArray(storedUserAttributes, storedUserAttribute);
            }
            builder.setStoredUserAttributes(storedUserAttributes);
            current = builder.build();
            this.idpConfManager.updateIdpConfiguration(current);
            return null;
        }
        if (request.getParameter("removeUnusedUserAttributesFormPosted") != null) {
            builder.setRemoveUnusedUserAttributes("on".equals(request.getParameter("removeUnusedUserAttributes")));
            current = builder.build();
            this.idpConfManager.updateIdpConfiguration(current);
            return null;
        }
        return current;
    }

    private static void removeKeyFromJsonArray(JSONArray jsonArray, String keyToRemove) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!jsonObject.has(keyToRemove)) continue;
            jsonArray.remove(i);
        }
    }

    private static void copyFallbackAttributesFromCurrent(IdpConfiguration current, java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority) {
        java.util.List<Pair<UsernameAttribute, String>> currentUsernameAttributePriority = current.getUsernameAttributePriority();
        if (currentUsernameAttributePriority != null) {
            if (currentUsernameAttributePriority.size() > 1) {
                newUsernameAttributePriority.add(currentUsernameAttributePriority.get(1));
            }
            if (currentUsernameAttributePriority.size() > 2) {
                newUsernameAttributePriority.add(currentUsernameAttributePriority.get(2));
            }
        }
    }

    private UsernameAttribute getUsernameAttribute(HttpServletRequestFacade request) {
        String usernameAttribute = request.getParameter("usernameAttribute");
        if (StringUtils.isBlank((CharSequence)usernameAttribute)) {
            return UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
        try {
            return UsernameAttribute.valueOf(StringUtils.upperCase((String)usernameAttribute));
        }
        catch (IllegalArgumentException e) {
            return UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
    }

    private UsernameAttribute getUsernameAttributeOf(String attributeName) {
        try {
            return UsernameAttribute.valueOf(StringUtils.upperCase((String)attributeName));
        }
        catch (IllegalArgumentException e) {
            return UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
    }

    @NotNull
    private Set<String> getGroupUpdates(HttpServletRequestFacade request) {
        TreeSet<String> addGroups = new TreeSet<String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
            if (!param.startsWith("manage_group_")) continue;
            addGroups.add(param.substring("manage_group_".length()));
        }
        return addGroups;
    }

    private void runTest(IdpConfiguration idp, HttpServletRequestFacade req, HttpServletResponseFacade resp, java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute) throws IOException {
        if (req.getParameter("run") != null) {
            if (idp.isSaml()) {
                resp.sendRedirect(this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId()) + "?test");
            } else if (idp.isOidc()) {
                OidcIdpConfiguration oidcIdpConfiguration = (OidcIdpConfiguration)idp;
                String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
                InitiateOidcLogin.OidcLoginResult result = this.initiateOidcLogin.run(oidcIdpConfiguration, this.idpConfManager, callbackUrl, null, null, this.oidcDataCache, null, this.oidcLibWrapper, TestUtils.isTest(req));
                if (result.isSuccess()) {
                    resp.sendRedirect(result.getAuthorizationUrl());
                } else {
                    resp.sendRedirect("");
                }
            }
            return;
        }
        String id = EvaluateTestServlet.getTestIdFromRequest(req);
        if (id != null) {
            TestRecord record;
            TestRecord testRecord = record = idp.isSaml() ? this.idpConfManager.getRecordedTest(idp.getId(), id) : this.idpConfManager.getRecordedOIDCTest(idp.getId(), id);
            if (record == null) {
                resp.sendError(404);
                return;
            }
            if (idp.isSaml()) {
                this.evaluateTest((SamlIdpConfiguration)idp, record, req, resp, newUsernameAttributePriority, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute);
            } else if (idp.isOidc()) {
                this.evaluateTest((OidcIdpConfiguration)idp, record, req, resp, newUsernameAttributePriority, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute);
            }
        } else {
            resp.sendError(404);
        }
    }

    private void checkNonstandardSeraphAuthenticator(Map<String, Object> model) {
        String nonStandardAuthenticator = this.hostApp.hasNonStandardAuthenticator();
        if (nonStandardAuthenticator != null) {
            model.put("nonStandardSeraphAuthenticator", nonStandardAuthenticator);
            model.put("standardSeraphAuthenticator", this.hostApp.getStandardAuthenticatorClassName());
        }
    }

    private void evaluateTest(SamlIdpConfiguration idp, TestRecord record, HttpServletRequestFacade req, HttpServletResponseFacade resp, java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute) throws IOException {
        File responseFile;
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel(req);
        this.checkNonstandardSeraphAuthenticator(model);
        model.put("validationResult", null);
        model.put("knownAttributeNames", this.samlResponseEvaluator.getKnownAttributeNames());
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerTest");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdURL", req.getContextPath() + "/plugins/servlet/embedded-crowd/directories/list");
        model.put("userLookupService", this.userLookupService);
        model.put("idp", idp);
        model.put("dateTool", new DateTool());
        model.put("dirtySettings", this.isSettingsDirty(idp, newUsernameAttributePriority, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, customEmailAttribute));
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idp.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(idp.getKind()));
        this.checkLicensing(model);
        model.put("providerUrl", this.idpConfManager.getProviderAdminUrl(idp.getId(), req));
        model.put("loginUrl", this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId()));
        if (newUsernameAttributePriority != null && newUsernameAttributePriority.size() > 0) {
            model.put("usernameAttribute", newUsernameAttributePriority.get(0).getLeft());
            model.put("customUsernameAttributeName", newUsernameAttributePriority.get(0).getRight());
        }
        if (newUsernameAttributePriority != null && newUsernameAttributePriority.size() > 1) {
            model.put("usernameAttribute2", ((UsernameAttribute)((Object)newUsernameAttributePriority.get(1).getLeft())).getDisplayName());
            model.put("customUsernameAttributeName2", newUsernameAttributePriority.get(1).getRight());
            model.put("CUSTOM_SAML_ATTRIBUTE_NAME", UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME.getDisplayName());
        }
        if (newUsernameAttributePriority != null && newUsernameAttributePriority.size() > 2) {
            model.put("usernameAttribute3", ((UsernameAttribute)((Object)newUsernameAttributePriority.get(2).getLeft())).getDisplayName());
            model.put("customUsernameAttributeName3", newUsernameAttributePriority.get(2).getRight());
        }
        if (idp.getUsernameAttributePriority() != null && idp.getUsernameAttributePriority().size() > 0) {
            model.put("currentUsernameAttribute", ((UsernameAttribute)((Object)idp.getUsernameAttributePriority().get(0).getLeft())).getDisplayName());
        }
        this.addCommonAttributes(userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, customEmailAttribute, model);
        model.put("customUsernameAttributeKey", (Object)UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME);
        File requestFile = this.idpConfManager.getRecordedTestRequestFile(idp.getId(), record.getId());
        if (requestFile.exists()) {
            AuthnRequest authnRequest = this.parseRequestFile(requestFile);
            model.put("requestXML", XmlUtils.formatXml((Element)authnRequest.getDOM()));
        }
        if ((responseFile = this.idpConfManager.getRecordedTestResponseFile(idp.getId(), record.getId())).exists()) {
            Response response = this.parseResponseFile(responseFile);
            model.put("responseXML", XmlUtils.formatXml((Element)response.getDOM()));
            ServiceProviderSpi instance = this.serviceProviderFactory.getInstance(idp);
            Properties props = this.idpConfManager.getTestProperties(idp.getId(), record);
            Instant now = (Instant)Option.of((Object)props.getProperty("responseTime")).onEmpty(() -> model.put("incompleteResponse", true)).map(responseTime -> Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)responseTime))).getOrElse((Object)Instant.now());
            TestPageAuthnStateCache authnStateCache = new TestPageAuthnStateCache();
            authnStateCache.put(record.getId(), new AuthnState());
            SamlResponseValidationResult result = new SamlResponseValidationResult(req, resp, instance, now);
            new SamlResponseValidator(null, (AuthnStateCache)authnStateCache, instance).validate(response, result);
            if (result.hasDecryptedAssertions()) {
                model.put("hasDecryptedAssertions", true);
                model.put("decryptedAssertionsXML", result.getDecryptedAssertions().stream().map(assertion -> XmlUtils.formatXml((Element)assertion.getDOM())).collect(Collectors.toList()));
            }
            java.util.List validationResults = List.ofAll((Iterable)result.getResults()).map(res -> {
                Map resModel = res.getModel();
                JSONObject parsedCert = (JSONObject)io.vavr.collection.HashMap.ofAll((Map)resModel).get((Object)"cert").toTry().mapTry((CheckedFunction1 & Serializable)cert -> (X509CertificateImpl)cert).mapTry(X509CertificateImpl::getValue).filterTry(Objects::nonNull).mapTry(CertTool::parse).mapTry((CheckedFunction1 & Serializable)cert -> {
                    JSONObject certJson = new JSONObject();
                    certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
                    certJson.put("issuerDn", (Object)cert.getIssuerDN().getName());
                    certJson.put("notBefore", (Object)cert.getNotBefore().toString());
                    certJson.put("notAfter", (Object)cert.getNotAfter().toString());
                    certJson.put("sigAlgName", (Object)cert.getSigAlgName());
                    certJson.put("keySize", (Object)String.valueOf(CertTool.getKeySize(cert)));
                    certJson.put("fingerPrint", (Object)CertTool.fingerPrint(cert.getEncoded()));
                    return certJson;
                }).getOrElse((Object)new JSONObject());
                HashMap<String, JSONObject> newMap = new HashMap<String, JSONObject>(resModel);
                newMap.put("parsedCert", parsedCert);
                return new ValidationResult(res.getMessage(), res.getType(), newMap);
            }).asJava();
            model.put("samlValidationResults", validationResults);
            idp = (SamlIdpConfiguration)this.buildTestIdpConfiguration(newUsernameAttributePriority, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, new IdpConfigurationBuilder.Saml(idp));
            SAMLResponseEvaluationResult evaluationResult = this.samlResponseEvaluator.evaluate(idp, result, false);
            model.put("evaluationResult", evaluationResult);
            boolean serviceUrlWithHttps = StringUtils.startsWith((CharSequence)StringUtils.lowerCase((String)this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId())), (CharSequence)"https");
            model.put("notHttps", !serviceUrlWithHttps);
            AttributeInfo configuredAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
            if (configuredAttribute != null) {
                model.put("configuredUsernameAttribute", configuredAttribute);
                boolean userDomainRejected = evaluationResult.isUserDomainRejected();
                model.put("userDomainRejected", userDomainRejected);
                boolean success = false;
                String username = null;
                if (evaluationResult.getResolvedPrincipalEntry() != null) {
                    PrincipalEntry pe = evaluationResult.getResolvedPrincipalEntry();
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    if (userRecipe != null) {
                        model.put("userRecipe", userRecipe);
                    }
                    if (userRecipe != null && !userRecipe.isComplete()) {
                        model.put("missingUserInfoForJIT", true);
                    }
                    if (pe.getPrincipal().isPresent()) {
                        Principal user = pe.getPrincipal().get();
                        username = user.getName();
                        model.put("usersDirectoryName", this.hostApp.getDirectoryForUser(user.getName()) != null ? this.hostApp.getDirectoryForUser(user.getName()).getName() : "Not found");
                        model.put("userPrincipal", user);
                        model.put("userPrincipalName", username);
                        model.put("userProfile", this.userManager.getUserProfile(user.getName()));
                        model.put("contextPath", req.getContextPath());
                        boolean canLogin = this.hostApp.canLogin(user, req);
                        model.put("canLogin", canLogin);
                        success = canLogin && !userDomainRejected && pe.getUserState() == PrincipalEntry.UserState.FOUND;
                    }
                    model.put("isActive", pe.getUserState() != PrincipalEntry.UserState.INACTIVE);
                } else if (evaluationResult.getUserRecipe() != null) {
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    model.put("userRecipe", userRecipe);
                    if (userRecipe.isComplete()) {
                        username = userRecipe.getUsername().getValue();
                        boolean bl = success = !userDomainRejected;
                    }
                }
                if (username != null) {
                    if (username.length() > 20) {
                        model.put("currentUsernameTooLongForJiTInAD", true);
                    }
                    this.samlResponseEvaluator.evaluateGroups(username, idp.getManagedGroups(), this.samlResponseEvaluator.findSamlGroups(result.getAssertions()), evaluationResult.getGroupEvaluation());
                    boolean requiredGroupsForCreation = IdpConfManager.hasRequiredGroupsForCreationOrActivation(idp, evaluationResult.getGroupEvaluation());
                    model.put("hasRequiredGroupsForCreation", requiredGroupsForCreation);
                    model.put("success", success && requiredGroupsForCreation);
                } else {
                    model.put("success", success);
                }
            }
            this.idpConfManager.updateAndStoreTestresults(idp.getId(), result, evaluationResult);
        }
        record = idp.isSaml() ? this.idpConfManager.getRecordedTest(idp.getId(), record.getId()) : this.idpConfManager.getRecordedOIDCTest(idp.getId(), record.getId());
        model.put("record", record);
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, this.hostApp, "SAML");
        StringWriter debuginfo = new StringWriter();
        this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
        model.put("debugInfo", debuginfo);
        this.checkIfAdIsUsedForJit(idp, model);
        this.renderer.render("templates/idp-login-test/saml-test-result.vm", model, (Writer)resp.getWriter());
    }

    private void checkIfAdIsUsedForJit(IdpConfiguration idp, Map<String, Object> model) {
        Directory jitDir = this.hostApp.getCrowdDirectoryService().findDirectoryById(idp.getJitDirectory().orElse(-1L).longValue());
        if (jitDir != null && jitDir.getType() == DirectoryType.CONNECTOR) {
            model.put("maxUsernameLengthJitInAd", 20);
            model.put("adJitUsernameLengthWarning", true);
        }
    }

    private void evaluateTest(OidcIdpConfiguration idp, TestRecord record, HttpServletRequestFacade req, HttpServletResponseFacade resp, java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute) throws IOException {
        File responseFile;
        Try<String> oidcProcedureJson;
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel(req);
        this.checkNonstandardSeraphAuthenticator(model);
        model.put("validationResult", null);
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerTest");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdURL", req.getContextPath() + "/plugins/servlet/embedded-crowd/directories/list");
        model.put("userLookupService", this.userLookupService);
        model.put("idp", idp);
        model.put("dateTool", new DateTool());
        model.put("dirtySettings", this.isOidcSettingsDirty(idp, newUsernameAttributePriority, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, customEmailAttribute));
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idp.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(idp.getKind()));
        this.checkLicensing(model);
        if (newUsernameAttributePriority != null && newUsernameAttributePriority.size() > 0) {
            model.put("usernameAttribute", newUsernameAttributePriority.get(0).getLeft());
            model.put("customUsernameAttributeName", newUsernameAttributePriority.get(0).getRight());
        }
        if (newUsernameAttributePriority != null && newUsernameAttributePriority.size() > 1) {
            model.put("usernameAttribute2", ((UsernameAttribute)((Object)newUsernameAttributePriority.get(1).getLeft())).getDisplayName());
            model.put("customUsernameAttributeName2", newUsernameAttributePriority.get(1).getRight());
            model.put("CUSTOM_SAML_ATTRIBUTE_NAME", UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME.getDisplayName());
        }
        if (newUsernameAttributePriority != null && newUsernameAttributePriority.size() > 2) {
            model.put("usernameAttribute3", ((UsernameAttribute)((Object)newUsernameAttributePriority.get(2).getLeft())).getDisplayName());
            model.put("customUsernameAttributeName3", newUsernameAttributePriority.get(2).getRight());
        }
        if (idp.getUsernameAttributePriority() != null && idp.getUsernameAttributePriority().size() > 0) {
            model.put("currentUsernameAttribute", ((UsernameAttribute)((Object)idp.getUsernameAttributePriority().get(0).getLeft())).getDisplayName());
        }
        model.put("customUsernameAttributeKey", (Object)UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME);
        this.addCommonAttributes(userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, customEmailAttribute, model);
        String idpId = idp.getId();
        TestRecord finalRecord = record;
        Try.of((CheckedFunction0 & Serializable)() -> this.idpConfManager.getTestProperties(idpId, finalRecord)).onSuccess(testProperties -> {
            boolean isError = Option.of((Object)testProperties.getProperty("error")).isDefined();
            if (isError) {
                model.put("isErrorTestResult", true);
                model.put("errorCode", testProperties.getProperty("errorCode"));
                model.put("errorMessage", testProperties.getProperty("errorMessage"));
                model.put("oidcTestError", testProperties.getProperty("error"));
            }
            model.put("responseTime", testProperties.getProperty("responseTime"));
        });
        File beforeRequestProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileBeforeRequest(idp.getId(), record.getId());
        File initProcedureFile = this.idpConfManager.getRecordedTestStartedOIDCProcedureFile(idp.getId(), record.getId());
        if (beforeRequestProcedureFile.exists()) {
            oidcProcedureJson = TestUtils.readOidcProcedureJsonRepresentationFromFile(beforeRequestProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> model.put("oidcProcedureJsonBeforeRequest", jsonString));
        } else if (initProcedureFile.exists()) {
            oidcProcedureJson = TestUtils.readOidcProcedureJsonRepresentationFromFile(initProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> model.put("oidcProcedureJsonBeforeRequest", jsonString));
        }
        File afterResponseProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileAfterResponse(idp.getId(), record.getId());
        if (afterResponseProcedureFile.exists()) {
            Try<String> oidcProcedureJson2 = TestUtils.readOidcProcedureJsonRepresentationFromFile(afterResponseProcedureFile);
            oidcProcedureJson2.onSuccess(jsonString -> model.put("oidcProcedureJsonAfterResponse", jsonString));
        }
        if ((responseFile = this.idpConfManager.getRecordedOidcTestResponseFile(idp.getId(), record.getId())).exists()) {
            JSONObject profileJson = EvaluateTestServlet.parseJsonProfile(responseFile);
            model.put("profile", profileJson);
            idp = (OidcIdpConfiguration)this.buildTestIdpConfiguration(newUsernameAttributePriority, userLookupAttribute, userLookupTransform, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customEmailAttribute, new IdpConfigurationBuilder.Oidc(idp));
            OidcResponseEvaluationResult evaluationResult = this.oidcResponseEvaluator.evaluate(idp, profileJson, false);
            model.put("evaluationResult", evaluationResult);
            boolean serviceUrlWithHttps = StringUtils.startsWith((CharSequence)StringUtils.lowerCase((String)this.idpConfManager.getServiceProviderLoginUrl(req, idp.getId())), (CharSequence)"https");
            model.put("notHttps", !serviceUrlWithHttps);
            AttributeInfo configuredAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
            if (configuredAttribute != null) {
                model.put("configuredUsernameAttribute", configuredAttribute);
                boolean userDomainRejected = evaluationResult.isUserDomainRejected();
                model.put("userDomainRejected", userDomainRejected);
                boolean success = false;
                String username = null;
                if (evaluationResult.getResolvedPrincipalEntry() != null) {
                    PrincipalEntry pe = evaluationResult.getResolvedPrincipalEntry();
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    if (userRecipe != null) {
                        model.put("userRecipe", userRecipe);
                    }
                    if (userRecipe != null && !userRecipe.isComplete()) {
                        model.put("missingUserInfoForJIT", true);
                    }
                    if (pe.getPrincipal().isPresent()) {
                        Principal user = pe.getPrincipal().get();
                        username = user.getName();
                        model.put("usersDirectoryName", this.hostApp.getDirectoryForUser(user.getName()) != null ? this.hostApp.getDirectoryForUser(user.getName()).getName() : "Not found");
                        model.put("userPrincipal", user);
                        model.put("userPrincipalName", username);
                        model.put("userProfile", this.userManager.getUserProfile(user.getName()));
                        model.put("contextPath", req.getContextPath());
                        boolean canLogin = this.hostApp.canLogin(user, req);
                        model.put("canLogin", canLogin);
                        success = canLogin && !userDomainRejected && pe.getUserState() == PrincipalEntry.UserState.FOUND;
                    }
                    model.put("isActive", pe.getUserState() != PrincipalEntry.UserState.INACTIVE);
                } else if (evaluationResult.getUserRecipe() != null) {
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    model.put("userRecipe", userRecipe);
                    if (userRecipe.isComplete()) {
                        username = userRecipe.getUsername().getValue();
                        boolean bl = success = !userDomainRejected;
                    }
                }
                if (username != null) {
                    if (username.length() > 20) {
                        model.put("currentUsernameTooLongForJiTInAD", true);
                    }
                    java.util.List<ManagedGroup> managedOrAutoGroups = idp.getManagedGroups();
                    this.oidcResponseEvaluator.evaluateGroups(username, managedOrAutoGroups, this.oidcResponseEvaluator.findOidcGroups(profileJson, idp.getIdpGroupsAttributes()), evaluationResult.getGroupEvaluation());
                    boolean requiredGroupsForCreation = IdpConfManager.hasRequiredGroupsForCreationOrActivation(idp, evaluationResult.getGroupEvaluation());
                    model.put("hasRequiredGroupsForCreation", requiredGroupsForCreation);
                    model.put("isCreateAllIncomingGroups", idp.isCreateAllIncomingGroups());
                    if (idp.isCreateAllIncomingGroups()) {
                        model.put("autoCreateUserPolicy", idp.getAutoCreateUserPolicy().getKey());
                    }
                    model.put("success", success && requiredGroupsForCreation);
                } else {
                    model.put("success", success);
                }
            }
            this.idpConfManager.updateAndStoreTestresults(idp.getId(), record.getId(), evaluationResult);
        }
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, this.hostApp, "OIDC");
        record = idp.isSaml() ? this.idpConfManager.getRecordedTest(idp.getId(), record.getId()) : this.idpConfManager.getRecordedOIDCTest(idp.getId(), record.getId());
        model.put("record", record);
        StringWriter debuginfo = new StringWriter();
        this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
        model.put("debugInfo", debuginfo);
        this.checkIfAdIsUsedForJit(idp, model);
        this.renderer.render("templates/idp-login-test/oidc-test-result.vm", model, (Writer)resp.getWriter());
    }

    private IdpConfiguration buildTestIdpConfiguration(java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customEmailAttribute, IdpConfigurationBuilder builder) {
        builder.setUsernameAttributePriority(newUsernameAttributePriority);
        builder.setUserLookupAttribute(userLookupAttribute);
        builder.setUserLookupTransform(userLookupTransform);
        builder.setCustomNameAttribute(customNameAttribute);
        builder.setCustomGivenNameAttribute(customGivenNameAttribute);
        builder.setCustomSurnameAttribute(customSurnameAttribute);
        builder.setNameAttributeMapping(nameAttributeMapping);
        builder.setCustomEmailAttribute(customEmailAttribute);
        return builder.build();
    }

    public void addCommonAttributes(IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, String customEmailAttribute, Map<String, Object> model) {
        model.put("userLookupAttribute", (Object)userLookupAttribute);
        model.put("userLookupTransform", (Object)userLookupTransform);
        model.put("userLookupAttributes", IdpConfiguration.UserLookupAttribute.getValues());
        model.put("customNameAttribute", customNameAttribute);
        model.put("customGivenNameAttribute", customGivenNameAttribute);
        model.put("customSurnameAttribute", customSurnameAttribute);
        model.put("customEmailAttribute", customEmailAttribute);
        model.put("hasCustomUserAttribute", customNameAttribute != null || customEmailAttribute != null);
        model.put("hasLDAPDirectories", this.userLookupService.hasActiveLDAPDirectories());
    }

    private boolean isSettingsDirty(IdpConfiguration idp, java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, String customEmailAttribute) {
        return EvaluateTestServlet.isFirstUsernameAttributeDirty(idp, newUsernameAttributePriority) || userLookupAttribute != this.getUserLookupAttributeFromConfig(idp) || userLookupTransform != idp.getUserLookupTransform() || !StringUtils.equals((CharSequence)idp.getCustomNameAttribute(), (CharSequence)customNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomGivenNameAttribute(), (CharSequence)customGivenNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomSurnameAttribute(), (CharSequence)customSurnameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomEmailAttribute(), (CharSequence)customEmailAttribute);
    }

    private static boolean isFirstUsernameAttributeDirty(IdpConfiguration idp, java.util.List<Pair<UsernameAttribute, String>> newUsernameAttributePriority) {
        java.util.List<Pair<UsernameAttribute, String>> currentUsernameAttributePriority = idp.getUsernameAttributePriority();
        if (currentUsernameAttributePriority == null || newUsernameAttributePriority == null || currentUsernameAttributePriority.size() < 1 || newUsernameAttributePriority.size() < 1) {
            return true;
        }
        return currentUsernameAttributePriority.get(0).getLeft() != newUsernameAttributePriority.get(0).getLeft() || currentUsernameAttributePriority.get(0).getLeft() == UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME && !StringUtils.equals((CharSequence)((CharSequence)currentUsernameAttributePriority.get(0).getRight()), (CharSequence)((CharSequence)newUsernameAttributePriority.get(0).getRight()));
    }

    private boolean isOidcSettingsDirty(IdpConfiguration idp, java.util.List<Pair<UsernameAttribute, String>> usernameAttributePriority, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, String customEmailAttribute) {
        return EvaluateTestServlet.isFirstUsernameAttributeDirty(idp, usernameAttributePriority) || userLookupAttribute != this.getUserLookupAttributeFromConfig(idp) || userLookupTransform != idp.getUserLookupTransform() || !StringUtils.equals((CharSequence)idp.getCustomNameAttribute(), (CharSequence)customNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomGivenNameAttribute(), (CharSequence)customGivenNameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomSurnameAttribute(), (CharSequence)customSurnameAttribute) || !StringUtils.equals((CharSequence)idp.getCustomEmailAttribute(), (CharSequence)customEmailAttribute);
    }

    private static String getTestIdFromRequest(HttpServletRequestFacade req) {
        return (String)Option.of((Object)req).map(HttpServletRequestFacade::getPathInfo).map(pathInfo -> pathInfo.replaceAll("(.*evaluate-test/)(.+?)(/.*)", "$2")).getOrElse((Object)"");
    }

    private Response parseResponseFile(File responseFile) {
        return (Response)XmlUtils.parse((File)responseFile);
    }

    private AuthnRequest parseRequestFile(File requestFile) {
        return (AuthnRequest)XmlUtils.parse((File)requestFile);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JSONObject parseJsonProfile(File responseFile) {
        try (FileInputStream stream = new FileInputStream(responseFile);){
            JSONObject jSONObject;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
                StringBuilder jsonStringBuilder = new StringBuilder();
                while (inputStreamReader.ready()) {
                    jsonStringBuilder.append((char)inputStreamReader.read());
                }
                String jsonString = jsonStringBuilder.toString();
                jSONObject = new JSONObject(jsonString);
            }
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkLicensing(Map<String, Object> model) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicenseWrapper license = new PluginLicenseWrapper((PluginLicense)this.licenseManager.getLicense().get());
            model.put("license", license);
            model.put("licenseValid", license.isValid());
        } else {
            model.put("licenseMissing", Boolean.TRUE);
        }
    }

    private static class TestPageAuthnStateCache
    implements AuthnStateCache {
        private final Map<String, AuthnState> cache = new HashMap<String, AuthnState>();

        private TestPageAuthnStateCache() {
        }

        public void put(String authnRequestId, AuthnState state) {
            this.cache.put(authnRequestId, state);
        }

        public AuthnState remove(String authnRequestId) {
            return this.cache.remove(authnRequestId);
        }
    }
}

