/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import java.io.File;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kantega.atlaskerb.saml.CertDetails;
import org.kantega.atlaskerb.saml.CertTool;

public class CertGuiWrapper {
    Date notBefore;
    Date notAfter;
    Principal subjectDN;
    String sigAlgName;
    byte[] encoded;
    int keySize;
    String fingerPrint;
    String sha256FingerPrint;
    String filePath;

    public CertGuiWrapper(CertDetails certDetails, File signingDirectory) {
        X509Certificate cert = certDetails.getCert();
        this.notAfter = cert.getNotAfter();
        this.subjectDN = cert.getSubjectDN();
        this.notBefore = cert.getNotBefore();
        this.sigAlgName = cert.getSigAlgName();
        this.keySize = CertTool.getKeySize(cert);
        try {
            this.encoded = cert.getEncoded();
            this.fingerPrint = CertTool.fingerPrint(this.encoded);
            this.sha256FingerPrint = CertTool.sha256FingerPrint(this.encoded);
            this.filePath = String.valueOf(signingDirectory) + File.separator + certDetails.getFilename();
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Unable to encode certificate", e);
        }
    }

    public static List<CertGuiWrapper> getList(List<CertDetails> certList, File signingDirectory) {
        ArrayList<CertGuiWrapper> certs = new ArrayList<CertGuiWrapper>();
        for (CertDetails oneCert : certList) {
            certs.add(new CertGuiWrapper(oneCert, signingDirectory));
        }
        return certs;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public String getSha256FingerPrint() {
        return this.sha256FingerPrint;
    }

    public Principal getSubjectDN() {
        return this.subjectDN;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

