/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.latest.user;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.control.Option;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.apitokens.ApiTokenEntity;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.rest.resource.api.apitokens.Util;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshToken {
    private static final Logger log = LoggerFactory.getLogger(RefreshToken.class);

    public static Response run(HttpServletRequestFacade request, String body, UserProfile userProfile, ApiTokenService apiTokenService, UserManager userManager) {
        Option<String> maybeTokenValue = Util.extractApiToken(request, body);
        if (maybeTokenValue.isDefined()) {
            String tokenValue = (String)maybeTokenValue.get();
            Option<ApiTokenEntity> maybeApiTokenObject = apiTokenService.findApiToken(tokenValue);
            if (maybeApiTokenObject.isDefined()) {
                ApiTokenEntity apiTokenObject = (ApiTokenEntity)maybeApiTokenObject.get();
                Option maybeUsernameInRequest = UserManagerUtils.extractUsername((UserProfile)userProfile);
                if (!maybeUsernameInRequest.contains((Object)apiTokenObject.getUsername())) {
                    log.error("Forbidden: user " + (String)maybeUsernameInRequest.getOrElse((Object)"<unknown>") + " tried to refresh other user's API token");
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                String alias = apiTokenObject.getTokenName();
                String description = apiTokenObject.getDescription();
                long validFor = apiTokenObject.getValidFor();
                return (Response)apiTokenService.createAndPersistTokenJson(userProfile, alias, description, validFor).peek(_json -> apiTokenService.delete(apiTokenObject)).peek(_json -> log.info("Successfully refreshed API token with description " + description)).map(json -> Response.ok((Object)json.toString(4), (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).peekLeft(message -> log.error("Failed to create new API token on refresh: " + message)).getOrElse((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not create API token").build());
            }
            String username = (String)UserManagerUtils.extractUsername((UserProfile)userProfile).getOrElse((Object)"<unknown>");
            String message2 = "Could not find API token in request for user " + username;
            log.warn(message2);
            return ResponseUtils.errorWithMessageInJson(Response.Status.NOT_FOUND, message2);
        }
        log.error("Could not find API token value in request.");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }
}

