/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.cache.LastUserAgentsCache;

public class IdpConfigureUserAgentRestrictionsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final LastUserAgentsCache lastUserAgentsCache;

    @Inject
    public IdpConfigureUserAgentRestrictionsAction(RequireAdminServletDependencyBucket bucket, LastUserAgentsCache lastUserAgentsCache) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.lastUserAgentsCache = lastUserAgentsCache;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restrictionList", this.kerbConfManager.getIdpDisabledUserAgents());
        model.put("topMenu", "SAML");
        model.put("menuItem", "idp-useragentrestrict");
        model.put("lastVisitingUserAgents", this.lastUserAgentsCache.lastUserAgents());
        model.put("isCollectUserAgentsEnabled", this.kerbConfManager.isCollectUserAgentsEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/idp-useragent_restrict.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String removeUserAgent;
        String addUserAgent = req.getParameter("addUserAgent");
        if (StringUtils.isNotBlank((CharSequence)addUserAgent)) {
            addUserAgent = addUserAgent.trim();
            this.kerbConfManager.addIdpDisabledUserAgent(addUserAgent);
        }
        if (StringUtils.isNotBlank((CharSequence)(removeUserAgent = req.getParameter("removeUserAgent")))) {
            this.kerbConfManager.removeIdpDisabledUserAgent(removeUserAgent);
        }
        this.kerbConfManager.setCollectUserAgentsEnabled("on".equals(req.getParameter("collectUserAgentsEnabled")));
        resp.sendRedirect("idp-useragentrestrict");
    }
}

