/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade.data;

import com.atlassian.sal.api.message.Message;
import io.vavr.collection.List;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeResult;

public class UpgradeMessage
implements Message {
    private final KssoUpgradeManager.ResultCode resultCode;
    private final String message;
    private final List<? extends UpgradeResult> updateResults;
    private final String configPageUri;
    private final String configPageName;

    public UpgradeMessage(KssoUpgradeManager.ResultCode resultCode, String message) {
        this.resultCode = resultCode;
        this.message = String.format("[%s] %s", resultCode.name(), message);
        this.updateResults = List.empty();
        this.configPageUri = null;
        this.configPageName = null;
    }

    public UpgradeMessage(KssoUpgradeManager.ResultCode resultCode, String message, String configPageUri, String configPageTitle) {
        this.resultCode = resultCode;
        this.message = String.format("[%s] %s", resultCode.name(), message);
        this.updateResults = List.empty();
        this.configPageUri = configPageUri;
        this.configPageName = configPageTitle;
    }

    public UpgradeMessage(KssoUpgradeManager.ResultCode resultCode, String message, List<? extends UpgradeResult> updateResults) {
        this.resultCode = resultCode;
        this.message = String.format("[%s] %s", resultCode.name(), message);
        this.updateResults = updateResults;
        this.configPageUri = null;
        this.configPageName = null;
    }

    public static UpgradeMessage success(String message) {
        return new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, message);
    }

    public static UpgradeMessage failure(String message) {
        return new UpgradeMessage(KssoUpgradeManager.ResultCode.FAILURE, message);
    }

    public String toString() {
        return "UpdateMessage{resultCode=" + (Object)((Object)this.resultCode) + ", message='" + this.message + '\'' + '}';
    }

    public String getKey() {
        return this.message;
    }

    public Serializable[] getArguments() {
        return new Serializable[0];
    }

    public boolean isSuccess() {
        return this.resultCode == KssoUpgradeManager.ResultCode.SUCCESS;
    }

    public boolean isFailure() {
        return this.resultCode == KssoUpgradeManager.ResultCode.FAILURE;
    }

    public KssoUpgradeManager.ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getMessage() {
        return this.message;
    }

    public List<? extends UpgradeResult> getUpdateResults() {
        return this.updateResults;
    }

    @Nullable
    public String getConfigPageUri() {
        return this.configPageUri;
    }

    @Nullable
    public String getConfigPageName() {
        return this.configPageName;
    }
}

