/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.info;

import com.atlassian.annotations.PublicApi;
import com.kantegasso.cron.CronExpressionHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONObject;

@Path(value="server-time")
@PublicApi
public class ServerTime {
    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, @DefaultValue(value="") @QueryParam(value="cron") String cron) {
        JSONObject json = new JSONObject();
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        if (!StringUtils.equals((CharSequence)"", (CharSequence)cron) && cron != null) {
            CronExpressionHandler generator = CronExpressionHandler.parse((String)cron);
            DateTime next = new DateTime((Object)generator.next(new Date())).toDateTime(DateTimeZone.UTC);
            json.put("dateTimeUTC", (Object)next.toString());
        } else {
            json.put("dateTimeUTC", (Object)DateTime.now().toDateTime(DateTimeZone.UTC).toString());
        }
        return Response.ok((Object)json.toString()).build();
    }
}

