/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataWrapper;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OidcDataCache {
    private static final String CACHE_KEY = "oidcDataCache";
    private static final Logger log = LoggerFactory.getLogger(OidcDataCache.class);
    private final Cache<String, OidcDataWrapper> oidcDataCache;

    @Inject
    public OidcDataCache(@ComponentImport CacheManager cacheManager) {
        this.oidcDataCache = cacheManager.getCache(CACHE_KEY, null, new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterWrite(30L, TimeUnit.MINUTES).maxEntries(Integer.parseInt(System.getProperty(CACHE_KEY, "25000"))).build());
    }

    public Try<Void> put(OidcDataWrapper oidcDataWrapper) {
        return Option.of((Object)oidcDataWrapper).map(OidcDataWrapper::getOidcData).flatMap(data -> data.get("state")).toTry().flatMap(state -> Try.run(() -> this.oidcDataCache.put(state, (Object)oidcDataWrapper)).onFailure(throwable -> log.error(ErrorUtils.createErrorMessage((String)"KSSO-IKJT1K9JTJ", (String)"Encountered an error while initiating the OIDC login process: "), throwable)));
    }

    public Option<OidcDataWrapper> pop(String state) {
        return this.get(state).peek(oidcDataWrapper -> Try.run(() -> this.oidcDataCache.remove((Object)state)).onFailure(throwable -> log.error(ErrorUtils.createErrorMessage((String)"KSSO-B9G1B8I9WC", (String)"Could not remove value from cache: "), throwable)));
    }

    public Option<OidcDataWrapper> get(String state) {
        return Option.of((Object)state).filter(arg_0 -> this.oidcDataCache.containsKey(arg_0)).flatMap(state1 -> Try.of((CheckedFunction0 & Serializable)() -> (OidcDataWrapper)this.oidcDataCache.get(state1)).onFailure(throwable -> log.error(ErrorUtils.createErrorMessage((String)"KSSO-MMEVWSVUN4", (String)"We encountered an error while resuming the OIDC login process: "), throwable)).toOption());
    }
}

