/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.security.LoginDetails;
import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.security.login.HistoricalLoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.security.persistence.dao.hibernate.UserLoginInfo;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.LoginDetailsHelper;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.user.rememberme.ConfluenceRememberMeTokenDao;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.EntityException;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.StatusPreservableHeaderAwareResponse;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RemembermeUtils;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.utils.Version;
import org.kantega.atlaskerb.wrapper.user.ConfluenceUserWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfluenceHostApp
extends DefaultHostApp {
    private final Method onSuccessfulLoginAttemptMethod;
    private final LoginManager loginManager;
    private ConfluenceAccessManager confluenceAccessManager;
    private UserDetailsManager userDetailsManager;
    private com.atlassian.user.UserManager userManager;
    private PermissionManager permissionManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Class<?> confluenceLoginManagerClass = null;
    private Method getLoginInfoMethod;
    private Method getLastSuccessfulLoginDateMethod;
    private final AccessModeService accessModeService;
    Class<?> hibernateUserLoginInfoDaoClass = null;
    Object hibernateUserLoginInfoDao;
    private Method findOrCreateUserLoginInfoForUser;
    private Method saveOrUpdate;
    UserAccessor userAccessor;

    public ConfluenceHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, PluginAccessor pluginAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, pluginAccessor, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        this.hasRestApi = true;
        this.accessModeService = this.tryToGetConfluenceAccessModeService();
        Method onSuccessfulLoginAttemptMethod = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader().getParent();
            if (classLoader != null) {
                this.confluenceLoginManagerClass = LoginManager.class;
                onSuccessfulLoginAttemptMethod = this.confluenceLoginManagerClass.getMethod("onSuccessfulLoginAttempt", String.class, HttpServletRequestFacade.getHttpServletRequestClass());
            }
        }
        catch (Exception e) {
            this.log.warn("Could not load Confluence LoginManager. Login count / time update disabled", (Throwable)e);
        }
        this.onSuccessfulLoginAttemptMethod = onSuccessfulLoginAttemptMethod;
        this.loginManager = (LoginManager)ComponentLocator.getComponent(LoginManager.class);
        try {
            this.getLoginInfoMethod = this.loginManager.getClass().getMethod("getLoginInfo", String.class);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Couldn't find method getLoginInfo for class loginManager");
        }
        try {
            this.getLastSuccessfulLoginDateMethod = HistoricalLoginInfo.class.getMethod("getLastSuccessfulLoginDate", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.log.error("Couldn't find method getLastSuccessfulLoginDateMethod for class HistoricalLoginInfo");
        }
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/index.action*");
        this.preemptivePathMappings.add("/dashboard*");
        this.preemptivePathMappings.add("/display/*");
        this.preemptivePathMappings.add("/dosearchsite.action*");
        this.preemptivePathMappings.add("/labels/*");
        this.preemptivePathMappings.add("/mail/archive/viewmailarchive.action*");
        this.preemptivePathMappings.add("/pages/*");
        this.preemptivePathMappings.add("/spaces/*");
        this.preemptivePathMappings.add("/spacedirectory/*");
        this.preemptivePathMappings.add("/users/*");
        this.preemptivePathMappings.add("/viewpage.action*");
        this.preemptivePathMappings.add("/plugins/inlinetasks/mytasks.action*");
        this.preemptivePathMappings.add("/plugins/servlet/sitemapservlet*");
        this.confluenceAccessManager = this.tryToGetConfluenceAccessManager();
        this.permissionManager = (PermissionManager)ComponentLocator.getComponent(PermissionManager.class);
        this.userDetailsManager = (UserDetailsManager)ComponentLocator.getComponent(UserDetailsManager.class);
        this.userManager = (com.atlassian.user.UserManager)ComponentLocator.getComponent(com.atlassian.user.UserManager.class);
        this.userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        this.hibernateUserLoginInfoDao = this.tryToGetConfluenceDaoHibernate();
        try {
            this.hibernateUserLoginInfoDaoClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.security.persistence.dao.hibernate.HibernateUserLoginInfoDao");
            this.findOrCreateUserLoginInfoForUser = this.hibernateUserLoginInfoDaoClass.getMethod("findOrCreateUserLoginInfoForUser", ConfluenceUser.class);
            this.saveOrUpdate = this.hibernateUserLoginInfoDaoClass.getMethod("saveOrUpdate", UserLoginInfo.class);
        }
        catch (Exception e) {
            this.log.error("Failed to obtain HibernateUserLoginInfoDao");
        }
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade resp) {
        String remoteIP = req.getRemoteAddr();
        String remoteHost = req.getRemoteHost();
        Boolean ssoLoginObj = (Boolean)req.getSession().getAttribute("com.atlassian.plugins.authentication.userLoggedInWithSso");
        LoginDetails.CaptchaState captchaState = req.getParameterValues("captchaId") != null ? LoginDetails.CaptchaState.PASSED : LoginDetails.CaptchaState.NOT_SHOWN;
        LoginDetails loginDetails = new LoginDetails(LoginDetailsHelper.isDirectLogin((HttpServletRequest)req) ? LoginDetails.LoginSource.DIRECT : LoginDetails.LoginSource.SSO, captchaState);
        this.log.debug(String.format("Confluence LoginEvent: %s, isSso: %s", user.getName(), ssoLoginObj));
        this.eventPublisher.publish((Object)new LoginEvent((Object)this, user.getName(), req.getSessionKsso().getId(), remoteHost, remoteIP, loginDetails));
        super.publishUserAuthenticatedEvent(user, req, resp);
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequestFacade req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return super.isForceLoginRequestMapped(req) || r.equals("/") || r.startsWith("/index.action") || r.startsWith("/dashboard") || r.startsWith("/display/") || r.startsWith("/labels/") || r.startsWith("/mail/archive/viewmailarchive.action") || r.startsWith("/pages/") || r.startsWith("/spaces/") || r.startsWith("/spacedirectory/") || r.startsWith("/users/") || r.startsWith("/viewpage.action") || r.startsWith("/plugins/inlinetasks/mytasks.action") || r.startsWith("/plugins/servlet/sitemapservlet") || r.startsWith("/dosearchsite.action");
    }

    @Override
    public Try<Integer> getFailedLoginAttempts(Principal principal) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.userAccessor.getUserByName(principal.getName())).mapTry((CheckedFunction1 & Serializable)userByName -> ((UserLoginInfo)this.findOrCreateUserLoginInfoForUser.invoke(userByName, new Object[0])).getCurrentFailedLoginCount()).onFailure(e -> this.log.warn("An exception occurred while retrieving the currentFailedLoginCount for user " + UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal), e));
    }

    @Override
    public Try<Void> setFailedLoginAttempts(Principal principal, int count) {
        return Try.run(() -> this.transactionTemplate.execute(() -> {
            ConfluenceUser user = this.userAccessor.getUserByName(principal.getName());
            UserLoginInfo orCreateUserLoginInfoForUser = null;
            try {
                orCreateUserLoginInfoForUser = (UserLoginInfo)this.findOrCreateUserLoginInfoForUser.invoke((Object)user, new Object[0]);
                orCreateUserLoginInfoForUser.setCurrentFailedLoginCount(count);
                this.saveOrUpdate.invoke((Object)orCreateUserLoginInfoForUser, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return null;
        })).onFailure(e -> this.log.warn("An exception occurred while setting the currentFailedLoginCount for user " + UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal), e));
    }

    @Override
    public boolean shouldEnableHardRedirect(HttpServletRequestFacade req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (requestPath.startsWith("/plugins/servlet/remotepageview")) {
            return true;
        }
        return super.shouldEnableHardRedirect(req);
    }

    private ConfluenceAccessManager tryToGetConfluenceAccessManager() {
        try {
            Class<?> camClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.security.access.ConfluenceAccessManager");
            return (ConfluenceAccessManager)ComponentLocator.getComponent(camClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Object tryToGetConfluenceDaoHibernate() {
        try {
            Class<?> hibernateUserLoginInfoClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.security.persistence.dao.hibernate.HibernateUserLoginInfoDao");
            return ComponentLocator.getComponent(hibernateUserLoginInfoClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private AccessModeService tryToGetConfluenceAccessModeService() {
        try {
            Class<?> accessModeServiceClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.api.service.accessmode.AccessModeService");
            return (AccessModeService)ComponentLocator.getComponent(accessModeServiceClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"confluence", (CharSequence)product);
    }

    @Override
    public boolean isRequestMapped(HttpServletRequestFacade req, String r) {
        return this.isPageWithLoginForm(req) || this.isWebdavRequest(req) && this.kerbConfManager.isKeytabConfigured() && this.kerbConfManager.isKerberosEnabled() && this.kerbConfManager.isWebdavEnabled() || this.kerbConfManager.isKerberosKnowledgeBaseEnabled() && r.startsWith("/plugins/servlet/remotepageview");
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequestFacade req) {
        String requestUri = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req);
        String qs = req.getQueryString();
        return (this.isMainLoginPage(req) || requestUri.startsWith("/m/login/login.action")) && this.avoidSSOForUserAvatar(qs);
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequestFacade request) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request);
        return internalPath.startsWith("/login.action");
    }

    private boolean avoidSSOForUserAvatar(String qs) {
        return this.kerbConfManager.isSSOEnabledForUserAvatar() || !this.isUserAvatar(qs);
    }

    private boolean isUserAvatar(String qs) {
        return StringUtils.isNotBlank((CharSequence)qs) && qs.matches(".*%2Fdownload%2Fattachments%2F.*%2Fuser-avatar.*");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        if (req == null) {
            return super.shouldLoginManually(null, res);
        }
        Boolean logout = (Boolean)Option.of((Object)req.getParameter("logout")).map(Boolean::parseBoolean).getOrElse((Object)false);
        Boolean webdavRequestButDisabled = this.isWebdavRequest(req) && !this.kerbConfManager.isWebdavEnabled();
        return logout != false || webdavRequestButDisabled != false;
    }

    private boolean isWebdavRequest(HttpServletRequestFacade req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        return requestPath.startsWith("/plugins/servlet/confluence");
    }

    @Override
    public boolean isLoginRequest(HttpServletRequestFacade req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return ("/dologin.action".equals(r) || this.isDefaultRestEndpointForAuthentication(req)) && "POST".equals(req.getMethod());
    }

    @Override
    public void dispatchToLogin(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        String qs = Optional.ofNullable(req.getQueryString()).orElse("");
        this.log.debug("Dispatching to login");
        if (requestPath.startsWith("/plugins/servlet/remotepageview")) {
            chain.doFilterKsso(req, resp);
        } else if (this.isWebdavRequest(req)) {
            this.log.debug("Doing nothing on Webdav request");
        } else if (this.isRestApi(requestPath)) {
            chain.doFilterKsso(req, (HttpServletResponseFacade)new StatusPreservableHeaderAwareResponse((HttpServletResponse)resp));
        } else if (requestPath.startsWith("/login.action") || requestPath.startsWith("/m/login/login.action")) {
            this.log.debug("Avoid returning to login page after login");
            if (qs.contains("logout%3FSAMLResponse")) {
                resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=");
            } else {
                chain.doFilterKsso(req, resp);
            }
        } else if (ConfluenceHostApp.shouldDispatchToLoginPage(this.kerbConfManager)) {
            this.log.debug("Dispatching to login page");
            String returnUrl = requestPath;
            returnUrl = returnUrl + (StringUtils.isNotBlank((CharSequence)qs) ? "?" + qs : "");
            if (SsoScriptLoginHookUrlReadingCondition.shouldAbortSso(req)) {
                resp.sendRedirect(req.getContextPath() + "/login.action?" + qs + "&os_destination=" + HttpUrlUtils.urlEncode((String)returnUrl));
            } else {
                resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=" + HttpUrlUtils.urlEncode((String)returnUrl));
            }
        } else {
            chain.doFilterKsso(req, resp);
        }
    }

    @Override
    public Option<String> getAnonymousBrowsingSettingsUrl() {
        return Option.of((Object)"/admin/permissions/globalpermissions.action");
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal user) {
        this.seraphLikeInvalidateSession(req);
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)ConfluenceUserPrincipal.of((Principal)user));
        req.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        this.recordSuccessfulLoginEventWithLoginManager(user, req);
        return user;
    }

    private void recordSuccessfulLoginEventWithLoginManager(Principal user, HttpServletRequestFacade req) {
        try {
            this.loginManager.onSuccessfulLoginAttempt(user.getName(), (HttpServletRequest)req);
        }
        catch (Exception e) {
            this.log.warn("Failing registering successful login in Confluence", (Throwable)e);
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade res, FilterChainFacade chain) throws IOException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (this.isWebdavRequest(req) || this.isRestApi(requestPath)) {
            UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
            ConfluenceUser confluenceUser = accessor.getUserByName(user.getName());
            AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
            chain.doFilterKsso(req, res);
        } else {
            super.postSuccessfulLoginWithKerberosAction(user, req, res, chain);
        }
    }

    @Override
    public boolean isPublicAccessEnabled() {
        if (this.confluenceAccessManager == null) {
            this.log.warn("No ConfluenceAccessManager available, unable to determine public access");
            return super.isPublicAccessEnabled();
        }
        AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(null);
        return userAccessStatus.hasAnonymousAccess() || userAccessStatus.hasUnlicensedAuthenticatedAccess();
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.confluence.user.ConfluenceAuthenticator";
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequestFacade request) {
        UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        ConfluenceUser confluenceUser = accessor.getUserByName(user.getName());
        if (this.confluenceAccessManager != null) {
            AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus((com.atlassian.user.User)confluenceUser);
            return userAccessStatus.canUseConfluence();
        }
        return false;
    }

    @Override
    public boolean isLicensed(Principal user) {
        UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        ConfluenceUser confluenceUser = accessor.getUserByName(user.getName());
        if (this.confluenceAccessManager != null) {
            AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus((com.atlassian.user.User)confluenceUser);
            return userAccessStatus.canUseConfluence();
        }
        return false;
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/users/browseusers.action";
    }

    @Override
    public boolean supportsRemoveAllRememberMeTokens() {
        return true;
    }

    @Override
    public void removeAllRememberMeTokens() {
        ConfluenceRememberMeTokenDao component = (ConfluenceRememberMeTokenDao)ComponentLocator.getComponent(ConfluenceRememberMeTokenDao.class);
        component.removeAll();
    }

    @Override
    public void addUser(Directory directory, String username, String fullName, String email, Set<String> groups, boolean isActive) throws UserAlreadyExistsException {
        super.addUser(directory, username, fullName, email, groups, isActive);
        ConfluenceUserWrapper confluenceUserWrapper = new ConfluenceUserWrapper(username, fullName, email, isActive);
        UserCreateEvent event = new UserCreateEvent((Object)this, confluenceUserWrapper.getUser());
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public UserWithAttributes getUserForCleanup(User user) {
        return UserTemplateWithAttributes.toUserWithNoAttributes((User)user);
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        if (user == null || user.getName() == null) {
            this.log.error("User or username is null");
            return null;
        }
        if (this.getLoginInfoMethod == null) {
            this.log.warn("getLoginInfoMethod is null, returning lastAuthenticated value from cwd_user_attribute");
            return this.getLastAuthenticatedFromUserAttributes(user.getDirectoryId(), user.getName());
        }
        if (this.loginManager == null) {
            this.log.warn("loginManager is null, returning lastAuthenticated value from cwd_user_attribute");
            return this.getLastAuthenticatedFromUserAttributes(user.getDirectoryId(), user.getName());
        }
        try {
            Object loginInfo = this.getLoginInfoMethod.invoke((Object)this.loginManager, user.getName());
            if (loginInfo == null) {
                this.log.warn("loginInfo is null for user {}, returning lastAuthenticated value from cwd_user_attribute", (Object)user.getName());
                return this.getLastAuthenticatedFromUserAttributes(user.getDirectoryId(), user.getName());
            }
            Date lastLogin = null;
            if (this.getLastSuccessfulLoginDateMethod != null) {
                lastLogin = (Date)this.getLastSuccessfulLoginDateMethod.invoke(loginInfo, new Object[0]);
            } else {
                Method getLastSuccessfulLoginDate = loginInfo.getClass().getMethod("getLastSuccessfulLoginDate", new Class[0]);
                getLastSuccessfulLoginDate.setAccessible(true);
                lastLogin = (Date)getLastSuccessfulLoginDate.invoke(loginInfo, new Object[0]);
            }
            this.log.debug("getLastSuccessfulLoginDate for user {} was {}", (Object)user.getName(), (Object)lastLogin);
            return lastLogin != null ? String.valueOf(lastLogin.getTime()) : this.getLastAuthenticatedFromUserAttributes(user.getDirectoryId(), user.getName());
        }
        catch (Exception e) {
            this.log.warn("Problems calling getLastSuccessfulLoginDate, returning lastAuthenticated value from cwd_user_attribute", (Throwable)e);
            return this.getLastAuthenticatedFromUserAttributes(user.getDirectoryId(), user.getName());
        }
    }

    private String getLastAuthenticatedFromUserAttributes(long directoryId, String username) {
        try {
            com.atlassian.crowd.model.user.UserWithAttributes userWithAttributes = this.getDirectoryManager().findUserWithAttributesByName(directoryId, username);
            return userWithAttributes.getValue(this.getLastLoginParameter());
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            this.log.warn("The user " + username + " was not found by DirectoryManager in directory " + directoryId + ": " + e.getMessage());
            this.log.debug("Returning null for lastAuthenticated for user " + username + " in directory " + directoryId);
            return null;
        }
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticated";
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("confluence-administrators"))) {
            return "confluence-administrators";
        }
        return null;
    }

    @Override
    public String getLoginPage() {
        return "/login.action";
    }

    @Override
    public String getMainLogoutPage() {
        return "/login.action?logout=true";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5502;
    }

    @Override
    public void setRememberMeCookie(HttpServletRequestFacade request, HttpServletResponseFacade response, String username) {
        RemembermeUtils.setRememberMeCookie(request, response, username);
    }

    @Override
    public List<String> getUserProfileKeys() {
        return List.ofAll((Iterable)this.userDetailsManager.getProfileGroups()).map(arg_0 -> ((UserDetailsManager)this.userDetailsManager).getProfileKeys(arg_0)).flatMap(List::ofAll);
    }

    @Override
    public void setUserProfileValue(String username, String key, String value) {
        try {
            com.atlassian.user.User user = this.userManager.getUser(username);
            this.userDetailsManager.setStringProperty(user, key, value);
            try {
                Method method = com.atlassian.user.UserManager.class.getMethod("saveUser", com.atlassian.user.User.class);
                method.invoke((Object)this.userManager, user);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception e) {
            this.log.warn("Failed to set user profile value for user: " + username, (Throwable)e);
        }
    }

    @Override
    public String getUserProfileValue(String username, String key) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> username).mapTry(arg_0 -> ((com.atlassian.user.UserManager)this.userManager).getUser(arg_0)).mapTry((CheckedFunction1 & Serializable)user -> this.userDetailsManager.getStringProperty(user, key)).getOrElse((Object)"");
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequestFacade request) {
        return super.isRestPathInternalAtlassianFunctionality(request) || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/api/content") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/prototype/1/search.json") || StringUtils.startsWith((CharSequence)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request), (CharSequence)"/rest/mywork");
    }

    @Override
    public boolean isMsTeamsSecurityHeadersEnabled() {
        return this.kerbConfManager.isMsTeamsSecurityHeadersEnabled();
    }

    @Override
    public Map<String, String> mapNameToExternalId(java.util.List<User> userBatch, Map<String, String> userData) {
        if (userBatch.size() == 0) {
            return userData;
        }
        if (!userBatch.get(0).getClass().equals(InternalUser.class)) {
            userBatch.forEach(user -> userData.put(user.getName(), ((TimestampedUser)user).getExternalId()));
        } else {
            userBatch.forEach(user -> userData.put(user.getName(), ((InternalUser)user).getExternalId()));
        }
        return userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUsersProfilePicture(java.util.List<User> users) {
        HashMap<String, String> usernameAvatarUriMap = new HashMap<String, String>();
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        for (User user : users) {
            String uri = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/images/icons/profilepics/default.svg";
            try {
                com.atlassian.user.User atlassianUser = this.userManager.getUser(user.getName());
                uri = userAccessor.getUserProfilePicture(atlassianUser).getUriReference();
                usernameAvatarUriMap.put(user.getName(), uri);
            }
            catch (EntityException entityException) {}
            continue;
            finally {
                usernameAvatarUriMap.put(user.getName(), uri);
            }
        }
        return usernameAvatarUriMap;
    }

    @Override
    public boolean isProductInReadOnlyMode() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    @Override
    public boolean isEditAccountGetRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/users/editmyprofile.action") && "GET".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isAdminEditAccountGetRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/admin/users/edituser.action") && "GET".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isEditAccountPostRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/users/doeditmyprofile.action") && "POST".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isAdminEditAccountPostRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/admin/users/doedituser.action") && "POST".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public String getEditAccountName(HttpServletRequestFacade req) {
        return req.getParameter("fullName");
    }

    @Override
    public String getEditAccountEmail(HttpServletRequestFacade req) {
        return req.getParameter("email");
    }

    @Override
    public UserProfile getEditAccountUser(UserManager userManager, HttpServletRequestFacade req) {
        String userKey = req.getParameter("userKey");
        String username = req.getParameter("username");
        return userKey != null ? userManager.getUserProfile(new UserKey(userKey)) : (username != null ? userManager.getUserProfile(username) : null);
    }

    @Override
    public boolean isLegacyLoginPageDefaultOnCurrentApplicationVersion() {
        Version applicationVersion = Version.of((String)this.applicationProperties.getVersion());
        return applicationVersion.isLowerThan(Version.of((String)"9.1"));
    }

    @Override
    public String getForgotPasswordUrl() {
        return "/forgotuserpassword.action";
    }

    @Override
    public String getDefaultLicenseGroup() {
        return "confluence-users";
    }
}

