/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.cleanup;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kantegasso.cron.CronExpressionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kantega.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectReader;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.cleanup.CleanupUtilsShared;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupLogAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupRule;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.DryRunAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserSummary;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupAction;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupResultType;
import org.kantega.atlaskerb.security.SanitizedLogStatement;
import org.kantega.atlaskerb.utils.CleanupUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactiveUserCleaner {
    private static final Logger log = LoggerFactory.getLogger(InactiveUserCleaner.class);
    private static final int MAXIMUM_USERS_SENT_TO_GUI = 100000;
    final JsonWrapper jsonWrapper;
    final KerbConfManager kerbConfManager;
    final CrowdService crowdService;
    final CrowdDirectoryService crowdDirectoryService;
    final HostApp hostApp;
    private final AtomicReference<CleanupState> state;
    private final AtomicReference<String> lastUserCleanupRunId;
    private final AtomicReference<String> lastJsmCleanupRunId;
    private final ExecutorService workers;

    public ExecutorService getWorkers() {
        return this.workers;
    }

    public InactiveUserCleaner(HostApp hostApp, KerbConfManager kerbConfManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, JsonWrapper jsonWrapper) {
        this.hostApp = hostApp;
        this.jsonWrapper = jsonWrapper;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.kerbConfManager = kerbConfManager;
        this.state = new AtomicReference<CleanupState>(new CleanupState(CleanupStatus.NOT_RUN, CleanupStatus.NOT_RUN));
        this.lastUserCleanupRunId = new AtomicReference<String>("");
        this.lastJsmCleanupRunId = new AtomicReference<String>("");
        this.workers = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("User-Cleanup-%d").build());
    }

    public CleanupStatus getUserCleanupExecuteStatus() {
        return this.state.get().getStatus(CleanupMode.USERS);
    }

    public CleanupStatus getJsmCleanupExecuteStatus() {
        return this.state.get().getStatus(CleanupMode.JSM);
    }

    public void setUserCleanupExecuteStatus(CleanupStatus status) {
        if (!this.state.get().isCurrent(status, CleanupMode.USERS)) {
            this.state.compareAndSet(this.state.get(), new CleanupState(this.state.get().jsmStatus, status));
        }
    }

    public void setJsmCleanupExecuteStatus(CleanupStatus status) {
        if (!this.state.get().isCurrent(status, CleanupMode.JSM)) {
            this.state.compareAndSet(this.state.get(), new CleanupState(status, this.state.get().userStatus));
        }
    }

    public String getUserCleanupLastRunId() {
        return this.lastUserCleanupRunId.get();
    }

    public String getJsmCleanupLastRunId() {
        return this.lastJsmCleanupRunId.get();
    }

    public void setUserCleanupLastRunId(String status) {
        this.lastUserCleanupRunId.set(status);
    }

    public void setJsmCleanupLastRunId(String status) {
        this.lastJsmCleanupRunId.set(status);
    }

    private CleanupRule getCleanupRule(CleanupMode cleanupMode) throws ConfigurationException, IOException {
        ObjectReader objectReader = this.jsonWrapper.objectReader();
        CleanupRule cleanupRule = (CleanupRule)objectReader.readValue(this.kerbConfManager.getCleanupRuleJSONString(cleanupMode), CleanupRule.class);
        if (cleanupRule == null) {
            log.warn("User cleanup: Could not find CleanupRule. Skipping user cleanup");
            throw new ConfigurationException("Could not find CleanupRule. Skipping user cleanup");
        }
        return cleanupRule;
    }

    private DateTime getInactivityCutoffTimestamp(CleanupRule cleanupRule, DryRunAttributes dryRunAttributes, DateTime runTimestamp) throws ConfigurationException {
        DateTime inactivityCutoffTimestamp;
        int daysInactiveThreshold = cleanupRule.getDaysInactiveThreshold();
        if (daysInactiveThreshold < 1) {
            log.warn("User cleanup: Missing daysInactiveThreshold or daysInactiveThreshold less than 1");
            throw new ConfigurationException("Missing daysInactiveThreshold");
        }
        if (dryRunAttributes != null && dryRunAttributes.isDryRun() && dryRunAttributes.isSimulateCronDate()) {
            if (cleanupRule.getCronAttributes() != null && cleanupRule.getCronAttributes().getCronSpringSchedule() != null) {
                CronExpressionHandler generator = new CronExpressionHandler(cleanupRule.getCronAttributes().getCronSpringSchedule());
                Date nextExecutionDate = generator.next(new Date());
                inactivityCutoffTimestamp = new DateTime((Object)nextExecutionDate);
            } else {
                inactivityCutoffTimestamp = runTimestamp;
            }
        } else {
            inactivityCutoffTimestamp = runTimestamp;
        }
        return inactivityCutoffTimestamp;
    }

    private SearchRestriction getSearchRestriction(boolean isJsmCleanup, DateTime expiryDate, boolean traceSearch) {
        PropertyRestriction activePartialSearchRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)Boolean.TRUE);
        PropertyRestriction createdDateOlderThanThresholdRestriction = Restriction.on((Property)UserTermKeys.CREATED_DATE).lessThan((Object)expiryDate.toDate());
        BooleanRestrictionImpl lastLoginRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{Restriction.on((Property)new PropertyImpl(this.hostApp.getLastLoginParameter(), String.class)).isNull(), Restriction.on((Property)new PropertyImpl(this.hostApp.getLastLoginParameter(), String.class)).lessThan((Object)String.format("%013d", expiryDate.getMillis()))});
        if (traceSearch) {
            return NullRestrictionImpl.INSTANCE;
        }
        if (isJsmCleanup) {
            return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction});
        }
        return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{activePartialSearchRestriction, createdDateOlderThanThresholdRestriction, lastLoginRestriction});
    }

    private void controlCleanupConfiguration(CleanupRule cleanupRule, DryRunAttributes dryRunAttributes, boolean isRemoveFromGroupAction) throws ConfigurationException {
        String groupToRemoveConfig = cleanupRule.getGroupToRemove();
        if (isRemoveFromGroupAction && (groupToRemoveConfig == null || groupToRemoveConfig.length() == 0)) {
            log.warn("User cleanup: CleanupRule was not configured. Missing groupToRemove value. Skipping user cleanup");
            throw new ConfigurationException("CleanupRule was not configured. Missing groupToRemove value.");
        }
        log.info("{}User cleanup: Starting user cleanup. {} users not logged in for past {} days", new Object[]{dryRunAttributes != null && dryRunAttributes.isDryRun() ? "Test run: " : "Real run: ", isRemoveFromGroupAction ? "Removing " + groupToRemoveConfig + " from" : "Deactivating", cleanupRule.getDaysInactiveThreshold()});
    }

    private boolean getIsRemoveFromGroupAction(DryRunAttributes dryRunAttributes, CleanupRule cleanupRule) {
        return (dryRunAttributes == null || !dryRunAttributes.isJsmCleanup()) && cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP;
    }

    private Iterable<User> getUsersWithSearchRestriction(boolean isRemoveFromGroupAction, Group groupToRemoveGroup, SearchRestriction searchRestriction) {
        Object query = isRemoveFromGroupAction && groupToRemoveGroup != null ? QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).childrenOf(EntityDescriptor.group()).withName(groupToRemoveGroup.getName()).returningAtMost(-1) : QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with(searchRestriction).returningAtMost(-1);
        return this.crowdService.search((Query)query);
    }

    private List<String> getDirectoryExclusionList(CleanupRule cleanupRule) {
        return cleanupRule.getDirectoriesWhitelist() != null ? Arrays.stream(cleanupRule.getDirectoriesWhitelist()).filter(StringUtils::isNotBlank).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Long> getCleanableDirectoryIds(CleanupRule cleanupRule, List<String> directoryExclusionList) {
        Set<Directory> writableUserDirectories = this.hostApp.getWritableUserDirectories();
        Set<Directory> cleanableDirectories = cleanupRule.getDirectoriesWhitelist() == null ? writableUserDirectories : writableUserDirectories.stream().filter(directory -> directoryExclusionList.stream().noneMatch(directoryName -> directoryName.equals(directory.getName()))).collect(Collectors.toSet());
        return cleanableDirectories.stream().map(Directory::getId).collect(Collectors.toList());
    }

    private Set<String> getWhitelistedUserNames(CleanupRule cleanupRule) {
        String[] groupsWhitelistConfig = cleanupRule.getGroupsWhitelist();
        List groupWhitelist = groupsWhitelistConfig == null ? Collections.emptyList() : Arrays.stream(groupsWhitelistConfig).filter(StringUtils::isNotBlank).map(this.hostApp::getGroup).collect(Collectors.toList());
        Iterable usernamesInWhitelistedGroups = this.crowdService.search((Query)QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames((String[])groupWhitelist.stream().filter(Objects::nonNull).map(Group::getName).toArray(String[]::new)).returningAtMost(-1));
        return StreamSupport.stream(usernamesInWhitelistedGroups.spliterator(), false).collect(Collectors.toSet());
    }

    private Set<Long> getExcludedDirectoryIds(List<Directory> allDirectories, List<String> directoryExclusionList) {
        return allDirectories.stream().filter(directory -> directoryExclusionList.contains(directory.getName())).map(Directory::getId).collect(Collectors.toSet());
    }

    private boolean isUserEligibleForCleanup(String currentUserName, User user, CleanupRule cleanupRule, boolean isNotSimulatedDateOrNotDryRun, boolean isRemoveFromGroupAction, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds, Set<String> whitelistedUserNames) {
        boolean isCurrentLoggedInUser = currentUserName != null && isNotSimulatedDateOrNotDryRun && currentUserName.equals(user.getName());
        boolean isCurrentCleanupRuleOwner = cleanupRule.getChangedByUsername() != null && cleanupRule.getChangedByUsername().equals(user.getName());
        boolean isUserWhitelisted = whitelistedUserNames.contains(user.getName());
        if (isCurrentCleanupRuleOwner || isCurrentLoggedInUser || !user.isActive() || isUserWhitelisted) {
            return false;
        }
        return isRemoveFromGroupAction && !excludedDirectoryIds.contains(user.getDirectoryId()) || cleanableDirectoryIds.contains(user.getDirectoryId());
    }

    private boolean isUserEligibleForJSMCleanup(long userId, List<Long> cleanableDirectoryIds, Set<Long> excludedDirectoryIds) {
        return !excludedDirectoryIds.contains(userId) || cleanableDirectoryIds.contains(userId);
    }

    private Directory getUserDirectory(List<Directory> allDirectories, User user) {
        return allDirectories.stream().filter(directory -> directory.getId().longValue() == user.getDirectoryId()).findFirst().get();
    }

    private ImmutablePair<DateTime, Boolean> getLoginOrCreationDateForUser(User user) {
        UserWithAttributes userWithAttributes = this.hostApp.getUserForCleanup(user);
        String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(userWithAttributes);
        if (NumberUtils.isCreatable((String)lastLoginMillis)) {
            return new ImmutablePair((Object)new DateTime(Long.parseLong(lastLoginMillis)), (Object)true);
        }
        if (lastLoginMillis == null) {
            return new ImmutablePair((Object)new DateTime((Object)((TimestampedUser)user).getCreatedDate()), (Object)false);
        }
        return null;
    }

    private void maybeCleanupUser(boolean hasLoggedIn, String dryRunString, User user, DateTime lastLoginOrCreationDate, DateTime expiryDate, CleanupRule cleanupRule, DryRunAttributes dryRunAttributes, Directory userDirectory, List<Long> cleanableDirectoryIds, ArrayList<UserSummary> affectedUsersList) {
        if (hasLoggedIn) {
            log.debug("{}Checking if user {} should be cleaned. Lastlogin: {}", new Object[]{dryRunString, user.getName(), lastLoginOrCreationDate});
        } else {
            log.debug("{}Checking if user {} should be cleaned. created: {}", new Object[]{dryRunString, user.getName(), lastLoginOrCreationDate});
        }
        if (!this.shouldCleanupUser(lastLoginOrCreationDate, expiryDate)) {
            return;
        }
        if (hasLoggedIn) {
            log.info("{}User cleanup: Cleaning user {}. Not logged in for more than {} days", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
        } else {
            log.info("{}User cleanup: Cleaning user {}. Created more than {} days ago but never logged in.", new Object[]{dryRunString, user.getName(), cleanupRule.getDaysInactiveThreshold()});
        }
        this.optionallyCleanupUser(dryRunString, dryRunAttributes, cleanupRule, affectedUsersList, user, userDirectory, cleanableDirectoryIds.contains(user.getDirectoryId()));
    }

    private List<ApplicationUser> getApplicationUsers(Iterable<User> users, CleanupRule cleanupRule) {
        Set<String> whitelistedUserNames = this.getWhitelistedUserNames(cleanupRule);
        ArrayList<ApplicationUser> userList = new ArrayList<ApplicationUser>();
        users.forEach(user -> {
            if (!whitelistedUserNames.contains(user.getName())) {
                userList.add(((JiraHostApp)this.hostApp).getApplicationUser(user.getName()));
            }
        });
        return userList;
    }

    public UserCleanupResult doUserCleanup(String currentUserName, DryRunAttributes dryRunAttributes, CleanupRule cleanupRule, SearchRestriction searchRestriction, DateTime inactivityCutoffTimestamp, DateTime expiryDate, String dryRunString, String runId, boolean traceLogRun) throws ConfigurationException {
        boolean isRemoveFromGroupAction = this.getIsRemoveFromGroupAction(dryRunAttributes, cleanupRule);
        this.controlCleanupConfiguration(cleanupRule, dryRunAttributes, isRemoveFromGroupAction);
        Group groupToRemoveGroup = isRemoveFromGroupAction ? this.hostApp.getGroup(cleanupRule.getGroupToRemove()) : null;
        Iterable<User> users = this.getUsersWithSearchRestriction(isRemoveFromGroupAction, groupToRemoveGroup, searchRestriction);
        if (traceLogRun) {
            this.doTraceLogRun(users);
            return null;
        }
        List<String> directoryExclusionList = this.getDirectoryExclusionList(cleanupRule);
        List<Long> cleanableDirectoryIds = this.getCleanableDirectoryIds(cleanupRule, directoryExclusionList);
        Set<String> whitelistedUserNames = this.getWhitelistedUserNames(cleanupRule);
        int countAnalysedUsers = 0;
        log.debug("{} Starting to analyse how many users need to be cleaned.", (Object)dryRunString);
        boolean isNotSimulatedDateOrNotDryRun = dryRunAttributes == null || !dryRunAttributes.isSimulateCronDate();
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        Set<Long> excludedDirectoryIds = this.getExcludedDirectoryIds(allDirectories, directoryExclusionList);
        Iterator<User> usersIterator = users.iterator();
        ArrayList<UserSummary> affectedUsersList = new ArrayList<UserSummary>();
        try {
            while (usersIterator.hasNext()) {
                User user = usersIterator.next();
                if (this.hostApp.getUserCleanupExecuteStatus() == CleanupStatus.NOT_RUN) {
                    throw new BreakException();
                }
                if (this.isUserEligibleForCleanup(currentUserName, user, cleanupRule, isNotSimulatedDateOrNotDryRun, isRemoveFromGroupAction, cleanableDirectoryIds, excludedDirectoryIds, whitelistedUserNames)) {
                    Directory userDirectory = this.getUserDirectory(allDirectories, user);
                    ImmutablePair<DateTime, Boolean> loginOrCreationDate = this.getLoginOrCreationDateForUser(user);
                    if (loginOrCreationDate != null) {
                        this.maybeCleanupUser((Boolean)loginOrCreationDate.getRight(), dryRunString, user, (DateTime)loginOrCreationDate.getLeft(), expiryDate, cleanupRule, dryRunAttributes, userDirectory, cleanableDirectoryIds, affectedUsersList);
                    }
                }
                ++countAnalysedUsers;
            }
            log.debug("{}Analysed {} users where {} were relevant for cleaning. ", new Object[]{dryRunString, countAnalysedUsers, affectedUsersList.size()});
        }
        catch (BreakException e) {
            log.warn("User cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users were affected before cancel. You can find complete list of affected users in the user cleanup log directory");
        }
        return this.createAndSaveUserCleanupResult(dryRunAttributes, affectedUsersList, inactivityCutoffTimestamp, runId, cleanupRule, CleanupMode.USERS);
    }

    private void doTraceLogRun(Iterable<User> users) {
        log.trace("User cleanup: Users found in the relevant search (both active, inactive). Not all these are not due for cleaning, typically because they are in read-only directories or inactive:");
        int count = 0;
        for (User user : users) {
            UserWithAttributes userWithAttributes = this.hostApp.getUserForCleanup(user);
            String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(userWithAttributes);
            DateTime lastLoginDate = null;
            if (NumberUtils.isCreatable((String)lastLoginMillis)) {
                lastLoginDate = new DateTime(Long.parseLong(lastLoginMillis));
            }
            log.trace("Username: {} isActive: {} lastAuthenticated: {} createdDate: {}", new Object[]{user.getName(), userWithAttributes.isActive(), lastLoginDate, new DateTime((Object)((TimestampedUser)user).getCreatedDate())});
            ++count;
        }
        log.trace("User cleanup: Found {} users in the relevant search", (Object)count);
    }

    public UserCleanupResult doJsmLicenseCleanup(String currentUserName, DryRunAttributes dryRunAttributes, CleanupRule cleanupRule, DateTime inactivityCutoffTimestamp, SearchRestriction searchRestriction, String dryRunString, String runId) throws ConfigurationException {
        this.controlCleanupConfiguration(cleanupRule, dryRunAttributes, false);
        Iterable<User> users = this.getUsersWithSearchRestriction(false, null, searchRestriction);
        List<String> directoryExclusionList = this.getDirectoryExclusionList(cleanupRule);
        List<Long> cleanableDirectoryIds = this.getCleanableDirectoryIds(cleanupRule, directoryExclusionList);
        List<ApplicationUser> userList = this.getApplicationUsers(users, cleanupRule);
        ArrayList<UserSummary> affectedUsersList = new ArrayList<UserSummary>();
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        try {
            List<ApplicationUser> inactiveUsers = ((JiraHostApp)this.hostApp).getUsersToJSMClean(currentUserName, cleanupRule.getDaysInactiveThreshold(), userList);
            for (ApplicationUser inactiveUser : inactiveUsers) {
                if (this.hostApp.getJsmCleanupExecuteStatus() == CleanupStatus.NOT_RUN) {
                    throw new BreakException();
                }
                Directory inactiveUserDir = allDirectories.stream().filter(directory -> directory.getId().longValue() == inactiveUser.getDirectoryId()).findFirst().get();
                if (!this.isUserEligibleForJSMCleanup(inactiveUser.getDirectoryId(), cleanableDirectoryIds, this.getExcludedDirectoryIds(allDirectories, directoryExclusionList))) continue;
                this.optionallyCleanupUser(dryRunString, dryRunAttributes, cleanupRule, affectedUsersList, (User)this.hostApp.getDirectoryManager().findUserByName(inactiveUserDir.getId().longValue(), inactiveUser.getName()), inactiveUserDir, cleanableDirectoryIds.contains(inactiveUser.getDirectoryId()));
            }
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (BreakException e) {
            log.warn("Jsm license cleanup: Cleanup process was cancelled mid run. " + affectedUsersList.size() + " users were affected before cancel. You can find complete list of affected users in the jsm cleanup log directory");
        }
        return this.createAndSaveUserCleanupResult(dryRunAttributes, affectedUsersList, inactivityCutoffTimestamp, runId, cleanupRule, CleanupMode.JSM);
    }

    @NotNull
    public UserCleanupResult cleanUsers(String currentUserName, DryRunAttributes dryRunAttributes, DateTime runTimestamp, String runId) throws ConfigurationException {
        try {
            String dryRunString = dryRunAttributes != null && dryRunAttributes.isDryRun() ? "Test run: " : "Real run: ";
            CleanupRule cleanupRule = this.getCleanupRule(CleanupUtilsShared.getCleanupMode(dryRunAttributes));
            DateTime inactivityCutoffTimestamp = this.getInactivityCutoffTimestamp(cleanupRule, dryRunAttributes, runTimestamp);
            DateTime expiryDate = inactivityCutoffTimestamp.withTimeAtStartOfDay().minusDays(cleanupRule.getDaysInactiveThreshold());
            if (log.isTraceEnabled()) {
                this.doUserCleanup(currentUserName, new DryRunAttributes(true, false, false), cleanupRule, this.getSearchRestriction(false, expiryDate, true), inactivityCutoffTimestamp, expiryDate, "true", runId, true);
            }
            if (this.isJsmCleanup(dryRunAttributes)) {
                return this.doJsmLicenseCleanup(currentUserName, dryRunAttributes, cleanupRule, inactivityCutoffTimestamp, this.getSearchRestriction(true, expiryDate, false), dryRunString, runId);
            }
            return this.doUserCleanup(currentUserName, dryRunAttributes, cleanupRule, this.getSearchRestriction(false, expiryDate, false), inactivityCutoffTimestamp, expiryDate, dryRunString, runId, false);
        }
        catch (IOException e) {
            log.error("User cleanup: Failed to parse userCleanupRule json from config", (Throwable)e);
            throw new ConfigurationException("CleanupRule was not configured properly.", (Throwable)e);
        }
    }

    private boolean isJsmCleanup(DryRunAttributes dryRunAttributes) {
        if (dryRunAttributes == null) {
            return false;
        }
        if (!dryRunAttributes.isJsmCleanup()) {
            return false;
        }
        return this.hostApp.isProductMatch("jira");
    }

    private void optionallyCleanupUser(String dryRunString, DryRunAttributes dryRunAttributes, CleanupRule cleanupRule, ArrayList<UserSummary> affectedUsersList, User user, Directory userDirectory, boolean userInCleanableDirectory) {
        boolean success = false;
        if (dryRunAttributes == null || !dryRunAttributes.isDryRun()) {
            if (this.isJsmCleanup(dryRunAttributes)) {
                success = true;
                for (Group jsmGroup : this.hostApp.getJSMGroups()) {
                    if (!this.hostApp.isUserInGroup(user.getName(), jsmGroup.getName())) continue;
                    success = success && this.hostApp.removeUserFromGroup((Principal)user, jsmGroup.getName());
                }
            } else if (cleanupRule.getCleanupAction() == CleanupAction.REMOVE_FROM_GROUP) {
                success = this.hostApp.removeUserFromGroup((Principal)user, cleanupRule.getGroupToRemove());
            } else if (userInCleanableDirectory) {
                success = this.deactivateUser(userDirectory, user);
            } else {
                log.warn("User {} to be deactivated is in read-only directory.", (Object)user.getName());
            }
        } else {
            success = true;
        }
        if (success) {
            log.debug("{}Adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
            String lastLoginMillis = this.hostApp.getLastLoginMillisFromUserWithAttributes(this.hostApp.getUserForCleanup(user));
            DateTime lastLogin = lastLoginMillis == null ? new DateTime((Object)((TimestampedUser)user).getCreatedDate()) : new DateTime(Long.parseLong(lastLoginMillis));
            affectedUsersList.add(new UserSummary(user.getName(), user.getEmailAddress(), lastLogin.toString(), false, false, false));
        } else {
            log.debug("{}Not adding user {} to affected users", (Object)dryRunString, (Object)user.getName());
        }
    }

    @NotNull
    private UserCleanupResult createAndSaveUserCleanupResult(DryRunAttributes dryRunAttributes, ArrayList<UserSummary> affectedUsersList, DateTime now, String runId, CleanupRule cleanupRule, CleanupMode cleanupMode) {
        String name = dryRunAttributes != null && dryRunAttributes.isDryRun() ? "dry-run" : "cleaned-users";
        DateTimeFormatter filenameDtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH-mm-ss'Z'");
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        String filenameId = now.toString(filenameDtf) + "_" + name;
        for (UserSummary summary : affectedUsersList) {
            UserWithAttributes userWithAttributes = this.hostApp.getCrowdService().getUserWithAttributes(summary.getUsername());
            if (userWithAttributes == null) continue;
            boolean canLogin = this.hostApp.isLicensed((Principal)userWithAttributes);
            summary.setIsLicensedGroupMember(canLogin);
            summary.setIsActive(userWithAttributes.isActive());
            summary.setInGroup(this.hostApp.isUserInGroup(userWithAttributes.getName(), cleanupRule.getGroupToRemove()));
        }
        UserCleanupResult result = new UserCleanupResult(filenameId, runId, now.toString(dtf), dryRunAttributes != null && dryRunAttributes.isDryRun(), dryRunAttributes != null && dryRunAttributes.isSimulateCronDate(), affectedUsersList.toArray(new UserSummary[0]), cleanupRule.getCleanupAction(), cleanupRule.getGroupToRemove(), cleanupRule.getDaysInactiveThreshold());
        CleanupResultType logtype = dryRunAttributes != null && dryRunAttributes.isDryRun() ? (dryRunAttributes.isSimulateCronDate() ? CleanupResultType.DRY_SIMULATED_DATE : CleanupResultType.DRY) : CleanupResultType.LIVE;
        try {
            this.saveCleanupLogFile(filenameId, logtype, this.createJsonObjectFromCleanupResult(result), cleanupMode);
        }
        catch (Exception e) {
            List<String> usernamesList = Arrays.stream(result.getAffectedUsers()).map(userSummary -> userSummary.getUsername() + ": " + userSummary.getEmail()).collect(Collectors.toList());
            log.warn("User cleanup: Failed to save UserCleanupResults log to file.", (Throwable)e);
            log.warn("User cleanup: The following users where affected by the cleanup operation:");
            usernamesList.forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        return result;
    }

    public UserCleanupResult[] getCleanupLog(CleanupLogAttributes cleanupLogAttributes) {
        CleanupMode cleanupMode;
        CleanupMode cleanupMode2 = cleanupMode = cleanupLogAttributes.getJsmCleanup() ? CleanupMode.JSM : CleanupMode.USERS;
        CleanupResultType[] cleanupResultTypes = cleanupLogAttributes.getIncludeAllLogs() ? new CleanupResultType[]{CleanupResultType.DRY, CleanupResultType.DRY_SIMULATED_DATE, CleanupResultType.LIVE} : (cleanupLogAttributes.isDryRun() ? (cleanupLogAttributes.isSimulateCronDate() ? new CleanupResultType[]{CleanupResultType.DRY_SIMULATED_DATE} : new CleanupResultType[]{CleanupResultType.DRY}) : new CleanupResultType[]{CleanupResultType.LIVE});
        return this.getUserCleanupResultsFromFiles(cleanupResultTypes, cleanupMode);
    }

    public UserCleanupResult[] getUserCleanupResultsFromFiles(CleanupResultType[] cleanupResultTypes, CleanupMode cleanupMode) {
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        ArrayList result = new ArrayList();
        ObjectReader jsonReader = this.jsonWrapper.objectReader();
        List<CleanupResultType> list = Arrays.asList(cleanupResultTypes);
        list.forEach(logType -> {
            File directory = this.getDirectoryFromResultType(baseDirectory, (CleanupResultType)((Object)logType));
            File[] filesInDir = directory.listFiles();
            List<File> files = Arrays.asList(filesInDir == null ? new File[]{} : filesInDir);
            files.forEach(file -> {
                try (FileInputStream is = new FileInputStream((File)file);){
                    String jsonText = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (jsonText != null && jsonText.length() > 0) {
                        result.add((UserCleanupResult)jsonReader.readValue(jsonText, UserCleanupResult.class));
                    }
                }
                catch (IOException e) {
                    log.warn("User cleanup: Failed to get cleanup result from file: " + file.getName(), (Throwable)e);
                }
            });
        });
        result.forEach(userCleanupResult -> {
            if (userCleanupResult.getAffectedUsers().length > 100000) {
                userCleanupResult.setAffectedUsers(Arrays.copyOf(userCleanupResult.getAffectedUsers(), 100000));
            }
        });
        return result.stream().sorted(Comparator.comparing(UserCleanupResult::getFilenameId)).collect(Collectors.toList()).toArray(result.toArray(new UserCleanupResult[0]));
    }

    public File getDirectoryFromResultType(File parentDir, CleanupResultType logType) {
        File directory;
        switch (logType) {
            case DRY: {
                directory = new File(parentDir, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(parentDir, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                directory = new File(parentDir, "liveCleanupLogs");
            }
        }
        return directory;
    }

    public void saveCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, JSONObject jsonData, CleanupMode cleanupMode) throws IOException {
        int maxNofFiles;
        File directory;
        File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
        boolean isDry = true;
        switch (cleanupResultType) {
            case DRY: {
                directory = new File(baseDirectory, "dryRuns");
                break;
            }
            case DRY_SIMULATED_DATE: {
                directory = new File(baseDirectory, "dryRunsWithSimulatedDate");
                break;
            }
            default: {
                isDry = false;
                directory = new File(baseDirectory, "liveCleanupLogs");
            }
        }
        File[] filesInDir = directory.listFiles();
        int n = maxNofFiles = isDry ? 1 : 5;
        if (filesInDir != null && filesInDir.length >= maxNofFiles) {
            List sortedFiles = Arrays.stream(filesInDir).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
            while (sortedFiles.size() > maxNofFiles - 1 && sortedFiles.size() > 1) {
                this.clearCleanupLogFile(((File)sortedFiles.get(1)).getName(), cleanupResultType, cleanupMode);
                sortedFiles.remove(1);
            }
        }
        File file = new File(directory, filenameId);
        FileUtils.writeStringToFile((File)file, (String)jsonData.toString(), (Charset)StandardCharsets.UTF_8);
    }

    public boolean clearCleanupLogFile(String filenameId, CleanupResultType cleanupResultType, CleanupMode cleanupMode) {
        int MAX_RETRIES = 3;
        try {
            File baseDirectory = new File(this.hostApp.getHomeDirectory(), CleanupUtils.getCleanupDirName(cleanupMode));
            File directory = this.getDirectoryFromResultType(baseDirectory, cleanupResultType);
            File fileToDelete = new File(directory, filenameId);
            Path filePath = Paths.get(fileToDelete.getPath(), new String[0]);
            Path parentPathOfDeleteFile = filePath.getParent();
            if (parentPathOfDeleteFile == null || !parentPathOfDeleteFile.equals(Paths.get(directory.getPath(), new String[0]))) {
                SanitizedLogStatement.of(filenameId).andThenLog(id -> log.warn("The file path does not seem to target the correct directory. Bailing deletion of file {}", id));
                return false;
            }
            boolean success = false;
            for (int i = 0; i < 3; ++i) {
                if (Files.deleteIfExists(filePath)) {
                    success = true;
                    break;
                }
                try {
                    SanitizedLogStatement.of(filenameId).andThenLog(fileId -> log.debug("User cleanup: Delete of logfile {} failed, attempt to clear file contents instead", fileId));
                    FileUtils.writeStringToFile((File)fileToDelete, (String)"", (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    String msg = "User cleanup: Delete of logfile failed, tried to clear file contents instead. Also failed to clear file contents: " + filenameId;
                    SanitizedLogStatement.of(msg).andThenLog(m -> log.error(msg, (Throwable)e));
                    continue;
                }
                success = true;
            }
            if (!success) {
                String msg = "User cleanup: unable to delete file: " + filenameId;
                SanitizedLogStatement.of(msg).andThenLog(m -> log.warn(msg));
            }
            return success;
        }
        catch (IOException e) {
            String msg = "User cleanup: something went wrong trying to delete file: " + filenameId;
            SanitizedLogStatement.of(msg).andThenLog(m -> log.error(msg, (Throwable)e));
            return false;
        }
    }

    private JSONObject createJsonObjectFromCleanupResult(UserCleanupResult result) {
        ObjectWriter objectWriter = this.jsonWrapper.objectWriter();
        try {
            String jsonStr = objectWriter.writeValueAsString((Object)result);
            return new JSONObject(jsonStr);
        }
        catch (JsonProcessingException e) {
            return new JSONObject();
        }
    }

    private boolean shouldCleanupUser(DateTime lastUsed, DateTime expiryDate) {
        return lastUsed.isBefore((ReadableInstant)expiryDate);
    }

    public boolean deactivateUser(Directory directory, User user) {
        try {
            this.hostApp.updateUser(directory, user.getName(), user.getDisplayName(), user.getEmailAddress(), false);
            return true;
        }
        catch (Exception e) {
            log.error("User cleanup: Failed to deactivate user {}", (Object)user.getName(), (Object)e);
            return false;
        }
    }

    private static class CleanupState {
        private final CleanupStatus jsmStatus;
        private final CleanupStatus userStatus;

        CleanupState(CleanupStatus jsmStatus, CleanupStatus userStatus) {
            this.jsmStatus = jsmStatus;
            this.userStatus = userStatus;
        }

        CleanupStatus getStatus(CleanupMode cleanupMode) {
            if (cleanupMode == CleanupMode.USERS) {
                return this.userStatus;
            }
            return this.jsmStatus;
        }

        boolean isCurrent(CleanupStatus status, CleanupMode cleanupMode) {
            CleanupStatus currentStatus = cleanupMode == CleanupMode.USERS ? this.userStatus : this.jsmStatus;
            if (status == null) {
                return currentStatus == null;
            }
            return status.equals((Object)currentStatus);
        }
    }

    public static enum CleanupStatus {
        NOT_RUN,
        RUNNING,
        FAILED,
        SUCCESS;

    }

    static class BreakException
    extends RuntimeException {
        BreakException() {
        }
    }
}

