/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.dircopy;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.wrapper.crowd.CrowdDirectoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyDirectoryServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(CopyDirectoryServlet.class);
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final DirectoryManager directoryManager;
    private ArrayList<String> visualLogMessage = new ArrayList();
    private int numAddedUsers;
    private int numExistingUsers;
    private int numRemovedUsers;
    private int numAddedGroups;
    private int numExistingGroups;
    private int numAddedMemberships;
    private int numExistingMemberships;
    private int numFoundGroups;
    private int numFoundUsers;
    private boolean excludeUsers = false;
    private Directory fromDir = null;
    private Directory toDir = null;
    private final SearchRestriction filterRestriction = NullRestrictionImpl.INSTANCE;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private boolean isRemoveRun = false;
    private boolean hasErrors = false;
    private boolean isAborted = false;
    private final KerbConfManager kerbConfManager;

    @Inject
    public CopyDirectoryServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
        this.directoryManager = this.hostApp.getDirectoryManager();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.modelAndRender(req, resp);
    }

    private void modelAndRender(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "copyDirectory");
        model.put("contextPath", req.getContextPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("allDirectories", this.hostApp.getCrowdDirectoryService().findAllDirectories().stream().map(directory -> new CrowdDirectoryWrapper(directory, this.hostApp.isWritableDirectory((Directory)directory))).collect(Collectors.toList()));
        model.put("writableDirectories", this.hostApp.getWritableUserDirectories().stream().map(CrowdDirectoryWrapper::new).collect(Collectors.toList()));
        model.put("visualLogMessage", new ArrayList<String>(this.visualLogMessage));
        model.put("excludeUsers", this.excludeUsers);
        model.put("numAddedUsers", this.numAddedUsers);
        model.put("numWorkedOnUsers", this.numAddedUsers + this.numExistingUsers);
        model.put("numExistingUsers", this.numExistingUsers);
        model.put("numAddedGroups", this.numAddedGroups);
        model.put("numExistingGroups", this.numExistingGroups);
        model.put("numAddedMemberships", this.numAddedMemberships);
        model.put("numFoundMemberships", this.numAddedMemberships + this.numExistingMemberships);
        model.put("numRemovedUsers", this.numRemovedUsers);
        model.put("numExistingMemberships", this.numExistingMemberships);
        model.put("numFoundGroups", this.numFoundGroups);
        model.put("numFoundUsers", this.numFoundUsers);
        model.put("fromDir", new CrowdDirectoryWrapper(this.fromDir));
        model.put("toDir", new CrowdDirectoryWrapper(this.toDir));
        model.put("isRunning", this.isRunning.get());
        model.put("isAborted", this.isAborted);
        model.put("isRemoveRun", this.isRemoveRun);
        model.put("hasErrors", this.hasErrors);
        model.put("isLicenseValid", this.isLicenseValid());
        model.put("showRemoveUsers", req.getParameter("showRemoveUsers") != null);
        model.put("loggedInUser", this.getLoggedInUsername(req));
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/copy-directory.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        String fromDirId = req.getParameter("fromDirId");
        String toDirId = req.getParameter("toDirId");
        this.excludeUsers = req.getParameter("excludeUsers") != null;
        this.setDirectories(fromDirId, toDirId);
        this.isRemoveRun = false;
        if (req.getParameter("abort") != null) {
            this.isAborted = true;
            this.isRunning.set(false);
            this.log("Copy was aborted by user " + (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull(), "INFO");
        } else {
            this.isAborted = false;
        }
        if (req.getParameter("removeUsers") != null) {
            this.visualLogMessage = new ArrayList();
            this.numRemovedUsers = 0;
            this.hasErrors = false;
            this.isRemoveRun = true;
            this.removeToDirUsersExceptLoggedIn(req, this.toDir, this.directoryManager, this.filterRestriction);
        } else if (!this.isAborted && this.isLicenseValid() && !this.isRunning.get() && fromDirId != null && toDirId != null) {
            this.visualLogMessage = new ArrayList();
            this.isRunning.set(true);
            this.numAddedUsers = 0;
            this.numRemovedUsers = 0;
            this.numExistingUsers = 0;
            this.numFoundGroups = 0;
            this.numFoundUsers = 0;
            this.numAddedGroups = 0;
            this.numExistingGroups = 0;
            this.numAddedMemberships = 0;
            this.numExistingMemberships = 0;
            this.hasErrors = false;
            if (!fromDirId.equals(toDirId)) {
                if (this.fromDir != null && this.toDir != null) {
                    this.log(String.format("Starting to copy from directory '%s' to '%s' at %s", this.fromDir.getName(), this.toDir.getName(), new Date()), "INFO");
                    if (this.excludeUsers) {
                        this.log("Selected to not copy users", "INFO");
                    }
                    this.addGroups();
                    List<User> users = this.searchUsers(this.filterRestriction);
                    if (users != null) {
                        this.numFoundUsers = users.size();
                        if (this.numFoundUsers == 0) {
                            this.log(String.format("No users were found in '%s'", this.fromDir.getName()), "INFO");
                        }
                        for (User user : users) {
                            if (!this.isRunning.get()) continue;
                            try {
                                if (!this.excludeUsers) {
                                    this.addOrUpdateUser(user, this.getLoggedInUsername(req));
                                }
                                this.addUserGroups(user);
                            }
                            catch (Exception e) {
                                if (StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)this.getLoggedInUsername(req)) || this.excludeUsers) continue;
                                this.log(String.format("Problem adding groups to username '%s'", user.getName()), "ERROR");
                            }
                        }
                    }
                }
            } else {
                this.log(String.format("Can not copy from and to the same directory '%s'", this.fromDir.getName()), "INFO");
            }
            this.isRunning.set(false);
        }
        this.modelAndRender(req, resp);
    }

    private void addUserGroups(User user) throws DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException {
        List<Group> userGroups = this.findUserGroups(this.fromDir, user);
        this.log(String.format("Copying %s groups for user '%s' ", userGroups.size(), user.getName()), "INFO");
        for (Group group : userGroups) {
            try {
                this.addUserGroup(this.toDir, this.directoryManager, user, group);
                ++this.numAddedMemberships;
            }
            catch (MembershipAlreadyExistsException m) {
                this.log(String.format("User '%s' already is member of group '%s'", user.getName(), group.getName()), "INFO");
                ++this.numExistingMemberships;
            }
        }
    }

    private void addOrUpdateUser(User user, String loggedInUser) {
        block9: {
            try {
                if (!StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)loggedInUser)) {
                    this.log(String.format("Creating user '%s'", user.getName()), "INFO");
                    try {
                        this.hostApp.addUser(this.toDir, user.getName(), user.getDisplayName(), user.getEmailAddress(), new HashSet<String>(), user.isActive());
                        ++this.numAddedUsers;
                    }
                    catch (RuntimeException e) {
                        if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"problem 22")) {
                            this.log(String.format("Not able to add user '%s'. This is probably because username is longer than 20 characters.", user.getName()), "ERROR");
                            break block9;
                        }
                        if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"problem 4003")) {
                            this.log(String.format("Not able to add user. Please check that user configured in %s User Directory setup has write access to AD.\n\n", this.applicationProperties.getDisplayName()), "ERROR");
                            break block9;
                        }
                        this.log(String.format("Not able to add user '%s'.", user.getName()), "ERROR");
                    }
                    break block9;
                }
                this.log(String.format("Ignoring copying logged in user to avoid lockout since password is not copied.", user.getName()), "INFO");
            }
            catch (UserAlreadyExistsException u) {
                this.log(String.format("User '%s' already exists. Updating user.", user.getName()), "INFO");
                try {
                    ++this.numExistingUsers;
                    this.hostApp.updateUserInDirectory(this.toDir, user.getName(), user.getDisplayName(), user.getEmailAddress(), user.isActive());
                }
                catch (RuntimeException r) {
                    if (StringUtils.contains((CharSequence)r.getMessage(), (CharSequence)"we expected")) break block9;
                    this.log(String.format("Not able to update user '%s'.", user.getName()), "ERROR");
                }
            }
        }
    }

    @Nullable
    private List<User> searchUsers(SearchRestriction filterRestriction) {
        List users = null;
        try {
            users = this.directoryManager.searchUsers(this.fromDir.getId().longValue(), (EntityQuery)new UserQuery(User.class, filterRestriction, 0, -1));
        }
        catch (Exception e) {
            this.log(String.format("Not able to search for users in directory '%s'", this.fromDir.getName()), "INFO");
        }
        return users;
    }

    private void addGroups() {
        List groups = null;
        try {
            groups = this.directoryManager.searchGroups(this.fromDir.getId().longValue(), QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
        }
        catch (DirectoryNotFoundException e) {
            e.printStackTrace();
        }
        catch (OperationFailedException e) {
            e.printStackTrace();
        }
        if (groups != null) {
            this.numFoundGroups = groups.size();
            for (InternalDirectoryGroup group : groups) {
                GroupTemplate groupTemplate = new GroupTemplate(group.getName(), this.toDir.getId().longValue(), GroupType.GROUP);
                try {
                    this.directoryManager.addGroup(this.toDir.getId().longValue(), groupTemplate);
                    ++this.numAddedGroups;
                    this.log(String.format("Copied group '%s' to directory", group.getName()), "INFO");
                }
                catch (Exception e) {
                    if (e instanceof InvalidGroupException && StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"already exists")) {
                        ++this.numExistingGroups;
                        continue;
                    }
                    this.log(String.format("Not able to add group '%s': %s\n\n", group.getName(), e.getMessage()), "ERROR");
                }
            }
        }
    }

    private void setDirectories(String fromDirId, String toDirId) {
        for (Directory directory : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (StringUtils.equals((CharSequence)fromDirId, (CharSequence)(directory.getId() + ""))) {
                this.fromDir = directory;
            }
            if (!StringUtils.equals((CharSequence)toDirId, (CharSequence)(directory.getId() + ""))) continue;
            this.toDir = directory;
        }
    }

    private List<Group> findUserGroups(Directory fromDir, User user) throws DirectoryNotFoundException, OperationFailedException {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).startingAt(0).returningAtMost(-1);
        List groupNames = this.directoryManager.searchNestedGroupRelationships(fromDir.getId().longValue(), membershipQuery);
        List<Group> userGroups = groupNames.stream().map(groupName -> {
            try {
                return this.directoryManager.findGroupByName(fromDir.getId().longValue(), groupName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return userGroups;
    }

    private void addUserGroup(Directory toDir, DirectoryManager directoryManager, User user, Group group) throws DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        this.log(String.format("Adding user '%s' to group '%s'", user.getName(), group.getName()), "INFO");
        directoryManager.addUserToGroup(toDir.getId().longValue(), user.getName(), group.getName());
    }

    private void removeToDirUsersExceptLoggedIn(HttpServletRequestFacade req, Directory toDir, DirectoryManager directoryManager, SearchRestriction filterRestriction) {
        String loggedInUsername = this.getLoggedInUsername(req);
        this.log(String.format("Starting to remove users from '%s' at %s", toDir.getName(), new Date()), "INFO");
        try {
            List users = directoryManager.searchUsers(toDir.getId().longValue(), (EntityQuery)new UserQuery(User.class, filterRestriction, 0, -1));
            for (User user : users) {
                if (StringUtils.equalsIgnoreCase((CharSequence)loggedInUsername, (CharSequence)user.getName())) continue;
                directoryManager.removeUser(toDir.getId().longValue(), user.getName());
                this.log(String.format("Removing user '%s''", user.getName()), "INFO");
                ++this.numRemovedUsers;
            }
            if (this.numRemovedUsers == 0) {
                this.log(String.format("No users to remove were found in '%s'", toDir.getName()), "INFO");
            }
        }
        catch (Exception e) {
            this.log(String.format("Not able to search for users for removal in directory '%s'", toDir.getName()), "ERROR");
        }
    }

    private String getLoggedInUsername(HttpServletRequestFacade req) {
        String loggedInUsername = (String)Option.of((Object)this.userManager.getRemoteUser((HttpServletRequest)req)).map(UserProfile::getUsername).getOrNull();
        return loggedInUsername;
    }

    private void log(String logMessage, String logLevel) {
        if ("ERROR".equals(logLevel)) {
            log.error(logMessage);
            this.hasErrors = true;
        } else {
            log.info(logMessage);
        }
        this.visualLogMessage.add(logLevel + " " + logMessage);
    }

    private boolean isLicenseValid() {
        boolean isLicenseValid = true;
        PluginLicense pluginLicense = null;
        try {
            if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
                pluginLicense = (PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get();
            }
        }
        catch (Exception e) {
            log.error("Exception getting Kerberos plugin configuration", (Throwable)e);
            isLicenseValid = false;
        }
        if (pluginLicense == null || !pluginLicense.isValid()) {
            isLicenseValid = false;
        }
        return isLicenseValid;
    }
}

