/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import com.kantegasso.servlet.http.StatusPreservableHeaderAwareResponse;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.utils.AESCrypto;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BitbucketHostApp
extends DefaultHostApp {
    private final MailService mailService;
    private final Method clearSecurityContextHolderMethod;
    private final Message SUCCESS_MESSAGE = new Message(){

        public Serializable[] getArguments() {
            return null;
        }

        public String getKey() {
            return "Successful authentication";
        }
    };
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object crowdControl;
    public static final String FAILED_AUTHENTICATION_ATTEMPT_COUNT = "failedAuthenticationAttemptCount";
    private final Method crowdControlSetUserAttributeMethod;
    private final LicenseService licenseService;
    private final UserService userService;

    public BitbucketHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, PluginAccessor pluginAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager, JsonWrapper jsonWrapper) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, pluginAccessor, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager, jsonWrapper);
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/repos?visibility=public");
        this.preemptivePathMappings.add("/projects");
        this.preemptivePathMappings.add("/projects/*");
        this.mailService = (MailService)ComponentLocator.getComponent(MailService.class);
        this.licenseService = (LicenseService)ComponentLocator.getComponent(LicenseService.class);
        this.userService = (UserService)ComponentLocator.getComponent(UserService.class);
        this.hasRestApi = true;
        Object crowdControl = null;
        Method crowdControlSetUserAttributeMethod = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader().getParent();
            Class<?> clazz = loader.loadClass("org.springframework.security.core.context.SecurityContextHolder");
            this.clearSecurityContextHolderMethod = clazz.getMethod("clearContext", new Class[0]);
            Class<?> crowdControlClass = loader.loadClass("com.atlassian.stash.internal.crowd.CrowdControl");
            crowdControl = ComponentLocator.getComponent(crowdControlClass);
            Method[] methods = crowdControlClass.getDeclaredMethods();
            crowdControlSetUserAttributeMethod = crowdControlClass.getMethod("setUserAttribute", User.class, String.class, Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Could not load class", e);
        }
        this.crowdControl = crowdControl;
        this.crowdControlSetUserAttributeMethod = crowdControlSetUserAttributeMethod;
    }

    @Override
    public Try<Integer> getFailedLoginAttempts(Principal principal) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal);
        return Try.of((CheckedFunction0 & Serializable)() -> {
            UserWithAttributes userWithAttributes = this.getCrowdService().getUserWithAttributes(principal.getName());
            return userWithAttributes.getValue(FAILED_AUTHENTICATION_ATTEMPT_COUNT);
        }).mapTry(Integer::parseInt).onFailure(e -> this.log.warn("An exception occurred while obtaining currentFailedCount after for user " + usernameForLog, e));
    }

    @Override
    public Try<Void> setFailedLoginAttempts(Principal principal, int count) {
        String usernameForLog = UserManagerUtils.nullsafeUsernameOrAnonymous((Principal)principal);
        return Try.run(() -> {
            UserWithAttributes userWithAttributes = this.getCrowdService().getUserWithAttributes(principal.getName());
            this.crowdControlSetUserAttributeMethod.setAccessible(true);
            this.crowdControlSetUserAttributeMethod.invoke(this.crowdControl, userWithAttributes, FAILED_AUTHENTICATION_ATTEMPT_COUNT, count);
        }).onFailure(e -> this.log.warn("An exception occurred while setting currentFailedCount after for user " + usernameForLog, e));
    }

    @Override
    public Option<String> getAnonymousBrowsingSettingsUrl() {
        return Option.of((Object)"https://confluence.atlassian.com/bitbucketserver/allowing-public-access-to-code-776639799.html");
    }

    @Override
    public boolean isForceLoginRequestMapped(HttpServletRequestFacade req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return super.isForceLoginRequestMapped(req) || r.equals("/projects") || r.startsWith("/projects/") || r.equals("/") || r.equals("/repos") && "visibility=public".equals(req.getQueryString());
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"bitbucket", (CharSequence)product);
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/users?create";
    }

    @Override
    public boolean isRequestMapped(HttpServletRequestFacade req, String r) {
        return this.isPageWithLoginForm(req) || this.isScmRequest(req) && this.kerbConfManager.isBitbucketScmUrlsEnabled() || this.isKerberosScmRequest(req);
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequestFacade req) {
        return this.isMainLoginPage(req) || HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req).equals("/mvc/login");
    }

    @Override
    public boolean isMainLoginPage(HttpServletRequestFacade request) {
        String internalPath = HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request);
        return internalPath.equals("/login");
    }

    @Override
    protected boolean isAppLoggedIn(HttpSessionFacade session) {
        return session.getAttribute("__bbs.security.ctx") != null;
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequestFacade req, HttpServletResponseFacade res) {
        if (req == null) {
            return super.shouldLoginManually(null, res);
        }
        if (this.isScmRequest(req) && !this.kerbConfManager.isBitbucketScmUrlsEnabled()) {
            return true;
        }
        if ((this.isScmRequest(req) || this.isKerberosScmRequest(req)) && !this.hasBasicAuth(req)) {
            return false;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return r.equals("/login") && req.getParameter("next") == null && req.getParameter("nextUrl") == null;
    }

    @Override
    public boolean isLoginRequest(HttpServletRequestFacade req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return ("/j_atl_security_check".equals(r) || this.isDefaultRestEndpointForAuthentication(req) || "/websudo".equals(r)) && "POST".equals(req.getMethod());
    }

    @Override
    public boolean legacyIsPasswordLoginRequest(HttpServletRequestFacade req) {
        return StringUtils.isNotBlank((CharSequence)req.getParameter("j_password"));
    }

    @Override
    public String newGetLoginRequestPassword(HttpServletRequestFacade req) {
        try {
            JSONObject jsonObject = new JSONObject(this.readRequestBody(req));
            if (jsonObject.has("password")) {
                return jsonObject.getString("password");
            }
            if (jsonObject.has("j_password")) {
                return jsonObject.getString("j_password");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String legacyGetLoginRequestUsername(HttpServletRequestFacade req) {
        return req.getParameter("j_username");
    }

    @Override
    public String legacyGetLoginRequestPassword(HttpServletRequestFacade req) {
        return req.getParameter("j_password");
    }

    @Override
    public String getTargetParameterName() {
        return "next";
    }

    private boolean hasBasicAuth(HttpServletRequestFacade req) {
        String authorization = req.getHeader("Authorization");
        return authorization != null && authorization.startsWith("Basic ");
    }

    private boolean isScmRequest(HttpServletRequestFacade req) {
        return req.getServletPath().startsWith("/scm");
    }

    private boolean isKerberosScmRequest(HttpServletRequestFacade req) {
        return req.getServletPath().startsWith("/kerberos-scm");
    }

    @Override
    public void dispatchToLogin(HttpServletRequestFacade req, HttpServletResponseFacade resp, FilterChainFacade chain) throws IOException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (this.isRestApi(requestPath)) {
            chain.doFilterKsso(req, (HttpServletResponseFacade)new StatusPreservableHeaderAwareResponse((HttpServletResponse)resp));
        } else if (this.isScmRequest(req) || this.isKerberosScmRequest(req)) {
            resp.setHeader("WWW-Authenticate", "Basic realm=\"Atlassian Bitbucket\"");
            resp.addHeader("WWW-Authenticate", "Negotiate");
        } else if (req.getQueryString() != null && req.getQueryString().contains("logout?SAMLResponse")) {
            this.metaRefresh(resp, "login?next=");
        } else if (BitbucketHostApp.shouldDispatchToLoginPage(this.kerbConfManager) && !requestPath.startsWith("/login")) {
            String qs = req.getQueryString() != null ? "?" + req.getQueryString() : "";
            resp.sendRedirect(req.getContextPath() + "/login?next=" + HttpUrlUtils.urlEncode((String)(requestPath + qs)));
        } else {
            chain.doFilterKsso(req, resp);
        }
    }

    @Override
    public void invalidateSession(HttpServletResponseFacade res, HttpServletRequestFacade req) {
        try {
            this.clearSecurityContextHolderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke SecurityContextHolder.clearContext", e);
        }
        super.invalidateSession(res, req);
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequestFacade req, HttpServletResponseFacade res, Principal user) {
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(this.SUCCESS_MESSAGE, user), (HttpServletRequest)req, (HttpServletResponse)res);
        Integer userId = this.getUserId(user);
        try {
            Class<?> ausClass = CrowdDirectoryService.class.getClassLoader().loadClass("com.atlassian.stash.internal.spring.security.AuthenticatedUserState");
            Object userState = ausClass.getConstructor(Integer.TYPE, Map.class).newInstance(userId, Collections.emptyMap());
            req.getSessionKsso().setAttribute("__bbs.security.ctx", userState);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.resetCaptchaOnSsoLogin(user);
        }
        catch (Exception e) {
            this.log.debug("Unable to perform resetCaptchaOnSsoLogin", (Throwable)e);
        }
        return user;
    }

    private void resetCaptchaOnSsoLogin(Principal user) {
        try {
            this.log.debug("Resetting captcha for user {} during SSO login.", (Object)user.getName());
            Object crowdControl = ComponentLocator.getComponent(UserAdminService.class.getClassLoader().loadClass("com.atlassian.stash.internal.crowd.CrowdControl"));
            Method setUserAttribute = crowdControl.getClass().getMethod("setUserAttribute", User.class, String.class, Object.class);
            setUserAttribute.invoke(crowdControl, this.crowdService.getUser(user.getName()), FAILED_AUTHENTICATION_ATTEMPT_COUNT, 0L);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.warn("Problem resetting capthca on SSO login", (Throwable)e);
        }
    }

    Integer getUserId(Principal user) {
        try {
            Field id = user.getClass().getSuperclass().getDeclaredField("id");
            id.setAccessible(true);
            return (Integer)id.get(user);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequestFacade req, HttpServletResponseFacade res, FilterChainFacade chain) throws IOException {
        this.preventCaching(res);
        if (this.isScmRequest(req) || this.isKerberosScmRequest(req) || this.isRestApi(req.getRequestURI().substring(req.getContextPath().length()))) {
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null && userAgent.contains("JGit")) {
                res.setHeader("WWW-Authenticate", "Negotiate");
            }
            chain.doFilterKsso((HttpServletRequestFacade)new AuthenticatedRequest(user, req), res);
        } else {
            String next = req.getParameter("next");
            if (next == null) {
                next = req.getParameter("nextUrl");
            }
            if (next != null) {
                if (next.startsWith("http")) {
                    this.safeRedirect.sendRedirect(next, req, res, this);
                } else {
                    this.safeRedirect.sendRedirect(req.getContextPath() + next, req, res, this);
                }
            } else {
                this.safeRedirect.sendRedirect(req.getRequestURI(), req, res, this);
            }
        }
    }

    @Override
    public String getRedirectTarget(HttpServletRequestFacade req) {
        String next = req.getParameter("next");
        if (next == null) {
            next = req.getParameter("nextUrl");
        }
        if (next != null) {
            if (next.startsWith("http")) {
                return next;
            }
            return req.getContextPath() + next;
        }
        return req.getContextPath();
    }

    @Override
    public boolean isSMTPSupported() {
        return true;
    }

    @Override
    public boolean isSMTPEnabled() {
        return this.mailService.isHostConfigured();
    }

    @Override
    public void sendEmail(String recipient, String subject, String body) {
        this.mailService.submit(new MailMessage.Builder().to(new String[]{recipient}).subject(subject).text(body).build());
    }

    @Override
    public String getLastLoginMillisFromUserWithAttributes(UserWithAttributes user) {
        return user.getValue("lastAuthenticationTimestamp");
    }

    @Override
    public String getLastLoginParameter() {
        return "lastAuthenticationTimestamp";
    }

    @Override
    public File getHomeDirectory() {
        File localHome = new File(this.applicationProperties.getHomeDirectory(), "kerberos");
        if (localHome.exists()) {
            return localHome;
        }
        return new File(String.valueOf(this.applicationProperties.getHomeDirectory()) + "/shared/", "kerberos");
    }

    @Override
    public String getLoginPage() {
        return "/login";
    }

    @Override
    public String getMainLogoutPage() {
        return "/logout";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5503;
    }

    @Override
    public boolean isRestApiExcluded(String r) {
        return r.startsWith("/rest/mirroring/") || r.startsWith("/rest/ssh/") || super.isRestApiExcluded(r);
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = super.asJson();
        json.put("mailServiceIsHostConfigured", this.mailService.isHostConfigured());
        return json;
    }

    @Override
    public boolean isRESTRequestMapped(HttpServletRequestFacade req, String r) {
        String referer = req.getHeader("referer");
        if (StringUtils.contains((CharSequence)referer, (CharSequence)"?")) {
            referer = StringUtils.substring((String)referer, (int)0, (int)referer.indexOf("?"));
        }
        return super.isRESTRequestMapped(req, r) && !StringUtils.endsWith((CharSequence)referer, (CharSequence)"/login") && !StringUtils.endsWith((CharSequence)referer, (CharSequence)"/logout") && !StringUtils.endsWith((CharSequence)r, (CharSequence)"/rest/analytics/1.0/publish/bulk") && !StringUtils.endsWith((CharSequence)r, (CharSequence)"/rest/qr/1.0/batching");
    }

    @Override
    public String getDefaultAdminGroupName() {
        if (this.getAllGroups().stream().anyMatch(group -> group.getName().equals("stash-administrators"))) {
            return "stash-administrators";
        }
        return null;
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter, String ldapPasswordSavedByKsso) {
        if (ldapPasswordParameter != null && ldapPasswordParameter.startsWith("{AES_CBC_PKCS5Padding}")) {
            try {
                return AESCrypto.decrypt(ldapPasswordSavedByKsso, this.kerbConfManager.getLdapPasswordEncryptionKey());
            }
            catch (Exception e) {
                this.log.debug("Failed to decrypt LDAP password", (Throwable)e);
            }
        }
        return ldapPasswordParameter;
    }

    @Override
    public void storeLdapPassword(HttpServletRequestFacade req) {
        if (StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/plugins/servlet/embedded-crowd/configure/ldap/") && "POST".equals(req.getMethod())) {
            req.getSessionKsso().setAttribute("ldapPassword", (Object)req.getParameter("ldapPassword"));
        } else if (StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/plugins/servlet/embedded-crowd/directories/troubleshoot")) {
            try {
                String ldapPassord = (String)req.getSessionKsso().getAttribute("ldapPassword");
                req.getSessionKsso().removeAttribute("ldapPassword");
                String directoryId = req.getParameter("directoryId");
                if (StringUtils.isNotBlank((CharSequence)ldapPassord) && StringUtils.isNotBlank((CharSequence)directoryId)) {
                    Directory directory = this.getDirectoryManager().findDirectoryById(Long.parseLong(req.getParameter("directoryId")));
                    ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
                    HashMap<String, String> attrs = new HashMap<String, String>(directory.getAttributes());
                    attrs.put("ksso.ldapPassword", AESCrypto.encrypt(ldapPassord, this.kerbConfManager.getLdapPasswordEncryptionKey()));
                    builder.setAttributes(attrs);
                    this.getCrowdDirectoryService().updateDirectory(builder.toDirectory());
                }
            }
            catch (Exception e) {
                this.log.warn("Problem saving ldap password in K-SSO");
            }
        }
    }

    @Override
    public boolean isEditAccountGetRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/account") && "GET".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isAdminEditAccountGetRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/admin/users/view") && "GET".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isEditAccountPostRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/account") && "POST".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public boolean isAdminEditAccountPostRequest(HttpServletRequestFacade req) {
        return StringUtils.endsWith((CharSequence)req.getRequestURI(), (CharSequence)"/rest/api/1.0/admin/users") && "PUT".equalsIgnoreCase(req.getMethod());
    }

    @Override
    public String getEditAccountName(HttpServletRequestFacade req) {
        return req.getParameter("displayName");
    }

    @Override
    public String getEditAccountEmail(HttpServletRequestFacade req) {
        return req.getParameter("emailAddress");
    }

    @Override
    public UserProfile getEditAccountUser(UserManager userManager, HttpServletRequestFacade req) {
        String username = req.getParameter("name");
        if (username == null && this.isAdminEditAccountPostRequest(req)) {
            username = StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)req.getHeader("referer"), (String)"name="), (String)"&");
        }
        return username != null ? userManager.getUserProfile(username) : null;
    }

    @Override
    public String getDatabaseUrl() {
        try {
            return ((ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class)).getJdbcUrl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isLegacyLoginPageDefaultOnCurrentApplicationVersion() {
        Version applicationVersion = Version.of((String)this.applicationProperties.getVersion());
        return applicationVersion.isLowerThan(Version.of((String)"9.2"));
    }

    @Override
    public boolean isLicensed(Principal user) {
        ApplicationUser applicationUser = this.userService.getUserByName(user.getName());
        return this.licenseService.canLogin((Principal)applicationUser);
    }

    @Override
    public String getForgotPasswordUrl() {
        return "/passwordreset";
    }

    @Override
    public String getDefaultLicenseGroup() {
        return "stash-users";
    }

    @Override
    public String[] getTargetUrlParameters() {
        return new String[]{"nextUrl", "next"};
    }

    private class AuthenticatedRequest
    extends HttpServletRequestFacade {
        private final Principal user;

        public AuthenticatedRequest(Principal user, HttpServletRequestFacade request) {
            super((HttpServletRequest)request);
            this.user = user;
        }

        public String getRemoteUser() {
            return this.user.getName();
        }

        public Principal getUserPrincipal() {
            return this.user;
        }
    }
}

