/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.runtimetrust.Fingerprint;
import com.kantegasso.servlet.http.CookieFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kantega.shaded.org.opensaml.core.xml.XMLObject;
import kantega.shaded.org.opensaml.core.xml.io.MarshallingException;
import kantega.shaded.org.opensaml.core.xml.util.XMLObjectSupport;
import kantega.shaded.org.opensaml.saml.saml2.core.AuthnContextClassRef;
import kantega.shaded.org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import kantega.shaded.org.opensaml.saml.saml2.core.AuthnRequest;
import kantega.shaded.org.opensaml.saml.saml2.core.Issuer;
import kantega.shaded.org.opensaml.saml.saml2.core.LogoutRequest;
import kantega.shaded.org.opensaml.saml.saml2.core.NameIDPolicy;
import kantega.shaded.org.opensaml.saml.saml2.core.RequestedAuthnContext;
import kantega.shaded.org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import kantega.shaded.org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import kantega.shaded.org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import kantega.shaded.org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import kantega.shaded.org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import kantega.shaded.org.opensaml.security.credential.Credential;
import kantega.shaded.org.opensaml.storage.ReplayCache;
import kantega.shaded.org.opensaml.storage.StorageService;
import kantega.shaded.org.opensaml.xmlsec.signature.Signature;
import kantega.shaded.org.opensaml.xmlsec.signature.X509Certificate;
import kantega.shaded.org.opensaml.xmlsec.signature.X509Data;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.identityproviders.postprocessing.SsoLoginPostProcessor;
import org.kantega.atlaskerb.identityproviders.postprocessing.SsoPostProcessingResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.saml.cache.AtlassianAuthnStateCache;
import org.kantega.atlaskerb.saml.cache.AtlassianCacheStorageService;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.atlaskerb.security.CookieSecurity;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.atlaskerb.websudo.WebSudoServlet;
import org.kantega.samllib.IdGenerator;
import org.kantega.samllib.cache.SamlReplayCache;
import org.kantega.samllib.crossplatform.AuthnContextClassRefFacade;
import org.kantega.samllib.crossplatform.SamlTimeUtils;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.ValidationResult;
import org.kantega.samllib.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;

@Component
public class ServiceProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderFactory.class);
    private final ConnectorConfManager connectorConfManager;
    private final IdpConfManager idpConfManager;
    private final SamlReplayCache replayCache;
    private final AuthnStateCache authnStateCache;
    private final KerbConfManager kerbConfManager;
    private final AuditLogFacade auditLogFacade;
    private final IdGenerator random = new IdGenerator();
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final SingleLogoutAppHelper logoutAppHelper;
    private final SAMLResponseEvaluator responseEvaluator;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final SafeRedirect safeRedirect;
    private final ErrorPageRenderer errorPageRenderer;
    private final SsoLoginPostProcessor ssoLoginPostProcessor;
    public static final String INSTANT_LOGIN_TARGET_URL = "samlInstantLoginUrl";

    @Inject
    public ServiceProviderFactory(@ComponentImport UserManager userManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport CacheManager cacheManager, @ComponentImport TemplateRenderer renderer, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, AuditLogFacade auditLogFacade, ConnectorConfManager connectorConfManager, HostAppFactory hostApp, SAMLResponseEvaluator responseEvaluator, SafeRedirect safeRedirect, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory, ErrorPageRenderer errorPageRenderer, SsoLoginPostProcessor ssoLoginPostProcessor) {
        this.connectorConfManager = connectorConfManager;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.auditLogFacade = auditLogFacade;
        this.renderer = renderer;
        this.hostApp = hostApp.getInstance();
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
        this.responseEvaluator = responseEvaluator;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.safeRedirect = safeRedirect;
        this.replayCache = new SamlReplayCache.Builder().setStrict(true).setStorageService((StorageService)new AtlassianCacheStorageService(cacheManager)).build();
        this.authnStateCache = new AtlassianAuthnStateCache(cacheManager);
        this.errorPageRenderer = errorPageRenderer;
        this.ssoLoginPostProcessor = ssoLoginPostProcessor;
    }

    public ServiceProviderSpi getInstance(SamlIdpConfiguration config) {
        return new SpConfSpi(config);
    }

    private void authenticateUserInCrowdSSO(Principal principal, Directory userDirectory) throws OperationFailedException {
        block8: {
            String appName = (String)userDirectory.getAttributes().get("application.name");
            if (appName != null && this.connectorConfManager.getDirectory(appName) == null) {
                try {
                    SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)userDirectory);
                    if (groupSyncMode != SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS) break block8;
                    DbCachingRemoteDirectoryInstanceLoader instanceLoader = (DbCachingRemoteDirectoryInstanceLoader)ComponentLocator.getComponent(DbCachingRemoteDirectoryInstanceLoader.class);
                    DbCachingRemoteDirectory directory = (DbCachingRemoteDirectory)instanceLoader.getDirectory(userDirectory);
                    RemoteCrowdDirectory crowdDirectory = (RemoteCrowdDirectory)this.hostApp.getAuthorativeDirectory(directory);
                    try {
                        String token = crowdDirectory.getCrowdClient().authenticateSSOUserWithoutValidatingPassword(new UserAuthenticationContext(principal.getName(), null, new ValidationFactor[0], null));
                        crowdDirectory.getCrowdClient().invalidateSSOToken(token);
                    }
                    catch (OperationFailedException e) {
                        log.debug("REST-call failed. Likely because of a remote jira");
                    }
                    catch (ApplicationPermissionException | InvalidAuthenticationException e) {
                        log.error("Error authenticating user remotely", e);
                    }
                    catch (ApplicationAccessDeniedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InactiveAccountException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (NoClassDefFoundError e) {
                    log.debug("Unable to perform user sync on login since Crowd API is too old and not compatible with triggering this. Sync will happen on next scheduled synchronisation");
                }
            }
        }
    }

    private void renderLogoutErrors(SamlLogoutValidationResult result, HttpServletResponseFacade resp) throws IOException {
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel();
        model.put("errors", result.getResults());
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("displayName", this.applicationProperties.getDisplayName());
        String id = result.getServiceProviderSpi().getIdentityProviderId();
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        model.put("idp", configuration.getName());
        this.renderer.render("templates/saml/logout-error.vm", model, (Writer)resp.getWriter());
    }

    private boolean isSystemAdmin(HttpServletRequestFacade request) {
        return HttpUrlUtils.isSystemAdmin((UserManager)this.userManager, (HttpServletRequestFacade)request);
    }

    private void recordTest(SamlResponseValidationResult result, ResponseEvaluationCode code, SAMLResponseEvaluationResult evaluationResult, IdpConfiguration idpConfiguration) throws IOException {
        if (result.getResponseObject() == null) {
            result.getResponse().sendError(400, "Response did not contain a SAML response object");
            return;
        }
        try {
            String xml = result.getResponseObject() == null ? null : XmlUtils.serializeXml((Element)XMLObjectSupport.marshall((XMLObject)result.getResponseObject()));
            this.idpConfManager.recordTestResult(idpConfiguration.getId(), result, evaluationResult, xml, this.kerbConfManager.getRemoteIpAddress(HttpServletRequestFacade.of((HttpServletRequest)result.getRequest())));
            if (idpConfiguration.getNotificationEmails() != null && !this.isSystemAdmin(HttpServletRequestFacade.of((HttpServletRequest)result.getRequest()))) {
                try {
                    this.sendNotificationEmails(result, idpConfiguration);
                }
                catch (Exception e) {
                    log.error("Could not send notification emails", (Throwable)e);
                }
            }
        }
        catch (MarshallingException e) {
            throw new RuntimeException(e);
        }
        String location = TestUtils.testResultURL(HttpServletRequestFacade.of((HttpServletRequest)result.getRequest()), idpConfiguration, this.idpConfManager, this.userManager, result.getAuthnRequestID());
        result.getResponse().sendRedirect(location);
    }

    private void sendNotificationEmails(SamlResponseValidationResult result, IdpConfiguration idpConfiguration) {
        if (!this.hostApp.isSMTPSupported() || !this.hostApp.isSMTPEnabled()) {
            return;
        }
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        String evalPath = this.idpConfManager.getServiceProviderEvaluateTestUrl(HttpServletRequestFacade.of((HttpServletRequest)result.getRequest()), idpConfiguration.getId());
        evalPath = evalPath.substring(HttpServletRequestFacade.of((HttpServletRequest)result.getRequest()).getContextPath().length());
        String url = baseUrl + evalPath + "/" + result.getAuthnRequestID() + "/result";
        String subject = "New SAML authentication test result";
        String body = "A new SAML authentication test result was received\n\nVisit the following URL to see the result:\n\n" + url;
        for (String recipient : idpConfiguration.getNotificationEmails().split(",")) {
            if ((recipient = recipient.trim()).isEmpty()) continue;
            this.hostApp.sendEmail(recipient, subject, body);
        }
    }

    protected Map<String, Object> newModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
        return model;
    }

    private static String prepareTargetUrl(String targetUrl, String contextPath) {
        targetUrl = StringUtils.isBlank((CharSequence)targetUrl) || "None".equals(targetUrl) || StringUtils.startsWith((CharSequence)targetUrl, (CharSequence)(contextPath + "/plugins/servlet/no.kantega.saml/sp/")) ? contextPath + "/" : ((String)targetUrl).replaceAll(" ", "+");
        return targetUrl;
    }

    public static void saveSingleLogoutCookie(HttpServletRequestFacade request, HttpServletResponseFacade response, IdpConfManager idpConfManager, ApplicationProperties applicationProperties, String idpIdSessionKey, String sessionKey) {
        Object sessionCookieValue = null;
        IdpConfiguration idpConf = null;
        if (idpIdSessionKey != null) {
            idpConf = idpConfManager.getIdentityProviderById(idpIdSessionKey);
            sessionCookieValue = idpConf.getId() + "#" + idpIdSessionKey;
            if (sessionKey != null) {
                sessionCookieValue = (String)sessionCookieValue + "#" + sessionKey;
            }
            sessionCookieValue = java.util.Base64.getEncoder().encodeToString(((String)sessionCookieValue).getBytes(StandardCharsets.UTF_8));
        }
        if (sessionCookieValue != null) {
            CookieFacade cookie = CookieSecurity.cookieWithDynamicSecurity(applicationProperties, "ksso_idp_session_data", sessionCookieValue);
            cookie.setPath(request.getContextPath() + "/");
            response.addCookie((Cookie)cookie);
        }
    }

    private class SpConfSpi
    implements ServiceProviderSpi {
        private final SamlIdpConfiguration idpConfiguration;
        private final Map<String, Credential> idpValidationCredentials = new HashMap<String, Credential>();
        private final Credential authnSigningCertCredential;

        public SpConfSpi(SamlIdpConfiguration idpConfiguration) {
            this.idpConfiguration = idpConfiguration;
            for (byte[] certBytes : idpConfiguration.getSigningCerts()) {
                this.idpValidationCredentials.put(Fingerprint.sha1Fingerprint((byte[])certBytes), ServiceProviderFactory.this.idpConfManager.getIdpSigningCredential(certBytes));
            }
            this.authnSigningCertCredential = ServiceProviderFactory.this.idpConfManager.getSpSigningCredential();
        }

        public String getIdentityProviderId() {
            return this.idpConfiguration.getId();
        }

        public ReplayCache getReplayCache() {
            return ServiceProviderFactory.this.replayCache;
        }

        public AuthnStateCache getAuthnStateCache(HttpServletRequestFacade req) {
            return ServiceProviderFactory.this.authnStateCache;
        }

        public String getIdpDestination(HttpServletRequestFacade req) {
            return this.idpConfiguration.getIdpURL();
        }

        public String getACSLocation(HttpServletRequestFacade req) {
            return ServiceProviderFactory.this.idpConfManager.getServiceProviderLoginUrl(req, this.idpConfiguration.getId());
        }

        public String getLogoutLocation(HttpServletRequestFacade req) {
            return ServiceProviderFactory.this.idpConfManager.getServiceProviderLogoutServiceUrl(req, this.idpConfiguration.getId());
        }

        public String getIssuerName(HttpServletRequestFacade req) {
            if (this.idpConfiguration.getIssuerPolicy() == SamlIdpConfiguration.IssuerPolicy.CUSTOM && this.idpConfiguration.getIssuer() != null && !this.idpConfiguration.getIssuer().isEmpty()) {
                return this.idpConfiguration.getIssuer();
            }
            return this.getACSLocation(req);
        }

        public Credential getSigningCredential() {
            return this.authnSigningCertCredential;
        }

        public String nextSamlRequestId() {
            return ServiceProviderFactory.this.random.next();
        }

        public List<Credential> getIdentityProviderCredentials(Signature signature) {
            if (signature.getKeyInfo() != null && signature.getKeyInfo().getX509Datas() != null) {
                for (X509Data x509Data : signature.getKeyInfo().getX509Datas()) {
                    Iterator iterator = x509Data.getX509Certificates().iterator();
                    if (!iterator.hasNext()) continue;
                    X509Certificate certificate = (X509Certificate)iterator.next();
                    String base64 = certificate.getValue();
                    Credential credential = this.idpValidationCredentials.get(Fingerprint.sha1Fingerprint((byte[])Base64.decodeBase64((String)base64)));
                    if (credential == null) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(credential);
                }
            }
            return new ArrayList<Credential>(this.idpValidationCredentials.values());
        }

        public List<Credential> getAllIdentityProviderCredentials() {
            return new ArrayList<Credential>(this.idpValidationCredentials.values());
        }

        private AuthnRequest createAuthnRequest(HttpServletRequestFacade req) {
            AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
            if (this.isForceAuthn(req)) {
                authnRequest.setForceAuthn(Boolean.valueOf(true));
                req.getSessionKsso().setAttribute("ForceAuthInitiated", (Object)"true");
            }
            authnRequest.setIsPassive(Boolean.valueOf(false));
            authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            authnRequest.setAssertionConsumerServiceURL(this.getACSLocation(req));
            Issuer issuer = new IssuerBuilder().buildObject();
            issuer.setValue(this.getIssuerName(req));
            issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            authnRequest.setIssuer(issuer);
            authnRequest.setDestination(this.getIdpDestination(req));
            authnRequest.setIssueInstant(SamlTimeUtils.now());
            authnRequest.setID(this.nextSamlRequestId());
            NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
            nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            authnRequest.setNameIDPolicy(nameIDPolicy);
            RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
            requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
            AuthnContextClassRefFacade authnContextClassRef = new AuthnContextClassRefFacade();
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef.getAuthnContextClassRef());
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
            return authnRequest;
        }

        public AuthnRequest buildAuthnRequest(HttpServletRequestFacade request) {
            String customNameIdFormat;
            AuthnRequest authnRequest = this.createAuthnRequest(request);
            switch (this.idpConfiguration.getRequestedAuthnContextPolicy()) {
                case DO_NOT_SEND: {
                    authnRequest.setRequestedAuthnContext(null);
                    break;
                }
                case CUSTOM: {
                    authnRequest.getRequestedAuthnContext().setComparison(switch (this.idpConfiguration.getRequestedAuthnContextComparison()) {
                        case SamlIdpConfiguration.RequestedAuthnContextComparison.MINIMUM -> AuthnContextComparisonTypeEnumeration.MINIMUM;
                        case SamlIdpConfiguration.RequestedAuthnContextComparison.MAXIMUM -> AuthnContextComparisonTypeEnumeration.MAXIMUM;
                        case SamlIdpConfiguration.RequestedAuthnContextComparison.BETTER -> AuthnContextComparisonTypeEnumeration.BETTER;
                        default -> AuthnContextComparisonTypeEnumeration.EXACT;
                    });
                    List refs = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs();
                    refs.clear();
                    for (String ref : this.idpConfiguration.getAuthnContextClassRef().split("\n")) {
                        if ((ref = ref.trim()).isEmpty()) continue;
                        AuthnContextClassRef accr = new AuthnContextClassRefBuilder().buildObject();
                        refs.add(accr);
                    }
                    break;
                }
            }
            authnRequest.getNameIDPolicy().setAllowCreate(Boolean.valueOf(this.idpConfiguration.getAllowCreate() == IdpConfiguration.AllowCreate.TRUE));
            if (this.idpConfiguration.getNameIdFormat() == IdpConfiguration.NameIdFormat.CUSTOM && (customNameIdFormat = this.idpConfiguration.getCustomNameIdFormat()) != null && !customNameIdFormat.trim().isEmpty()) {
                authnRequest.getNameIDPolicy().setFormat(customNameIdFormat.trim());
            }
            return authnRequest;
        }

        public Optional<SAMLSessionIdentification> getSessionIdentification(HttpServletRequestFacade req) {
            return Optional.ofNullable(req.getSession(false)).flatMap(session -> Optional.ofNullable((String)session.getAttribute("ksso.saml.session.identification"))).map(SessionIdentificationHelper::fromJson);
        }

        public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy() {
            return (SAMLSessionIdentification.ValidationPolicy)Option.of((Object)this.idpConfiguration.getSessionIdentificationValidationPolicy()).getOrElse(SAMLSessionIdentification.ValidationPolicy::getDefault);
        }

        public void responseValidationFailed(SamlResponseValidationResult result) throws IOException {
            if (this.isTest(result) && result.getAuthnRequestID() != null) {
                ServiceProviderFactory.this.recordTest(result, ResponseEvaluationCode.FAILED_SAML_VALIDATION, null, this.idpConfiguration);
            } else {
                ArrayList<ResultType> resultTypes = new ArrayList<ResultType>();
                for (ValidationResult validationResult : result.getResults()) {
                    resultTypes.add(validationResult.getType());
                }
                String errorCodes = ((Object)resultTypes).toString();
                log.error("SAML response validation failed with the following error codes: " + errorCodes);
                ServiceProviderFactory.this.errorPageRenderer.renderErrors(Response.Status.UNAUTHORIZED, Collections.singletonList("SAML Response validation failed: " + errorCodes), result);
            }
        }

        public void renderNotFound(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
            resp.setStatus(404);
            resp.setContentType("text/html");
            resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("providerURL", req.getRequestURI());
            String pluginKey = PluginKey.getPluginKey();
            model.put("pluginKey", pluginKey);
            model.put("pluginResource", pluginKey + ":entrypoint-atlaskerb");
            ServiceProviderFactory.this.renderer.render("templates/saml/login-error-not-found.vm", model, (Writer)resp.getWriter());
        }

        public void responseValidationSucceded(SamlResponseValidationResult result, HttpServletRequestFacade req, HttpServletResponseFacade res) throws IOException {
            SAMLResponseEvaluationResult evaluationResult = ServiceProviderFactory.this.responseEvaluator.evaluate(this.idpConfiguration, result, true);
            if (!this.idpConfiguration.isEnabled() && !this.isTest(result)) {
                this.renderNotFound(req, res);
                return;
            }
            if (this.isTest(result)) {
                ServiceProviderFactory.this.recordTest(result, evaluationResult.getCode(), evaluationResult, this.idpConfiguration);
                return;
            }
            if (!ServiceProviderFactory.this.idpConfManager.isLicenseValid()) {
                ArrayList<String> errors = new ArrayList<String>();
                errors.add("Kantega SSO Plugin license is not valid. Please contact your administrator.");
                ServiceProviderFactory.this.errorPageRenderer.renderErrors(Response.Status.UNAUTHORIZED, errors, result);
                return;
            }
            HttpServletRequestFacade request = HttpServletRequestFacade.of((HttpServletRequest)result.getRequest());
            SsoPostProcessingResult ssoPostProcessingResult = ServiceProviderFactory.this.ssoLoginPostProcessor.processSsoLoginAttempt(this.idpConfiguration, evaluationResult, this.calculateRelayState(result, request));
            switch (ssoPostProcessingResult.getExitCondition()) {
                case ANONYMOUS_BROWSING: {
                    this.addSsoProtectedAnonymousBrowsingSession(ssoPostProcessingResult, result);
                    break;
                }
                case SSO_LOGIN: {
                    this.finishAtlassianLogin(ssoPostProcessingResult, result, req, res);
                    break;
                }
                default: {
                    List<String> errors = Arrays.asList(ssoPostProcessingResult.getMessage());
                    ServiceProviderFactory.this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, errors, result);
                }
            }
        }

        private String calculateRelayState(SamlResponseValidationResult result, HttpServletRequestFacade request) {
            String relayState = result.getRelayState();
            String targetUrlInSession = (String)request.getSessionKsso().getAttribute(ServiceProviderFactory.INSTANT_LOGIN_TARGET_URL);
            if (ServiceProviderFactory.this.idpConfManager.isInstantLoginUrlInSession(this.idpConfiguration.getId()) && StringUtils.isNotBlank((CharSequence)targetUrlInSession)) {
                relayState = targetUrlInSession;
                request.getSessionKsso().removeAttribute(ServiceProviderFactory.INSTANT_LOGIN_TARGET_URL);
                log.debug("Using redirect URL from web session since this is enabled in Advanced SAML settings");
            }
            return relayState;
        }

        private void finishAtlassianLogin(SsoPostProcessingResult ssoPostProcessingResult, SamlResponseValidationResult result, HttpServletRequestFacade req, HttpServletResponseFacade res) throws IOException {
            ArrayList<String> errors = new ArrayList<String>();
            PrincipalEntry principalEntry = ssoPostProcessingResult.getEvaluationResult().getResolvedPrincipalEntry();
            FederatedIdentityResponseEvaluationResult evaluationResult = ssoPostProcessingResult.getEvaluationResult();
            String username = evaluationResult.getSearchedUsername();
            String targetUrl = ssoPostProcessingResult.getTargetUrl();
            if (principalEntry != null && principalEntry.getPrincipal().isPresent()) {
                boolean canLogin;
                boolean isPrincipalFound;
                Principal principal = principalEntry.getPrincipal().get();
                Directory userDirectory = evaluationResult.getResolvedUserDirectory();
                if (userDirectory != null && userDirectory.getType() == DirectoryType.CROWD) {
                    try {
                        ServiceProviderFactory.this.authenticateUserInCrowdSSO(principal, userDirectory);
                    }
                    catch (OperationFailedException e) {
                        ServiceProviderFactory.this.errorPageRenderer.renderErrors(Response.Status.UNAUTHORIZED, Collections.singletonList(String.format("Failed to authenticate user %s in remote Crowd directory", username)), result);
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "Failed to authenticate user in remote Crowd directory.");
                        return;
                    }
                }
                boolean bl = isPrincipalFound = principalEntry.getUserState() == PrincipalEntry.UserState.FOUND;
                if (isPrincipalFound) {
                    ServiceProviderFactory.this.hostApp.publishUserAuthenticatedEvent(principalEntry.getPrincipal().get(), req, res);
                }
                if ((canLogin = ServiceProviderFactory.this.hostApp.canLogin(principal, req)) && isPrincipalFound) {
                    CookieUtil.setLastIdpAccountCookie(this.idpConfiguration.getId(), HttpServletRequestFacade.of((HttpServletRequest)result.getRequest()), HttpServletResponseFacade.of((HttpServletResponse)result.getResponse()));
                    ServiceProviderFactory.this.hostApp.authenticateWithProduct(req, HttpServletResponseFacade.of((HttpServletResponse)result.getResponse()), principal);
                    WebSudoServlet.setForcedAuthSessionId(req, this.idpConfiguration.getId());
                    req.getSession(true).setAttribute("ksso.idp.id.session.key", (Object)this.idpConfiguration.getId());
                    log.debug("Setting SAML IdP Configuration ID in session after successful login: {}", (Object)this.idpConfiguration.getId());
                    req.getSession(true).setAttribute("ksso.idp.session.user", (Object)username);
                    result.getSessionIdentification().ifPresent(sessionIdentification -> {
                        log.debug("Session identification: {}", sessionIdentification);
                        String sessionIdJson = SessionIdentificationHelper.toJson(sessionIdentification);
                        log.debug("Setting session identification object: {}", (Object)sessionIdJson);
                        req.getSession(true).setAttribute("ksso.saml.session.identification", (Object)sessionIdJson);
                        if (this.idpConfiguration.isSingleLogoutEnabled()) {
                            ServiceProviderFactory.saveSingleLogoutCookie(req, res, ServiceProviderFactory.this.idpConfManager, ServiceProviderFactory.this.applicationProperties, this.idpConfiguration.getId(), sessionIdJson);
                        }
                    });
                    if (ServiceProviderFactory.this.kerbConfManager.isRemembermeCookieEnabled()) {
                        HttpServletResponseFacade response = result.getResponse();
                        ServiceProviderFactory.this.hostApp.setRememberMeCookie(req, response, principal.getName());
                    }
                    ServiceProviderFactory.this.safeRedirect.sendRedirect(ServiceProviderFactory.prepareTargetUrl(targetUrl, req.getContextPath()), req, result.getResponse(), ServiceProviderFactory.this.hostApp);
                    ServiceProviderFactory.this.auditLogFacade.loginSuccess(principal.getName(), "SAML with IdP: " + this.idpConfiguration.getName() + ", id: " + this.idpConfiguration.getId());
                    return;
                }
                if (!canLogin) {
                    if (ResumeOidcLoginServlet.tryDoubleRedirect(ServiceProviderFactory.prepareTargetUrl(targetUrl, req.getContextPath()), this.idpConfiguration, req, res, principalEntry, principal, ServiceProviderFactory.this.hostApp, ServiceProviderFactory.this.idpConfManager, ServiceProviderFactory.this.safeRedirect)) {
                        return;
                    }
                    errors.add(String.format("Account %s does not have permission to use %s", username, ServiceProviderFactory.this.applicationProperties.getDisplayName()));
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", String.format("Account does not have permission to use %s", ServiceProviderFactory.this.applicationProperties.getDisplayName()));
                }
                if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                    errors.add(String.format("User %s is not active", principal.getName()));
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "User is not active.");
                }
            } else {
                errors.add(String.format("Principal (account) for %s not found. Unable to authenticate user", username));
            }
            if (!errors.isEmpty()) {
                ServiceProviderFactory.this.errorPageRenderer.renderErrors(Response.Status.UNAUTHORIZED, errors, result);
            }
        }

        public void logoutSuccess(SamlLogoutValidationResult result) throws IOException {
            HttpServletResponseFacade res = result.getResponse();
            HttpServletRequestFacade req = result.getRequest();
            String id = this.getIdentityProviderId();
            SamlIdpConfiguration cfg = ServiceProviderFactory.this.idpConfManager.getSamlIdpById(id);
            String returnUrl = cfg.getSingleLogoutReturnURL();
            if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
                log.debug("Redirecting to return URL: {} for IdP id {}", (Object)returnUrl, (Object)id);
                res.sendRedirect(returnUrl);
            } else {
                log.debug("Redirecting to logout success page for IdP id {}", (Object)id);
                ServiceProviderFactory.this.logoutAppHelper.dispatchToLogoutConfirmed(req, res, id);
            }
        }

        public void invalidateSession(HttpServletRequestFacade req, HttpServletResponseFacade res) {
            ServiceProviderFactory.this.hostApp.invalidateSession(res, req);
        }

        public void logoutFailed(SamlLogoutValidationResult result) throws IOException {
            ArrayList errs = new ArrayList();
            HttpServletResponseFacade resp = result.getResponse();
            result.getResults().forEach(r -> {
                String ts = r.getType().name();
                errs.add(ts);
                log.debug("logoutFailed: {} => {}", (Object)ts, (Object)String.join((CharSequence)",", r.getModel().keySet()));
            });
            ServiceProviderFactory.this.renderLogoutErrors(result, resp);
        }

        private void addSsoProtectedAnonymousBrowsingSession(SsoPostProcessingResult ssoPostProcessingResult, SamlResponseValidationResult result) throws IOException {
            String username = ssoPostProcessingResult.getEvaluationResult().getSearchedUsername();
            String targetUrl = ssoPostProcessingResult.getTargetUrl();
            ServiceProviderFactory.this.hostApp.addSsoProtectedAnonymousBrowsingSession(username, this.idpConfiguration, result.getRequest(), result.getResponse(), targetUrl);
            log.debug("Added SSO-Verified Anonymous Access session after verified SAML login for: " + (String)Option.of((Object)username).getOrElse((Object)"[anonymous]"));
            ServiceProviderFactory.this.auditLogFacade.loginSuccess((String)Option.of((Object)username).getOrElse((Object)"[anonymous]"), "SSO-Verified Anonymous Access SAML with IdP: " + this.idpConfiguration.getName() + ", id: " + this.idpConfiguration.getId());
        }

        private void addUser(UserRecipe userRecipe, Directory dir, IdpConfiguration idpConfiguration, String usernameFromIdp, GroupEvaluation groupEvaluation) {
            try {
                ServiceProviderFactory.this.hostApp.addUser(dir, ServiceProviderFactory.this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()), userRecipe.getName().getValue(), userRecipe.getEmail().getValue(), idpConfiguration.getFilteredGroupsForUser(usernameFromIdp, groupEvaluation.getAllIdpGroupNames(), ServiceProviderFactory.this.hostApp), true);
            }
            catch (UserAlreadyExistsException e) {
                log.warn("Was unable to create user {} with just-in-time provisioning because the user already exist locally. Make sure your user directores are synchronized. ", (Object)ServiceProviderFactory.this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()));
            }
        }

        public int getIssueInstantLifeTimeMs() {
            return 30000;
        }

        public boolean isForceAuthn(HttpServletRequestFacade request) {
            log.debug("WebSudo isForceAuthn queryString: {}", (Object)request.getQueryString());
            return this.isTest(request) && request.getParameter("force") != null || StringUtils.contains((CharSequence)request.getQueryString(), (CharSequence)"ForceAuthn=true");
        }

        public String getRelayState(HttpServletRequestFacade request, LogoutRequest logoutRequest) {
            return null;
        }

        public String getRelayState(HttpServletRequestFacade request, AuthnRequest authnRequest) {
            String target = request.getParameter("target");
            if (target != null) {
                return target.replaceAll(" ", "%20").replaceAll("~", "%7E");
            }
            if (this.isTest(request)) {
                try {
                    String authnRequestFormatted = XmlUtils.formatXml((Element)XMLObjectSupport.marshall((XMLObject)authnRequest));
                    ServiceProviderFactory.this.idpConfManager.recordTestStarted(this.idpConfiguration.getId(), authnRequest.getID(), authnRequestFormatted, ServiceProviderFactory.this.kerbConfManager.getRemoteIpAddress(request));
                }
                catch (MarshallingException e) {
                    throw new RuntimeException(e);
                }
                return "test";
            }
            return null;
        }

        public boolean isEncryptedAssertionsRequired() {
            return this.idpConfiguration.isEncryptedAssertionsRequired();
        }

        public boolean isSingleLogoutEnabled() {
            return this.idpConfiguration.isSingleLogoutEnabled();
        }

        public String getIdpSingleLogoutServiceURL() {
            return this.idpConfiguration.getSingleLogoutServiceURL();
        }

        private boolean isTest(SamlResponseValidationResult result) {
            return "test".equals(result.getRelayState());
        }

        private boolean isTest(HttpServletRequestFacade request) {
            return TestUtils.isTest(request);
        }
    }
}

