/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.gsuite;

import com.atlassian.json.jsonorg.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.kantega.atlaskerb.connector.AbstractConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSuiteHttpClient
extends AbstractConnectorHttpClient {
    private static final Logger log = LoggerFactory.getLogger(GSuiteHttpClient.class);
    private final String apiBaseUrl;
    private final String adminAccountAddress;
    private final String serviceAccountId;
    private final PrivateKey privateKey;

    GSuiteHttpClient(String apiBaseUrl, String adminAccountAddress, String serviceAccountId, String privateKey) {
        this.apiBaseUrl = apiBaseUrl;
        this.adminAccountAddress = adminAccountAddress;
        this.serviceAccountId = serviceAccountId;
        this.privateKey = this.loadKey(privateKey);
    }

    public org.json.JSONObject asJson() {
        org.json.JSONObject json = new org.json.JSONObject();
        json.put("apiBaseUrl", (Object)this.apiBaseUrl);
        json.put("adminAccountAddress", (Object)this.adminAccountAddress);
        json.put("serviceAccountId", (Object)this.serviceAccountId);
        json.put("privateKey", (Object)"***");
        return json;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ConnectorHttpClient.AuthContext createAuthContext() throws InterruptedException {
        try {
            String jwt = this.createSignedJwt();
            String loginService = this.apiBaseUrl + "/oauth2/v4/token";
            log.debug("Connecting to {}", (Object)loginService);
            HttpURLConnection con = ConnectorIOUtil.openConnection(loginService);
            con.setDoOutput(true);
            con.setDoInput(true);
            StringBuilder sb = new StringBuilder().append("grant_type=").append(URLEncoder.encode("urn:ietf:params:oauth:grant-type:jwt-bearer", StandardCharsets.UTF_8.name())).append("&assertion=").append(jwt);
            try (OutputStream outputStream = con.getOutputStream();){
                IOUtils.write((String)sb.toString(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            }
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                this.throwJsonException(con);
                return null;
            }
            try (InputStream inputStream = con.getInputStream();){
                JSONObject resp = new JSONObject(ConnectorIOUtil.toString(inputStream, StandardCharsets.UTF_8.name()));
                String accessToken = resp.getString("access_token");
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Bearer " + accessToken);
                headers.put("Accept", "application/json");
                log.debug("Created new Google Workspace access token");
                ConnectorHttpClient.AuthContext authContext = new ConnectorHttpClient.AuthContext(headers);
                return authContext;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String createSignedJwt() {
        try {
            JSONObject header = new JSONObject();
            header.put("alg", (Object)"RS256");
            header.put("typ", (Object)"JWT");
            JSONObject claimSet = new JSONObject();
            claimSet.put("iss", (Object)this.serviceAccountId);
            claimSet.put("scope", (Object)"https://www.googleapis.com/auth/admin.directory.group https://www.googleapis.com/auth/admin.directory.user");
            claimSet.put("sub", (Object)this.adminAccountAddress);
            claimSet.put("aud", (Object)"https://www.googleapis.com/oauth2/v4/token");
            claimSet.put("exp", System.currentTimeMillis() / 1000L + 3540L);
            claimSet.put("iat", System.currentTimeMillis() / 1000L);
            Base64 base64 = new Base64(-1, null, true);
            String input = base64.encodeAsString(header.toString().getBytes(StandardCharsets.UTF_8)) + "." + base64.encodeAsString(claimSet.toString().getBytes(StandardCharsets.UTF_8));
            Signature rsaSignature = Signature.getInstance("SHA256withRSA");
            rsaSignature.initSign(this.privateKey);
            rsaSignature.update(input.getBytes(StandardCharsets.UTF_8));
            byte[] signed = rsaSignature.sign();
            return input + "." + base64.encodeAsString(signed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKey loadKey(String privateKey) {
        String begin = "-----BEGIN PRIVATE KEY-----";
        String end = "-----END PRIVATE KEY-----";
        try {
            if (privateKey.startsWith(begin)) {
                privateKey = privateKey.substring(begin.length());
            }
            if (privateKey.endsWith(end)) {
                privateKey = privateKey.substring(0, privateKey.length() - end.length());
            }
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception loading keystore", e);
        }
    }

    @Override
    protected void waitForRateLimit(HttpURLConnection conn) {
        throw new RuntimeException("Rate limiting not supported for Google Workspace connector");
    }
}

