/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.kantegasso.servlet.ServletOutputStreamFacade;
import com.kantegasso.servlet.http.HttpServletFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class GetIdpIconServlet
extends HttpServletFacade {
    private final IdpConfManager idpConfManager;
    private final HomeDirectoryResolver homeDirectoryResolver;
    private final Logger log = LoggerFactory.getLogger(GetIdpIconServlet.class);

    @Inject
    public GetIdpIconServlet(RequireAdminServletDependencyBucket bucket) {
        this.idpConfManager = bucket.getIdpConfManager();
        this.homeDirectoryResolver = bucket.getKerbConfManager().getHomeDirectoryResolver();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        try {
            this.findAndProvideIdpIcon(resp, configuration, id);
        }
        catch (IOException e) {
            try {
                resp.setContentType("text/html");
                resp.sendError(404);
            }
            catch (IOException ex) {
                this.log.error("Error while sending error response", (Throwable)ex);
            }
        }
    }

    private void findAndProvideIdpIcon(HttpServletResponseFacade resp, IdpConfiguration configuration, String id) throws IOException {
        if (configuration == null) {
            resp.setContentType("text/html");
            resp.sendError(404);
            return;
        }
        ServletOutputStreamFacade out = resp.getOutputStreamFacade();
        File[] iconDirectory = new File(String.valueOf(this.homeDirectoryResolver.getHomeDirectory()) + "/idp-icons/").listFiles(pathname -> pathname.toString().contains(id));
        if (iconDirectory != null && iconDirectory.length > 0) {
            String iconPath = iconDirectory[0].toString();
            String fileExtension = iconPath.substring(iconPath.lastIndexOf(".") + 1);
            String imageType = "svg".equals(fileExtension) ? "svg+xml" : fileExtension;
            resp.setContentType("image/" + imageType);
            try (FileInputStream fin = new FileInputStream(iconPath);){
                this.writeInputStreamToOutputStream(out, fin);
            }
        }
        String iconPath = "/images/svg/" + String.valueOf((Object)configuration.getKind()) + ".svg";
        String imageType = "svg+xml";
        resp.setContentType("image/" + imageType);
        try (InputStream fin = ((Object)((Object)this)).getClass().getResourceAsStream(iconPath);){
            this.writeInputStreamToOutputStream(out, fin);
        }
    }

    private void writeInputStreamToOutputStream(ServletOutputStreamFacade out, InputStream fin) throws IOException {
        try (BufferedInputStream bin = new BufferedInputStream(fin);
             BufferedOutputStream bout = new BufferedOutputStream((OutputStream)out);){
            int ch = 0;
            while ((ch = bin.read()) != -1) {
                bout.write(ch);
            }
            bin.close();
            fin.close();
            bout.close();
            out.close();
        }
    }
}

