/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class IdpKnownDomainsServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final Set<String> tabs = new HashSet<String>(Arrays.asList("location", "accounts", "domains", "idpsetup"));

    @Inject
    public IdpKnownDomainsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        String tab = req.getParameter("tab");
        if (tab != null && this.tabs.contains(tab)) {
            model.put("activeTab", tab);
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "domains");
        model.put("idp", configuration);
        model.put("ssoProtocol", (Object)configuration.getProtocol());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("allowedDomains", this.idpConfManager.commaSeparated(configuration.getKnownDomains()));
        model.put("hostedDomainEnabled", configuration.isHostedDomain());
        this.hostApp.getAnonymousBrowsingSettingsUrl().map(relativePath -> this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + relativePath).peek(_url -> model.put("hostAppSupportsAnonymousBrowsing", true)).peek(url -> model.put("anonymousBrowsingSettingsUrl", url));
        this.getTemplateRenderer().render("templates/saml/saml-idp-known-domains.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(id);
        String usernamePolicyParam = req.getParameter("usernamePolicy");
        IdpConfiguration.UsernamePolicy usernamePolicy = (IdpConfiguration.UsernamePolicy)((Object)Try.of((CheckedFunction0 & Serializable)() -> IdpConfiguration.UsernamePolicy.valueOf(usernamePolicyParam)).getOrElse((Object)existing.getUsernamePolicy()));
        String knownDomainsParam = req.getParameter("knownDomains");
        LinkedHashSet<String> knownDomains = this.parseSet(knownDomainsParam);
        boolean hostedDomainEnabled = "on".equals(req.getParameter("hostedDomainEnabled"));
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(existing);
        builder.setUsernamePolicy(usernamePolicy);
        builder.setKnownDomains(knownDomains);
        builder.setHostedDomain(hostedDomainEnabled);
        StringBuffer queryString = new StringBuffer();
        HttpUrlUtils.keepQueryParameterFromRequest((StringBuffer)queryString, (String)"backUrl", (HttpServletRequestFacade)req);
        HttpUrlUtils.keepQueryParameterFromRequest((StringBuffer)queryString, (String)"backLinkDescription", (HttpServletRequestFacade)req);
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        resp.sendRedirect("domains" + String.valueOf(queryString));
    }

    private LinkedHashSet<String> parseSet(String defaultGroupsParam) {
        LinkedHashSet<String> defaultGroups = new LinkedHashSet<String>();
        if (defaultGroupsParam != null) {
            for (String g : defaultGroupsParam.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                defaultGroups.add(g);
            }
        }
        return defaultGroups;
    }
}

