/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.usercleanup;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import org.kantega.atlaskerb.cleanup.InactiveUserCleaner;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupExecuteStatus;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupExecuteStatusAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.CleanupLogAttributes;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.jsoncreatorclasses.UserCleanupResult;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="get-cleanup-status")
@PublicApi
public class GetExecutionStatus {
    private static final Logger log = LoggerFactory.getLogger(GetExecutionStatus.class);
    UserManager userManager;
    HostApp hostApp;
    JsonWrapper jsonWrapper;

    @Inject
    public GetExecutionStatus(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, JsonWrapper jsonWrapper) {
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.jsonWrapper = jsonWrapper;
    }

    private Response run(UserProfile userProfile, UserManager userManager, CleanupExecuteStatusAttributes executeStatusAttributes) {
        if (!userManager.isSystemAdmin(userProfile.getUserKey())) {
            return ResponseUtils.errorWithMessageInJson(Response.Status.FORBIDDEN, "Missing access privileges");
        }
        boolean isJsmCleanup = executeStatusAttributes.getIsJsmCleanup();
        InactiveUserCleaner.CleanupStatus cleanupExecuteStatus = isJsmCleanup ? this.hostApp.getJsmCleanupExecuteStatus() : this.hostApp.getUserCleanupExecuteStatus();
        CleanupLogAttributes cleanupLogAttributes = new CleanupLogAttributes(5, false, true, true, isJsmCleanup, false);
        UserCleanupResult[] userCleanupLog = this.hostApp.getInactiveUserCleaner().getCleanupLog(cleanupLogAttributes);
        CleanupExecuteStatus status = new CleanupExecuteStatus(cleanupExecuteStatus, userCleanupLog, isJsmCleanup ? this.hostApp.getJsmCleanupLastRunId() : this.hostApp.getUserCleanupLastRunId());
        return (Response)this.jsonWrapper.tryBuildJsonString(status).map(jsonString -> Response.ok((Object)jsonString, (MediaType)MediaType.APPLICATION_JSON_TYPE).build()).onFailure(throwable -> log.error("Failed to build JSON: ", throwable)).getOrElse((Object)Response.serverError().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest request, CleanupExecuteStatusAttributes executeStatusAttributes) {
        return ResponseUtils.user(HttpServletRequestFacade.of((HttpServletRequest)request), this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)userProfile -> (Response)Try.of((CheckedFunction0 & Serializable)() -> this.run((UserProfile)userProfile, this.userManager, executeStatusAttributes)).onFailure(e -> log.error("Encountered an exception while attempting to GET cleanup execution status. ", e)).getOrElse((Object)Response.serverError().build()));
    }
}

