/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.HttpSessionFacade;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.atlassian.auth.BearerTokenCredentials;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import io.vavr.API;
import io.vavr.Function4;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;

public class SetupScimAction
extends RequireAdminServlet {
    private static final List<String> steps = API.List((Object[])new String[]{"network", "tenant", "idp"});
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final ScimConfManager scimConfManager;

    public SetupScimAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.scimConfManager = bucket.getScimConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String tenantId = (String)Option.of((Object)req.getParameter("tenantId")).getOrElse(() -> this.scimConfManager.nextId());
        SetupScimWizardState scimWizardState = (SetupScimWizardState)SetupScimWizardState.loadFromSession(HttpSessionFacade.of((HttpSession)req.getSession()), tenantId).getOrElse(() -> SetupScimWizardState.newWizardState(tenantId, this.scimConfManager.nextPassword(), ScimProviderKind.valueOf((String)req.getParameter("kind"))));
        SetupScimWizardState.storeInSession(HttpSessionFacade.of((HttpSession)req.getSession()), scimWizardState);
        Map<String, Object> model = this.newModel(req, scimWizardState);
        this.renderPage(req, resp, model);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        String tenantId = req.getParameter("tenantId");
        SetupScimWizardState wizardState = (SetupScimWizardState)SetupScimWizardState.loadFromSession(HttpSessionFacade.of((HttpSession)req.getSession()), tenantId).getOrElseThrow(() -> new IllegalStateException("No wizard state is stored in session"));
        String currentStep = wizardState.step;
        Map<String, Object> model = this.newModel(req, wizardState);
        if (currentStep.equals("network")) {
            if (this.hasParameter(req, "cancel")) {
                SetupScimWizardState.removeFromSession(HttpSessionFacade.of((HttpSession)req.getSession()), wizardState.tenantId);
                try {
                    this.scimConfManager.deleteScimDirectoryAndTenantConfig(tenantId);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                resp.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/dashboard");
            } else if (this.hasParameter(req, "next")) {
                boolean scimBaseUrlEndpointEnabled = "on".equals(req.getParameter("scimBaseUrlEndpointEnabled"));
                this.scimConfManager.setscimBaseUrlEndpointEnabled(scimBaseUrlEndpointEnabled);
                SetupScimWizardState next = wizardState.nextStep();
                SetupScimWizardState.storeInSession(HttpSessionFacade.of((HttpSession)req.getSession()), next);
                this.reload(resp, tenantId);
            }
        } else if (currentStep.equals("tenant")) {
            SetupScimWizardState updatedState = wizardState.withName(StringUtils.trim((String)req.getParameter("directoryName"))).withSecret(req.getParameter("applicationSecret"));
            this.updateModel(model, updatedState);
            if (updatedState.validate().size() > 0) {
                this.addValidation(model, updatedState);
                this.renderPage(req, resp, model);
            } else if (this.hasParameter(req, "cancel")) {
                SetupScimWizardState.removeFromSession(HttpSessionFacade.of((HttpSession)req.getSession()), updatedState.tenantId);
                resp.sendRedirect(this.scimConfManager.getSCIMConfigUrl(req));
            } else if (this.hasParameter(req, "back")) {
                SetupScimWizardState next = updatedState.prevStep();
                SetupScimWizardState.storeInSession(HttpSessionFacade.of((HttpSession)req.getSession()), next);
                this.reload(resp, tenantId);
            } else {
                SetupScimWizardState next = updatedState.nextStep();
                SetupScimWizardState.storeInSession(HttpSessionFacade.of((HttpSession)req.getSession()), next);
                String salt = this.scimConfManager.nextId();
                BearerTokenCredentials saltedSecret = BearerTokenCredentials.createHash((String)salt, (String)updatedState.secret);
                ScimTenantConfig cfg = new ScimTenantConfig(tenantId, updatedState.directoryName, (Credentials)saltedSecret, ScimAuthMethod.BEARER, updatedState.kind, false, false);
                if (SetupScimAction.directoryNameExistsAlready(null, updatedState.directoryName, this.scimConfManager, this.hostApp)) {
                    model.put("nameExistsAlready", true);
                    model.put("step", currentStep);
                    SetupScimWizardState.storeInSession(HttpSessionFacade.of((HttpSession)req.getSession()), updatedState);
                    this.renderPage(req, resp, model);
                    return;
                }
                this.scimConfManager.saveOrUpdate(cfg);
                this.reload(resp, tenantId);
            }
        } else if (this.hasParameter(req, "back")) {
            this.scimConfManager.deleteScimDirectoryAndTenantConfig(wizardState.tenantId);
            SetupScimWizardState next = wizardState.prevStep();
            SetupScimWizardState.storeInSession(HttpSessionFacade.of((HttpSession)req.getSession()), next);
            this.reload(resp, tenantId);
        } else {
            SetupScimWizardState.removeFromSession(HttpSessionFacade.of((HttpSession)req.getSession()), wizardState.tenantId);
            resp.sendRedirect("directory/" + tenantId);
        }
    }

    public static boolean directoryNameExistsAlready(ScimDirectory existingDirectory, String newDirectoryName, ScimConfManager scimConfManager, HostApp hostApp) {
        ScimDirectory foundDir = (ScimDirectory)scimConfManager.getScimDirectories().filter(d -> newDirectoryName.equalsIgnoreCase(d.getTenantName())).getOrNull();
        if (foundDir == null) {
            return SetupScimAction.isExistingAtlassianUserDirectory(newDirectoryName, hostApp);
        }
        if (existingDirectory != null) {
            return SetupScimAction.isTheSameScimDirectory(existingDirectory, foundDir);
        }
        return true;
    }

    private static boolean isTheSameScimDirectory(ScimDirectory existingDirectory, ScimDirectory foundDir) {
        return foundDir.getDirectoryId() != existingDirectory.getDirectoryId();
    }

    private static boolean isExistingAtlassianUserDirectory(String newDirectoryName, HostApp hostApp) {
        try {
            return hostApp.getDirectoryManager().findDirectoryByName("SCIM: " + newDirectoryName) != null;
        }
        catch (DirectoryNotFoundException e) {
            return false;
        }
    }

    private Map<String, Object> newModel(HttpServletRequestFacade req, SetupScimWizardState state) {
        Map<String, Object> model = this.newModel(req);
        model.remove("topMenu");
        return this.updateModel(model, state);
    }

    private Map<String, Object> updateModel(Map<String, Object> model, SetupScimWizardState state) {
        ScimVersion version = this.getScimVersion(state.kind);
        model.put("tenantId", state.tenantId);
        model.put("kind", state.kind);
        model.put("kindName", state.kind.getName());
        model.put("directoryName", state.directoryName);
        model.put("applicationSecret", state.secret);
        model.put("step", state.step);
        model.put("scimApiServerEndpoint", this.scimConfManager.getApiServerEndpoint(state.tenantId, version));
        model.put("scimBaseUrlEndpoint", this.scimConfManager.getBaseUrlEndpoint(state.tenantId, version));
        model.put("scimBaseUrlEndpointEnabled", this.scimConfManager.isScimBaseUrlEndpointEnabled());
        return model;
    }

    private ScimVersion getScimVersion(ScimProviderKind kind) {
        if (kind == ScimProviderKind.OKTA_V1) {
            return ScimVersion.V1_1;
        }
        return ScimVersion.V2_0;
    }

    private Map<String, Object> addValidation(Map<String, Object> model, SetupScimWizardState state) {
        model.put("missingFields", state.validate());
        return model;
    }

    private boolean hasParameter(HttpServletRequestFacade req, String param) {
        return req.getParameter(param) != null;
    }

    private void reload(HttpServletResponseFacade resp, String tenantId) throws IOException {
        resp.sendRedirect("setup-scim?tenantId=" + tenantId);
    }

    private void renderPage(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        model.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        try {
            this.templateRenderer.render("templates/atlaskerb/scim/setup-scim.vm", model, (Writer)resp.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean expectsMultipart() {
        return false;
    }

    static class SetupScimWizardState {
        public final String tenantId;
        public final String directoryName;
        public final String secret;
        public final ScimProviderKind kind;
        public final String step;

        SetupScimWizardState(String tenantId, String directoryName, String secret, ScimProviderKind kind, String step) {
            this.tenantId = tenantId;
            this.directoryName = directoryName;
            this.secret = secret;
            this.kind = kind;
            this.step = step;
        }

        public static void storeInSession(HttpSessionFacade session, SetupScimWizardState state) {
            session.setAttribute(state.tenantId + ".name", (Object)state.directoryName);
            session.setAttribute(state.tenantId + ".secret", (Object)state.secret);
            session.setAttribute(state.tenantId + ".step", (Object)state.step);
            session.setAttribute(state.tenantId + ".kind", (Object)state.kind.name());
        }

        public static Option<SetupScimWizardState> loadFromSession(HttpSessionFacade session, String tenantId) {
            Option maybeName = Option.of((Object)((String)session.getAttribute(tenantId + ".name")));
            Option maybeSecret = Option.of((Object)((String)session.getAttribute(tenantId + ".secret")));
            Option maybeKind = Option.of((Object)((String)session.getAttribute(tenantId + ".kind"))).map(s -> ScimProviderKind.valueOf((String)s));
            Option maybeStep = Option.of((Object)((String)session.getAttribute(tenantId + ".step")));
            return API.For((Option)maybeName, (Option)maybeSecret, (Option)maybeKind, (Option)maybeStep).yield((Function4 & Serializable)(name, secret, kind, step) -> new SetupScimWizardState(tenantId, (String)name, (String)secret, (ScimProviderKind)kind, (String)step));
        }

        public static void removeFromSession(HttpSessionFacade session, String tenantId) {
            session.removeAttribute(tenantId + ".name");
            session.removeAttribute(tenantId + ".secret");
            session.removeAttribute(tenantId + ".kind");
            session.removeAttribute(tenantId + ".step");
        }

        public static SetupScimWizardState newWizardState(String tenantId, String applicationSecret, ScimProviderKind kind) {
            return new SetupScimWizardState(tenantId, kind.getName(), applicationSecret, kind, (String)steps.head());
        }

        public SetupScimWizardState withName(String name) {
            return new SetupScimWizardState(this.tenantId, (String)Option.of((Object)name).getOrElse((Object)""), this.secret, this.kind, this.step);
        }

        public SetupScimWizardState withSecret(String secret) {
            return new SetupScimWizardState(this.tenantId, this.directoryName, (String)Option.of((Object)secret).getOrElse((Object)""), this.kind, this.step);
        }

        public SetupScimWizardState nextStep() {
            return new SetupScimWizardState(this.tenantId, this.directoryName, this.secret, this.kind, this.getNextStep(this.step));
        }

        public SetupScimWizardState prevStep() {
            return new SetupScimWizardState(this.tenantId, this.directoryName, this.secret, this.kind, this.getPreviousStep(this.step));
        }

        public Map<String, String> validate() {
            TreeMap<String, String> validationInfo = new TreeMap<String, String>();
            if (StringUtils.isBlank((CharSequence)this.directoryName)) {
                validationInfo.put("directoryName", "missing");
            }
            if (StringUtils.isBlank((CharSequence)this.secret)) {
                validationInfo.put("applicationSecret", "missing");
            }
            if (StringUtils.length((CharSequence)this.secret) < 6) {
                validationInfo.put("applicationSecret", "tooshort");
            }
            return validationInfo;
        }

        private String getPreviousStep(String step) {
            return ((String)steps.head()).equals(step) ? (String)steps.head() : (String)steps.get(steps.indexOf((Object)step) - 1);
        }

        private String getNextStep(String step) {
            return ((String)steps.last()).equals(step) ? (String)steps.last() : (String)steps.get(steps.indexOf((Object)step) + 1);
        }
    }
}

