/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jobs;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.cache.KerberosUserLookupFromFileCache;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KerberosUserLookupFromFileRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(String.valueOf(KerberosUserLookupFromFileRunner.class) + ".job"));
    private final KerberosUserLookupFromFileCache kerberosUserLookupFromFileCache;
    private final HostApp hostApp;
    private static final Logger log = LoggerFactory.getLogger(KerberosUserLookupFromFileRunner.class);
    private final KerbConfManager kerbConfManager;

    @Inject
    public KerberosUserLookupFromFileRunner(KerberosUserLookupFromFileCache kerberosUserLookupFromFileCache, HostAppFactory hostAppFactory, KerbConfManager kerbConfManager) {
        this.kerberosUserLookupFromFileCache = kerberosUserLookupFromFileCache;
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = kerbConfManager;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (this.kerbConfManager.isLookupUsernameFromMappingFile()) {
            try {
                this.kerberosUserLookupFromFileCache.tryReadCacheFile(this.hostApp.getHomeDirectory());
                return JobRunnerResponse.success();
            }
            catch (Exception e) {
                log.error("Exception reading kerberosUserLookupFromFileCache", (Throwable)e);
                return JobRunnerResponse.failed((String)("Exception when reading kerberosUserLookupFromFileCache: " + String.valueOf(e.getClass()) + ": " + e.getMessage()));
            }
        }
        return JobRunnerResponse.aborted((String)"Kerberos user lookup from file is not enabled");
    }
}

