/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.backup.BackupService;

public class CreateBackupAction
extends RequireAdminServlet {
    private final BackupService backupService;
    private final TemplateRenderer renderer;

    @Inject
    public CreateBackupAction(RequireAdminServletDependencyBucket bucket, BackupService backupService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.backupService = backupService;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.renderPage(resp, model);
    }

    private void renderPage(HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("topMenu", "dashboard");
        model.put("menuItem", "backup");
        this.renderer.render("templates/atlaskerb/backup/create-backup.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        if (req.getParameter("create") != null) {
            this.backupService.createBackup(req.getParameter("description"));
        }
        resp.sendRedirect("backup");
    }
}

