/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade.configuration;

import io.vavr.collection.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.model.AssignGroupRule;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.kantega.atlaskerb.utils.Version;

public class IdpConfigurationUpgrade {
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final Version versionWithRefactoredAssignGroupsAndManagedGroups = new Version("6.33.0");
    private final Version platform7VersionWithRefactoredAssignGroupsAndManagedGroups = new Version("7.33.0");

    public IdpConfigurationUpgrade(IdpConfManager idpConfManager, KerbConfManager kerbConfManager) {
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
    }

    public List<UpgradeMessage> run() {
        return List.of((Object)this.updateIdpConfigurations());
    }

    public static IdpConfiguration.UserUpdateNamePolicy convertNamePolicyFromOldConfig(String deprecatedUserUpdatePolicyName, String userUpdateNamePolicyName) {
        if (StringUtils.isBlank((CharSequence)userUpdateNamePolicyName)) {
            if (StringUtils.isNotBlank((CharSequence)deprecatedUserUpdatePolicyName)) {
                IdpConfiguration.UserUpdatePolicy userUpdatePolicy = IdpConfiguration.UserUpdatePolicy.valueOf(deprecatedUserUpdatePolicyName);
                return userUpdatePolicy == IdpConfiguration.UserUpdatePolicy.UPDATE ? IdpConfiguration.UserUpdateNamePolicy.UPDATE_NAME : IdpConfiguration.UserUpdateNamePolicy.NONE;
            }
            return IdpConfiguration.UserUpdateNamePolicy.NONE;
        }
        return IdpConfiguration.UserUpdateNamePolicy.valueOf(userUpdateNamePolicyName);
    }

    public static IdpConfiguration.UserUpdateEmailPolicy convertEmailPolicyFromOldConfig(String deprecatedUserUpdatePolicyName, String userUpdateEmailPolicyName) {
        if (StringUtils.isBlank((CharSequence)userUpdateEmailPolicyName)) {
            if (StringUtils.isNotBlank((CharSequence)deprecatedUserUpdatePolicyName)) {
                IdpConfiguration.UserUpdatePolicy userUpdatePolicy = IdpConfiguration.UserUpdatePolicy.valueOf(deprecatedUserUpdatePolicyName);
                return userUpdatePolicy == IdpConfiguration.UserUpdatePolicy.UPDATE ? IdpConfiguration.UserUpdateEmailPolicy.UPDATE_EMAIL : IdpConfiguration.UserUpdateEmailPolicy.NONE;
            }
            return IdpConfiguration.UserUpdateEmailPolicy.NONE;
        }
        return IdpConfiguration.UserUpdateEmailPolicy.valueOf(userUpdateEmailPolicyName);
    }

    public static Set<AssignGroupRule> updateFromDefaultGroupsToAssignGroupRules(Set<AssignGroupRule> assignGroupRules, Set<String> defaultGroups, Map<String, String> defaultGroupsRules) {
        if (assignGroupRules.isEmpty() && !defaultGroups.isEmpty()) {
            for (String group : defaultGroups) {
                String usernameRegex = defaultGroupsRules.get(group);
                assignGroupRules.add(new AssignGroupRule(null, usernameRegex, group));
            }
        }
        return assignGroupRules;
    }

    public static java.util.List<ManagedGroup> updateManagedGroupsRequiredForJITCreation(boolean createAllIncomingGroups, boolean atLeastOneManagedGroupRequiredForJITCreation, java.util.List<ManagedGroup> managedGroups) {
        if (!createAllIncomingGroups && atLeastOneManagedGroupRequiredForJITCreation && managedGroups != null) {
            return new ArrayList<ManagedGroup>(managedGroups);
        }
        return null;
    }

    private void updateProviderXml() {
        Collection<IdpConfiguration> configs = this.idpConfManager.getIdentityProviders();
        for (IdpConfiguration c : configs) {
            this.idpConfManager.updateIdpConfiguration(c);
        }
    }

    @NotNull
    public UpgradeMessage updateIdpConfigurations() {
        if (this.isBreakingChangesForProviderXml()) {
            this.updateProviderXml();
            new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Successfully upgraded Kantega SSO Enterprise Idp config.");
        }
        return new UpgradeMessage(KssoUpgradeManager.ResultCode.SUCCESS, "Nothing to upgrade");
    }

    public boolean isBreakingChanges() {
        return this.isBreakingChangesForProviderXml();
    }

    public boolean isBreakingChangesBetween(Version from, Version to) {
        if (from == null || to == null) {
            return false;
        }
        List versionsWithBreakingChanges = List.of((Object[])new Version[]{this.platform7VersionWithRefactoredAssignGroupsAndManagedGroups, this.versionWithRefactoredAssignGroupsAndManagedGroups});
        for (Version versionWithBreakingChanges : versionsWithBreakingChanges) {
            if (!from.isLowerThan(versionWithBreakingChanges) || !to.isHigherThanOrEqualTo(versionWithBreakingChanges)) continue;
            return true;
        }
        return false;
    }

    private boolean isBreakingChangesForProviderXml() {
        Version currentConfigVersion = (Version)this.kerbConfManager.getSavedKssoConfigVersion().getOrNull();
        if (currentConfigVersion == null) {
            return true;
        }
        if (currentConfigVersion.getMajor() == 6) {
            return this.versionWithRefactoredAssignGroupsAndManagedGroups.isHigherThan(currentConfigVersion);
        }
        if (currentConfigVersion.getMajor() == 7) {
            return this.platform7VersionWithRefactoredAssignGroupsAndManagedGroups.isHigherThan(currentConfigVersion);
        }
        return false;
    }
}

