/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc.evaluation;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.UserProperty;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.enums.UsernameAttribute;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OidcResponseEvaluator
extends ResponseEvaluator {
    private final Logger log = LoggerFactory.getLogger(OidcResponseEvaluator.class);

    @Inject
    public OidcResponseEvaluator(@ComponentImport UserManager userManager, HostAppFactory hostApp, UserLookupService userLookupService) {
        super(userManager, userLookupService, hostApp);
    }

    public List<AttributeInfo> getAttributeInfos(JSONObject profileJson, List<Pair<UsernameAttribute, String>> usernameAttributePriority) {
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        for (String key : profileJson.keySet()) {
            try {
                if (key.equals("id_token")) continue;
                Object value = profileJson.get(key);
                if (OidcResponseEvaluator.isUsernameAttribute(key)) {
                    attributeInfos.add(new AttributeInfo(key, value.toString(), UsernameAttribute.valueOf(key.toUpperCase())));
                    continue;
                }
                if (OidcResponseEvaluator.isCustomUsernameAttribute(usernameAttributePriority, key)) {
                    if (value instanceof JSONArray && ((JSONArray)value).length() == 1) {
                        JSONArray array = (JSONArray)value;
                        attributeInfos.add(new AttributeInfo(key, array.get(0).toString(), UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME));
                        continue;
                    }
                    attributeInfos.add(new AttributeInfo(key, value.toString(), UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME));
                    continue;
                }
                attributeInfos.add(new AttributeInfo(key, profileJson.get(key).toString()));
            }
            catch (Exception e) {
                this.log.error("Analysis of username attribute claim failed. Adding generic attribute", (Throwable)e);
                attributeInfos.add(new AttributeInfo(key, profileJson.get(key).toString()));
            }
        }
        return attributeInfos;
    }

    private static boolean isCustomUsernameAttribute(List<Pair<UsernameAttribute, String>> usernameAttributePriority, String key) {
        for (Pair<UsernameAttribute, String> pair : usernameAttributePriority) {
            if (pair.getLeft() != UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME || !StringUtils.equals((CharSequence)((CharSequence)pair.getRight()), (CharSequence)key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsernameAttribute(String key) {
        UsernameAttribute[] usernameAttributes;
        for (UsernameAttribute u : usernameAttributes = UsernameAttribute.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)u.name(), (CharSequence)key)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<String> findIdpGroups(JSONObject profileJson, IdpConfiguration idpConfiguration) {
        Set<String> idpGroupParameters = idpConfiguration.getIdpGroupsAttributes();
        HashSet<String> appGroupAssertions = new HashSet<String>();
        for (String gp : idpGroupParameters) {
            try {
                appGroupAssertions.addAll(profileJson.getJSONArray(gp).toList().stream().map(Object::toString).collect(Collectors.toList()));
            }
            catch (JSONException jSONException) {}
        }
        return appGroupAssertions;
    }

    public OidcResponseEvaluationResult evaluate(OidcIdpConfiguration idpConfiguration, JSONObject profile, boolean addDefaultGroups) {
        String nameAttribute;
        List<AttributeInfo> attributeInfos = this.getAttributeInfos(profile, idpConfiguration.getUsernameAttributePriority());
        OidcResponseEvaluationResult result = new OidcResponseEvaluationResult(idpConfiguration, attributeInfos, idpConfiguration.getUsernameAttributePriority(), idpConfiguration.getNameAttributeMapping());
        Either<String, UserRecipe> maybeUserRecipe = this.findUserRecipe(profile, result, nameAttribute = OidcResponseEvaluator.extractNameAttribute(idpConfiguration), idpConfiguration.getCustomEmailAttribute());
        if (maybeUserRecipe.isLeft()) {
            return OidcResponseEvaluationResult.Builder.of(result).setErrorMessage((String)maybeUserRecipe.getLeft()).build();
        }
        return (OidcResponseEvaluationResult)this.evaluateResult(idpConfiguration, result, (UserRecipe)maybeUserRecipe.get(), addDefaultGroups).map(res -> this.evaluateOidcGroups(idpConfiguration, profile, (FederatedIdentityResponseEvaluationResult)res)).mapTry(OidcResponseEvaluationResult.class::cast).onFailure(t -> this.log.warn(ErrorUtils.createErrorMessage((String)"KSSO-YU1EL3NDA9", (String)"Failed to complete response evaluation"), t)).getOrElse((Object)OidcResponseEvaluationResult.Builder.of(result).setErrorMessage(ErrorUtils.createErrorMessage((String)"KSSO-YU1EL3NDA9", (String)"Failed to complete response evaluation")).build());
    }

    @Nullable
    private static String extractNameAttribute(OidcIdpConfiguration idpConfiguration) {
        Object nameAttributes = null;
        if (IdpConfManager.NAME_ATTRIBUTE_MAPPING.FIRST_AND_LAST_NAME.equals((Object)idpConfiguration.getNameAttributeMapping())) {
            String surnameAttribute = idpConfiguration.getCustomSurnameAttribute();
            String givenNameAttribute = idpConfiguration.getCustomGivenNameAttribute();
            if (givenNameAttribute != null && surnameAttribute != null) {
                nameAttributes = givenNameAttribute + ", " + surnameAttribute;
            } else if (surnameAttribute != null) {
                nameAttributes = surnameAttribute;
            } else if (givenNameAttribute != null) {
                nameAttributes = givenNameAttribute;
            }
        } else {
            nameAttributes = idpConfiguration.getCustomNameAttribute();
        }
        return nameAttributes;
    }

    private FederatedIdentityResponseEvaluationResult evaluateOidcGroups(OidcIdpConfiguration idpConfiguration, JSONObject profile, FederatedIdentityResponseEvaluationResult res) {
        this.evaluateGroups(res.getSearchedUsername(), idpConfiguration.getManagedGroups(), this.findIdpGroups(profile, idpConfiguration), res.getGroupEvaluation());
        return res;
    }

    private Either<String, UserRecipe> findUserRecipe(JSONObject profileJson, OidcResponseEvaluationResult result, String nameAttribute, String emailAttribute) {
        if (Option.of((Object)result).isEmpty()) {
            return Either.left((Object)ErrorUtils.createErrorMessage((String)"KSSO-WO2FBW6GQS", (String)"Could not find response evaluation result."));
        }
        if (Option.of((Object)profileJson).isEmpty()) {
            return Either.left((Object)ErrorUtils.createErrorMessage((String)"KSSO-Y86V7LN2MP", (String)"Invalid JSON while searching for user recipe."));
        }
        Option maybeConfiguredAttributeInfo = Option.of((Object)result.getConfiguredUsernameAttributeInfo());
        String searchedUsername = result.getSearchedUsername();
        if (maybeConfiguredAttributeInfo.isEmpty()) {
            return Either.left((Object)ErrorUtils.createErrorMessage((String)"KSSO-DI9HFISO0R", (String)"Failed to find configured username attribute."));
        }
        UserProperty username = (UserProperty)maybeConfiguredAttributeInfo.map(attributeInfo -> new UserProperty(attributeInfo.getId(), searchedUsername)).get();
        UserProperty name = null;
        if (nameAttribute != null) {
            String nameBuild = OidcResponseEvaluator.mergeNameAttributes(profileJson, nameAttribute);
            name = new UserProperty(nameAttribute, nameBuild);
        }
        UserProperty email = null;
        if (StringUtils.isNotBlank((CharSequence)emailAttribute) && profileJson.has(emailAttribute) && profileJson.get(emailAttribute) != null) {
            email = new UserProperty(emailAttribute, OidcResponseEvaluator.extractEmailAttribute(profileJson, emailAttribute));
        }
        return Either.right((Object)new UserRecipe(username, name, email));
    }

    static String mergeNameAttributes(JSONObject profileJson, String nameAttribute) {
        Object[] nameAttributes = StringUtils.split((String)nameAttribute, (String)",");
        String nameBuild = (String)io.vavr.collection.List.of((Object[])nameAttributes).filter(StringUtils::isNotBlank).map(StringUtils::trim).filter(attribute -> profileJson.has(attribute) && profileJson.get(attribute) != null).filter(attribute -> profileJson.get(attribute) instanceof String).map(attribute -> profileJson.get(attribute).toString()).filter(StringUtils::isNotBlank).intersperse((Object)" ").foldLeft((Object)"", String::concat);
        return nameBuild;
    }

    private static String extractEmailAttribute(JSONObject profileJson, String key) {
        Object value = profileJson.get(key);
        if (StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)"email") && value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            value = array.get(0);
        }
        return value.toString();
    }

    public Set<String> findOidcGroups(JSONObject profileJson, Set<String> groupsParameters) {
        HashSet<String> result = new HashSet<String>();
        for (String param : groupsParameters) {
            try {
                List groups = profileJson.getJSONArray(param).toList();
                for (Object group : groups) {
                    result.add(group.toString());
                }
            }
            catch (JSONException jSONException) {
            }
        }
        return result;
    }
}

