/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.websudo;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.sal.api.component.ComponentLocator;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.websudo.WebSudoServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketWebSudoServlet
extends WebSudoServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Method setWebSudoSessionMethod;
    private Object webSudoSessionService;

    @Autowired
    @Inject
    public BitbucketWebSudoServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.WEB_SUDO_SERVLET_URL = "bitbucketWebsudo";
        try {
            ClassLoader ccl = ((Object)((Object)this)).getClass().getClassLoader().getParent();
            if (ccl != null) {
                Class<?> webSudoSessionServiceClass = ccl.loadClass("com.atlassian.stash.internal.auth.websudo.WebSudoSessionService");
                this.setWebSudoSessionMethod = webSudoSessionServiceClass.getMethod("setWebSudoSession", HttpSession.class);
                this.webSudoSessionService = ComponentLocator.getComponent(webSudoSessionServiceClass);
            }
        }
        catch (Exception e) {
            this.log.error("Could not load WebSudoSessionService", (Throwable)e);
        }
    }

    @Override
    protected void startWebsudoSession(HttpServletRequestFacade req, HttpServletResponseFacade resp) {
        try {
            if (this.setWebSudoSessionMethod != null) {
                this.setWebSudoSessionMethod.invoke(this.webSudoSessionService, req.getSession());
                this.log.debug("Websudo session initiated via SSO");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.log.error("Could not initiate Websudo session", (Throwable)e);
        }
    }
}

