/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.model;

import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssignGroupRule {
    private final String requiredGroup;
    private final String usernameRegex;
    private final String assignGroup;

    public AssignGroupRule(String requiredGroup, String usernameRegex, String assignGroup) {
        this.requiredGroup = requiredGroup;
        this.usernameRegex = usernameRegex;
        this.assignGroup = assignGroup;
    }

    public AssignGroupRule(JSONObject json) {
        this.requiredGroup = json.optString("requiredGroup", null);
        this.usernameRegex = json.optString("usernameRegex", null);
        this.assignGroup = json.getString("assignGroup");
    }

    public AssignGroupRule(String json) {
        this(new JSONObject(json));
    }

    public String asJSON() {
        return new JSONObject().put("requiredGroup", (Object)this.requiredGroup).put("usernameRegex", (Object)this.usernameRegex).put("assignGroup", (Object)this.assignGroup).toString();
    }

    public static Set<AssignGroupRule> getAssignRulesFromJSONArray(JSONArray jsonArray) {
        HashSet<AssignGroupRule> ruleList = new HashSet<AssignGroupRule>();
        for (Object o : jsonArray) {
            JSONObject json = (JSONObject)o;
            ruleList.add(new AssignGroupRule(json));
        }
        return ruleList;
    }

    public static String getAssignRulesAsJSONArray(Set<AssignGroupRule> rules) {
        JSONArray jsonArray = new JSONArray();
        rules.forEach(rule -> jsonArray.put((Object)new JSONObject(rule.asJSON())));
        return jsonArray.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignGroupRule that = (AssignGroupRule)o;
        return this.hashCode() == that.hashCode();
    }

    public int hashCode() {
        return (this.requiredGroup + this.usernameRegex + this.assignGroup).hashCode();
    }

    public String getRequiredGroup() {
        return this.requiredGroup;
    }

    public String getUsernameRegex() {
        return this.usernameRegex;
    }

    public String getAssignGroup() {
        return this.assignGroup;
    }
}

