/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.upgrade;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.vavr.collection.List;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.upgrade.KssoUpgradeManager;
import org.kantega.atlaskerb.upgrade.data.UpgradeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class KssoUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(KssoUpgradeTask.class);
    private final KssoUpgradeManager kssoUpgradeManager;

    @Inject
    public KssoUpgradeTask(KssoUpgradeManager kssoUpgradeManager) {
        this.kssoUpgradeManager = kssoUpgradeManager;
    }

    public int getBuildNumber() {
        return KerbConfManager.getRunningKssoVersion().buildNumber();
    }

    public String getShortDescription() {
        return "Configuration upgrade routine for Kantega SSO Enterprise";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Running Kantega SSO Enterprise configuration upgrade task...");
        List<UpgradeMessage> messages = this.kssoUpgradeManager.doUpgrade();
        if (messages.forAll(UpgradeMessage::isSuccess)) {
            return new ArrayList<Message>();
        }
        return messages.filter(UpgradeMessage::isFailure).map(Message.class::cast).toJavaList();
    }

    public String getPluginKey() {
        return PluginKey.getPluginKey();
    }
}

