/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.wrapper.crowd.CrowdGroupWrapper;

public class DirectoryGroupsAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final ScimConfManager scimConfManager;

    @Inject
    public DirectoryGroupsAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostApp();
        this.scimConfManager = scimConfManager;
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String tenantId = req.getParameter("tenantId");
        String filter = req.getParameter("filter");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = (ScimDirectory)maybeDirectory.get();
        int startIndex = 0;
        if (req.getParameter("start-index") != null) {
            startIndex = Integer.parseInt(req.getParameter("start-index"));
        }
        model.put("currentScimDirectory", scimDirectory);
        model.put("topMenu", "connectors");
        model.put("menuItem", "scimDirectoryGroups");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("groupFilter", filter);
        Object filterRestriction = filter == null || filter.trim().isEmpty() ? NullRestrictionImpl.INSTANCE : new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)filter);
        this.render(scimDirectory.getDirectory(), resp, model, (SearchRestriction)filterRestriction, startIndex);
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String startIndex;
        String tenantId = req.getParameter("tenantId");
        String operation = req.getParameter("operation");
        String groupName = req.getParameter("groupName");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = (ScimDirectory)maybeDirectory.get();
        if ("deleteGroup".equals(operation)) {
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            try {
                directoryManager.removeGroup(scimDirectory.getDirectoryId(), groupName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String query = "?tenantId=" + tenantId;
        String filter = req.getParameter("filter");
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            query = query + "&filter=" + filter;
        }
        if (StringUtils.isNotEmpty((CharSequence)(startIndex = req.getParameter("start-index")))) {
            query = query + "&start-index=" + startIndex;
        }
        resp.sendRedirect("groups" + query);
    }

    private void render(Directory dir, HttpServletResponseFacade resp, Map<String, Object> model, SearchRestriction restriction, int startIndex) throws IOException {
        try {
            boolean isFirst;
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            int maxResults = 50;
            EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with(restriction).startingAt(startIndex).returningAtMost(maxResults);
            List groups = directoryManager.searchGroups(dir.getId().longValue(), groupQuery);
            ArrayList<CrowdGroupWrapper> wrappedGroups = new ArrayList<CrowdGroupWrapper>();
            for (InternalDirectoryGroup group : groups) {
                GroupWithAttributes groupWithAttributes = directoryManager.findGroupWithAttributesByName(dir.getId().longValue(), group.getName());
                CrowdGroupWrapper wrappedGroup = new CrowdGroupWrapper((Group)groupWithAttributes);
                wrappedGroups.add(wrappedGroup);
            }
            model.put("directoryGroups", wrappedGroups);
            model.put("firstIndex", startIndex + 1);
            model.put("lastIndex", Math.max(1, startIndex + groups.size()));
            boolean isMore = maxResults == groups.size();
            boolean bl = isFirst = startIndex == 0;
            if (isMore) {
                model.put("nextIndex", startIndex + groups.size());
            }
            if (!isFirst) {
                model.put("prevIndex", startIndex - maxResults);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/scim/groups.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

