/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.passwordlogin;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.utils.GroupSearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupsPasswordLoginServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PASSWORD_LOGIN_REQUIRED_GROUP = "requiredGroup";
    public static final String PASSWORD_LOGIN_ADDED_GROUP = "addedGroup";

    @Inject
    public GroupsPasswordLoginServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String query = req.getParameter("query");
        if (query != null) {
            GroupSearchUtil.printGroupsAsJson(resp, query, this.userManager);
        } else {
            Map<String, Object> model = this.newModel(req);
            model.put("topMenu", "dashboard");
            model.put("menuItem", "add-group-password-login");
            resp.setContentType("text/html");
            model.put("groupMappings", this.kerbConfManager.getPasswordLoginGroupAddMapping());
            this.renderer.render("templates/atlaskerb/passwordlogin/groups-to-password-login.vm", model, (Writer)resp.getWriter());
        }
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String action = req.getParameter("action");
        String requiredGroup = StringUtils.trim((String)req.getParameter(PASSWORD_LOGIN_REQUIRED_GROUP));
        String addedGroup = StringUtils.trim((String)req.getParameter(PASSWORD_LOGIN_ADDED_GROUP));
        if (StringUtils.isNotBlank((CharSequence)addedGroup)) {
            if ("save".equals(action)) {
                this.kerbConfManager.addPasswordGroupAddMapping(requiredGroup, addedGroup);
            }
            if ("delete".equals(action)) {
                this.kerbConfManager.removePasswordLoginGroupAddMapping(requiredGroup, addedGroup);
            }
        }
        resp.sendRedirect("add-group-password-login");
    }
}

