/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.Date;

public class LoginAttempt {
    private final String reason;
    private final String remoteIp;
    private final Throwable exception;
    private final String token;
    private final Date timestamp;
    private final String user;

    public LoginAttempt(String reason, String remoteIp, Throwable exception, String token, String user) {
        this.reason = reason;
        this.remoteIp = remoteIp;
        this.exception = exception;
        this.token = token;
        this.timestamp = new Date();
        this.user = user;
    }

    public String getReason() {
        return this.reason;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getToken() {
        return this.token;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public static Builder attempt(String reason, String remoteIp) {
        return new Builder(reason, remoteIp);
    }

    public static class Builder {
        private final String reason;
        private final String remoteIp;
        private Throwable exception;
        private String token;
        private String user;

        public Builder(String reason, String remoteIp) {
            this.reason = reason;
            this.remoteIp = remoteIp;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public LoginAttempt build() {
            return new LoginAttempt(this.reason, this.remoteIp, this.exception, this.token, this.user);
        }
    }
}

