/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos;

import java.security.Principal;
import java.util.Optional;

public class PrincipalEntry {
    private Principal principal;
    private final UserState searchResultState;

    public PrincipalEntry(Principal principal, UserState searchResult) {
        if (principal == null && searchResult == UserState.FOUND) {
            throw new IllegalStateException("PrincipalEntry for an active user with null principal set. Null principal is only allowed when user is inactive");
        }
        this.principal = principal;
        this.searchResultState = searchResult;
    }

    public Optional<Principal> getPrincipal() {
        return Optional.ofNullable(this.principal);
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public UserState getUserState() {
        return this.searchResultState;
    }

    public static enum UserState {
        FOUND,
        NOT_FOUND,
        INACTIVE;

    }
}

