/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ValidationUtils;

public class LoginPageCustomizationServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final IdpConfManager idpConfManager;

    public LoginPageCustomizationServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.renderView(req, resp, model);
    }

    private void renderView(HttpServletRequestFacade req, HttpServletResponseFacade resp, Map<String, Object> model) throws IOException {
        model.put("topMenu", "SAML");
        model.put("menuItem", "login-page-customization");
        model.put("shouldUseLegacyLoginExperience", this.hostApp.shouldUseLegacyLoginExperience());
        model.put("isUseIcon", this.idpConfManager.isUseIcon());
        model.put("baseIconUrl", req.getContextPath() + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/providers/");
        if (this.hostApp.isModificationOnGetSupported() && req.getMethod().equalsIgnoreCase("GET") || req.getMethod().equalsIgnoreCase("POST")) {
            this.idpConfManager.validateAndUpdateIdpDisplayPositions();
        }
        model.put("providers", this.idpConfManager.getIdentityProvidersSortedByLoginDisplayPosition());
        model.put("isAtLeastOneManualRedirect", this.idpConfManager.isAtLeastOneManualRedirect());
        model.put("sharedLoginTitle", this.kerbConfManager.getCustomSharedLoginTitle());
        model.put("sharedLoginSubtitle", this.kerbConfManager.getCustomSharedLoginSubtitle());
        model.put("sharedLoginAlternativeDivider", this.kerbConfManager.getCustomSharedLoginAlternativeDivider());
        model.put("sharedCannotLoginText", this.kerbConfManager.getCustomSharedCannotLoginText());
        model.put("automaticTraditionalLoginButtonText", this.kerbConfManager.getCustomAutomaticTraditionalLoginButtonText());
        model.put("manualUsernameLoginSubtitle", this.kerbConfManager.getCustomManualUsernameLoginSubtitle());
        model.put("manualUsernamePlaceholderText", this.kerbConfManager.getCustomManualUsernamePlaceholderText());
        model.put("manualContinueButtonText", this.kerbConfManager.getCustomManualContinueButtonText());
        model.put("redirectRedirectionText", this.kerbConfManager.getCustomRedirectRedirectionText());
        model.put("redirectCancelRedirectButtonText", this.kerbConfManager.getCustomRedirectCancelRedirectButtonText());
        model.put("redirectRedirectionHint", this.kerbConfManager.getCustomRedirectRedirectionHint());
        model.put("useSsoButtonText", this.kerbConfManager.getCustomAtlassianUseSsoButtonText());
        model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
        model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
        model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
        model.put("defaultSamlLoginUsernamePlaceholder", this.kerbConfManager.getDefaultSamlLoginUsernamePlaceholder());
        model.put("defaultErrorPageMessage", this.kerbConfManager.getDefaultErrorPageMessage());
        model.put("defaultUsernameFieldText", this.kerbConfManager.getDefaultUsernameFieldText());
        model.put("defaultNextButtonText", this.kerbConfManager.getDefaultNextButtonText());
        model.put("defaultIdpListTitleText", this.kerbConfManager.getDefaultIdpListTitleText());
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("customTextOnLoginPage", this.kerbConfManager.getCustomTextBoxOnLoginPageContent());
        model.put("isShowCustomTextBoxOnLoginPage", this.kerbConfManager.isCustomTextBoxOnLoginPageEnabled());
        model.put("websudoSsoEnabled", this.kerbConfManager.isWebsudoSSO());
        if (req.getParameter("tab") != null) {
            model.put("currentTab", req.getParameter("tab"));
        } else {
            model.put("currentTab", "idp");
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/login-page-customization/login-page-customization.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        String moveUpIdp;
        Map<String, Object> model = this.newModel(req);
        String sharedLoginTitle = req.getParameter("login-screen-title");
        String sharedLoginSubtitle = req.getParameter("sso-login-subtitle");
        String sharedLoginAlternativeDivider = req.getParameter("login-alternative-divider");
        String sharedLoginAlternativeDividerAtlassian = req.getParameter("login-alternative-divider-atlassian");
        String sharedCannotLoginText = req.getParameter("cannot-login-button");
        this.kerbConfManager.setCustomSharedLoginTitle(sharedLoginTitle);
        this.kerbConfManager.setCustomSharedLoginSubtitle(sharedLoginSubtitle);
        this.kerbConfManager.setCustomSharedLoginAlternativeDivider(this.kerbConfManager.getCustomSharedLoginAlternativeDivider().equals(sharedLoginAlternativeDivider) ? sharedLoginAlternativeDividerAtlassian : sharedLoginAlternativeDivider);
        this.kerbConfManager.setCustomSharedCannotLoginText(sharedCannotLoginText);
        String automaticTraditionalLoginButtonText = req.getParameter("traditional-login-button");
        this.kerbConfManager.setCustomAutomaticTraditionalLoginButtonText(automaticTraditionalLoginButtonText);
        String manualUsernameLoginSubtitle = req.getParameter("username-login-subtitle");
        String manualUsernamePlaceholderText = req.getParameter("username-placeholder-text");
        String manualContinueButtonText = req.getParameter("continue-button");
        this.kerbConfManager.setCustomManualUsernameLoginSubtitle(manualUsernameLoginSubtitle);
        this.kerbConfManager.setCustomManualUsernamePlaceholderText(manualUsernamePlaceholderText);
        this.kerbConfManager.setCustomManualContinueButtonText(manualContinueButtonText);
        String redirectRedirectionText = req.getParameter("redirection-text");
        String redirectCancelButtonText = req.getParameter("cancel-button");
        String redirectRedirectionHint = req.getParameter("progress-bar-hint");
        this.kerbConfManager.setCustomRedirectRedirectionText(redirectRedirectionText);
        this.kerbConfManager.setCustomRedirectCancelButtonText(redirectCancelButtonText);
        this.kerbConfManager.setCustomRedirectRedirectionHint(redirectRedirectionHint);
        String useSsoButtonText = req.getParameter("use-sso-button-text");
        this.kerbConfManager.setCustomAtlassianUseSsoButtonText(useSsoButtonText);
        String samlLoginUsernamePlaceholder = req.getParameter("samlLoginUsernamePlaceholder");
        String usernameFieldText = req.getParameter("usernameFieldText");
        String nextButtonText = req.getParameter("nextButtonText");
        String idpListTitleText = req.getParameter("idpListTitleText");
        String isShowCustomTextBoxOnLoginPage = req.getParameter("showCustomTextBoxOnLoginPage");
        this.kerbConfManager.setSamlLoginUsernamePlaceholder(StringUtils.trim((String)samlLoginUsernamePlaceholder));
        this.kerbConfManager.setUsernameFieldText(StringUtils.trim((String)usernameFieldText));
        this.kerbConfManager.setNextButtonText(StringUtils.trim((String)nextButtonText));
        this.kerbConfManager.setIdpListTitleText(StringUtils.trim((String)idpListTitleText));
        String moveDownIdp = req.getParameter("move-idp-down");
        if (moveDownIdp != null) {
            this.changeLoginPageDisplayPositions(moveDownIdp, false);
        }
        if ((moveUpIdp = req.getParameter("move-idp-up")) != null) {
            this.changeLoginPageDisplayPositions(moveUpIdp, true);
        }
        String customTextOnLoginPage = req.getParameter("customTextOnLoginPage");
        String errorMessage = req.getParameter("errorMessage");
        boolean skipHtmlValidation = StringUtils.isNotBlank((CharSequence)req.getParameter("skipHtmlValidation"));
        String websudoSsoEnabled = req.getParameter("websudoSsoEnabled");
        this.kerbConfManager.setWebsudoSSO(StringUtils.isNotBlank((CharSequence)websudoSsoEnabled));
        if (!this.kerbConfManager.getCustomTextBoxOnLoginPageContent().equals(StringUtils.trim((String)customTextOnLoginPage))) {
            if (ValidationUtils.isValidHtml((String)StringUtils.trim((String)customTextOnLoginPage)) || skipHtmlValidation) {
                this.kerbConfManager.setCustomTextBoxOnLoginPageContent(StringUtils.trim((String)customTextOnLoginPage));
            } else {
                model.put("invalidHtmlDoNotRender", customTextOnLoginPage);
            }
        }
        this.kerbConfManager.setCustomTextBoxOnLoginPageEnabled(StringUtils.isNotBlank((CharSequence)isShowCustomTextBoxOnLoginPage));
        this.kerbConfManager.setErrorPageMessage(StringUtils.trim((String)errorMessage));
        this.renderView(req, resp, model);
    }

    private void changeLoginPageDisplayPositions(String identityProviderId, boolean increasePosition) {
        IdpConfiguration selectedIdpConfiguration = this.idpConfManager.getIdentityProviderById(identityProviderId);
        if (selectedIdpConfiguration != null) {
            int currentPosition = selectedIdpConfiguration.getLoginPageDisplayPosition();
            int targetPosition = increasePosition ? currentPosition - 1 : currentPosition + 1;
            for (IdpConfiguration idpConfiguration : this.idpConfManager.getIdentityProviders()) {
                if (idpConfiguration == null || idpConfiguration.getLoginPageDisplayPosition() != targetPosition) continue;
                IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(idpConfiguration);
                builder.setLoginPageDisplayPosition(currentPosition);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
                IdpConfigurationBuilder<?, ?> selectedIdpBuilder = IdpConfigurationBuilder.ofGeneric(selectedIdpConfiguration);
                selectedIdpBuilder.setLoginPageDisplayPosition(targetPosition);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)selectedIdpBuilder.build());
                break;
            }
        }
        this.idpConfManager.validateAndUpdateIdpDisplayPositions();
    }
}

